/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.util.AcidUtils;

public class FromClause
extends StmtNode
implements Iterable<TableRef> {
    private final List<TableRef> tableRefs_;
    private boolean analyzed_ = false;

    public FromClause(List<TableRef> tableRefs) {
        this.tableRefs_ = Lists.newArrayList(tableRefs);
        for (int i = 1; i < this.tableRefs_.size(); ++i) {
            this.tableRefs_.get(i).setLeftTblRef(this.tableRefs_.get(i - 1));
        }
    }

    public FromClause() {
        this.tableRefs_ = new ArrayList<TableRef>();
    }

    public List<TableRef> getTableRefs() {
        return this.tableRefs_;
    }

    public boolean isAnalyzed() {
        return this.analyzed_;
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        boolean hasChanges = false;
        for (int i = 0; i < this.size(); ++i) {
            TableRef newRef;
            TableRef origRef = this.get(i);
            if (origRef instanceof InlineViewRef) {
                hasChanges |= ((InlineViewRef)origRef).getViewStmt().resolveTableMask(analyzer);
                if (!((InlineViewRef)origRef).isCatalogView()) continue;
            }
            if ((newRef = analyzer.resolveTableMask(origRef)) == origRef) continue;
            this.set(i, newRef);
            hasChanges = true;
            Preconditions.checkState((boolean)newRef.isTableMaskingView(), (Object)"resolved table mask should be a view");
        }
        return hasChanges;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.analyzed_) {
            return;
        }
        TableRef firstZippingUnnestRef = null;
        TableRef leftTblRef = null;
        boolean hasJoiningUnnest = false;
        for (int i = 0; i < this.tableRefs_.size(); ++i) {
            TableRef tblRef = this.tableRefs_.get(i);
            tblRef = analyzer.resolveTableRef(tblRef);
            this.tableRefs_.set(i, (TableRef)Preconditions.checkNotNull((Object)tblRef));
            tblRef.setLeftTblRef(leftTblRef);
            tblRef.analyze(analyzer);
            leftTblRef = tblRef;
            if (!(tblRef instanceof CollectionTableRef)) continue;
            this.checkIcebergCollectionSupport((CollectionTableRef)tblRef);
            this.checkTopLevelComplexAcidScan(analyzer, (CollectionTableRef)tblRef);
            if (firstZippingUnnestRef != null && tblRef.isZippingUnnest() && firstZippingUnnestRef.getResolvedPath().getRootTable() != tblRef.getResolvedPath().getRootTable()) {
                throw new AnalysisException("Not supported to do zipping unnest on arrays from different tables.");
            }
            if (!tblRef.isZippingUnnest()) {
                hasJoiningUnnest = true;
                continue;
            }
            if (!this.isPathForArrayType(tblRef)) {
                throw new AnalysisException("Unnest operator is only supported for arrays. " + ToSqlUtils.getPathSql(tblRef.getPath()));
            }
            if (firstZippingUnnestRef == null) {
                firstZippingUnnestRef = tblRef;
            }
            analyzer.addZippingUnnestTupleId((CollectionTableRef)tblRef);
            analyzer.increaseZippingUnnestCount();
        }
        if (hasJoiningUnnest && firstZippingUnnestRef != null) {
            throw new AnalysisException("Providing zipping and joining unnests together is not supported.");
        }
        this.analyzed_ = true;
    }

    private boolean isPathForArrayType(TableRef tblRef) {
        Preconditions.checkNotNull((Object)tblRef);
        Preconditions.checkState((!tblRef.getResolvedPath().getMatchedTypes().isEmpty() ? 1 : 0) != 0);
        Type resolvedType = tblRef.getResolvedPath().getMatchedTypes().get(tblRef.getResolvedPath().getMatchedTypes().size() - 1);
        return resolvedType.isArrayType();
    }

    public void collectFromClauseTableRefs(List<TableRef> tblRefs) {
        this.collectTableRefs(tblRefs, true);
    }

    public void collectTableRefs(List<TableRef> tblRefs) {
        this.collectTableRefs(tblRefs, false);
    }

    private void collectTableRefs(List<TableRef> tblRefs, boolean fromClauseOnly) {
        for (TableRef tblRef : this.tableRefs_) {
            if (tblRef instanceof InlineViewRef) {
                InlineViewRef inlineViewRef = (InlineViewRef)tblRef;
                inlineViewRef.getViewStmt().collectTableRefs(tblRefs, fromClauseOnly);
                continue;
            }
            tblRefs.add(tblRef);
        }
    }

    private void checkTopLevelComplexAcidScan(Analyzer analyzer, CollectionTableRef collRef) {
        if (collRef.getCollectionExpr() != null) {
            return;
        }
        if (collRef.getTable() == null) {
            return;
        }
        if (!AcidUtils.isFullAcidTable(collRef.getTable().getMetaStoreTable().getParameters())) {
            return;
        }
        analyzer.setHasTopLevelAcidCollectionTableRef();
    }

    private void checkIcebergCollectionSupport(CollectionTableRef tblRef) throws AnalysisException {
        Preconditions.checkNotNull((Object)tblRef);
        Preconditions.checkNotNull((Object)tblRef.getDesc());
        Preconditions.checkNotNull((Object)tblRef.getDesc().getPath());
        Preconditions.checkNotNull((Object)tblRef.getDesc().getPath().getRootTable());
        if (tblRef.getDesc().getPath().getRootTable() instanceof IcebergMetadataTable) {
            throw new AnalysisException("Querying collection types (ARRAY/MAP) in FROM clause is not supported for Iceberg Metadata tables.");
        }
    }

    public FromClause clone() {
        ArrayList<TableRef> clone = new ArrayList<TableRef>();
        for (TableRef tblRef : this.tableRefs_) {
            clone.add(tblRef.clone());
        }
        return new FromClause(clone);
    }

    public void reset() {
        for (int i = 0; i < this.size(); ++i) {
            TableRef origTblRef = this.get(i);
            if (origTblRef.isResolved() && !(origTblRef instanceof InlineViewRef)) {
                TableRef newTblRef = new TableRef(origTblRef);
                Path oldPath = origTblRef.getResolvedPath();
                if (oldPath.getRootDesc() == null || !oldPath.getRootDesc().getType().isCollectionStructType()) {
                    newTblRef.rawPath_ = oldPath.getFullyQualifiedRawPath();
                }
                this.set(i, newTblRef);
            }
            this.get(i).reset();
        }
        this.analyzed_ = false;
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder builder = new StringBuilder();
        if (!this.tableRefs_.isEmpty()) {
            builder.append(" FROM ");
            for (int i = 0; i < this.tableRefs_.size(); ++i) {
                TableRef tblRef = this.tableRefs_.get(i);
                if (tblRef.getZippingUnnestType() == TableRef.ZippingUnnestType.FROM_CLAUSE_ZIPPING_UNNEST) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append("UNNEST(");
                    boolean first = true;
                    while (i < this.tableRefs_.size() && tblRef.getZippingUnnestType() == TableRef.ZippingUnnestType.FROM_CLAUSE_ZIPPING_UNNEST) {
                        if (!first) {
                            builder.append(", ");
                        }
                        if (first) {
                            first = false;
                        }
                        builder.append(ToSqlUtils.getPathSql(tblRef.getPath()));
                        if (++i >= this.tableRefs_.size()) continue;
                        tblRef = this.tableRefs_.get(i);
                    }
                    builder.append(")");
                }
                if (i >= this.tableRefs_.size()) break;
                builder.append(tblRef.toSql(options));
            }
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.tableRefs_.isEmpty();
    }

    @Override
    public Iterator<TableRef> iterator() {
        return this.tableRefs_.iterator();
    }

    public int size() {
        return this.tableRefs_.size();
    }

    public TableRef get(int i) {
        return this.tableRefs_.get(i);
    }

    public void set(int i, TableRef tableRef) {
        this.tableRefs_.set(i, tableRef);
    }

    public void add(TableRef t) {
        this.tableRefs_.add(t);
    }

    public void add(int i, TableRef t) {
        this.tableRefs_.add(i, t);
    }
}

