/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExtractField;

public class ExtractFromExpr
extends FunctionCallExpr {
    private static final Set<String> TIMESTAMP_EXTRACT_FIELDS;
    private static final Set<String> DATE_EXTRACT_FIELDS;

    public ExtractFromExpr(FunctionName fnName, String extractFieldIdent, Expr e) {
        super(fnName, (List<Expr>)Lists.newArrayList((Object[])new Expr[]{e, new StringLiteral(extractFieldIdent)}));
        this.type_ = Type.INT;
    }

    protected ExtractFromExpr(ExtractFromExpr other) {
        super(other);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        boolean isExtractFieldValid;
        this.getFnName().analyze(analyzer);
        if (!this.getFnName().getFunction().equals("extract")) {
            throw new AnalysisException("Function " + this.getFnName().getFunction().toUpperCase() + " does not accept the keyword FROM.");
        }
        if (this.getFnName().getDb() != null && !this.getFnName().getDb().equals("_impala_builtins")) {
            throw new AnalysisException("Function " + this.getFnName().toString() + " conflicts with the EXTRACT builtin.");
        }
        super.analyzeImpl(analyzer);
        String extractFieldIdent = ((StringLiteral)this.children_.get(1)).getValueWithOriginalEscapes();
        Preconditions.checkNotNull((Object)extractFieldIdent);
        boolean isDate = ((Expr)this.children_.get(0)).getType().isDate();
        boolean bl = isExtractFieldValid = isDate ? DATE_EXTRACT_FIELDS.contains(extractFieldIdent.toUpperCase()) : TIMESTAMP_EXTRACT_FIELDS.contains(extractFieldIdent.toUpperCase());
        if (!isExtractFieldValid) {
            String validExtractFields = Joiner.on((String)", ").join(isDate ? DATE_EXTRACT_FIELDS : TIMESTAMP_EXTRACT_FIELDS);
            throw new AnalysisException("Time unit '" + extractFieldIdent + "' in expression '" + this.toSql() + "' is invalid. Expected one of " + validExtractFields + ".");
        }
    }

    @Override
    protected String getFunctionNotFoundError(Type[] argTypes) {
        Expr e = (Expr)this.children_.get(0);
        return "Expression '" + e.toSql() + "' in '" + this.toSql() + "' has a return type of " + e.getType().toSql() + " but a TIMESTAMP or DATE is required.";
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.getFnName().toString().toUpperCase());
        strBuilder.append("(");
        strBuilder.append(((StringLiteral)this.getChild(1)).getValueWithOriginalEscapes());
        strBuilder.append(" FROM ");
        strBuilder.append(((Expr)this.getChild(0)).toSql(options));
        strBuilder.append(")");
        return strBuilder.toString();
    }

    @Override
    public Expr clone() {
        return new ExtractFromExpr(this);
    }

    static {
        ImmutableSet.Builder timestamp_builder = new ImmutableSet.Builder();
        ImmutableSet.Builder date_builder = new ImmutableSet.Builder();
        for (TExtractField extractField : TExtractField.values()) {
            if (extractField == TExtractField.INVALID_FIELD) continue;
            timestamp_builder.add((Object)extractField.name());
            if (extractField == TExtractField.HOUR || extractField == TExtractField.MINUTE || extractField == TExtractField.SECOND || extractField == TExtractField.MILLISECOND || extractField == TExtractField.EPOCH) continue;
            date_builder.add((Object)extractField.name());
        }
        TIMESTAMP_EXTRACT_FIELDS = timestamp_builder.build();
        DATE_EXTRACT_FIELDS = date_builder.build();
    }
}

