/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;

public class ExistsPredicate
extends Predicate {
    private boolean notExists_ = false;

    public boolean isNotExists() {
        return this.notExists_;
    }

    public ExistsPredicate(Subquery subquery, boolean notExists) {
        Preconditions.checkNotNull((Object)subquery);
        this.children_.add(subquery);
        this.notExists_ = notExists;
    }

    @Override
    public Expr negate() {
        return new ExistsPredicate((Subquery)this.getChild(0), !this.notExists_);
    }

    public ExistsPredicate(ExistsPredicate other) {
        super(other);
        this.notExists_ = other.notExists_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        ((Subquery)this.children_.get(0)).getStatement().setIsRuntimeScalar(false);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        Preconditions.checkState((boolean)false);
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && this.notExists_ == ((ExistsPredicate)that).notExists_;
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.notExists_);
    }

    @Override
    public Expr clone() {
        return new ExistsPredicate(this);
    }

    @Override
    protected float computeEvalCost() {
        return -1.0f;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        StringBuilder strBuilder = new StringBuilder();
        if (this.notExists_) {
            strBuilder.append("NOT ");
        }
        strBuilder.append("EXISTS ");
        strBuilder.append(((Expr)this.getChild(0)).toSql(options));
        return strBuilder.toString();
    }

    @Override
    public boolean shouldConvertToCNF() {
        return false;
    }
}

