/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TDropTableOrViewParams;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.MetaStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableOrViewStmt
extends StatementBase {
    private static final Logger LOG = LoggerFactory.getLogger(DropTableOrViewStmt.class);
    protected final TableName tableName_;
    protected final boolean ifExists_;
    protected final boolean dropTable_;
    protected final boolean purgeTable_;
    protected String dbName_;
    private String serverName_;

    public DropTableOrViewStmt(TableName tableName, boolean ifExists, boolean dropTable, boolean purgeTable) {
        this.tableName_ = (TableName)Preconditions.checkNotNull((Object)tableName);
        this.ifExists_ = ifExists;
        this.dropTable_ = dropTable;
        this.purgeTable_ = purgeTable;
        Preconditions.checkState((this.dropTable_ || !this.purgeTable_ ? 1 : 0) != 0);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("DROP " + (this.dropTable_ ? "TABLE " : "VIEW "));
        if (this.ifExists_) {
            sb.append("IF EXISTS ");
        }
        if (this.tableName_.getDb() != null) {
            sb.append(this.tableName_.getDb() + ".");
        }
        sb.append(this.tableName_.getTbl());
        if (this.purgeTable_) {
            sb.append(" PURGE");
        }
        return sb.toString();
    }

    public TDropTableOrViewParams toThrift() {
        TDropTableOrViewParams params = new TDropTableOrViewParams();
        params.setTable_name(new TTableName(this.getDb(), this.getTbl()));
        params.setIf_exists(this.ifExists_);
        params.setPurge(this.purgeTable_);
        params.setIs_table(this.dropTable_);
        params.setServer_name(this.serverName_);
        return params;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.dbName_ = analyzer.getTargetDbName(this.tableName_);
        this.serverName_ = analyzer.getServerName();
        try {
            String tblOwnerUser;
            FeTable table = analyzer.getTableNoThrow(this.dbName_, this.tableName_.getTbl());
            String string = tblOwnerUser = table == null ? null : table.getOwnerUser();
            if (this.ifExists_) {
                analyzer.registerPrivReq(builder -> builder.allOf(Privilege.ANY).onTable(this.dbName_, this.getTbl(), tblOwnerUser).build());
                if (table == null) {
                    return;
                }
            }
            table = analyzer.getTable(this.tableName_, true, false, Privilege.DROP);
            Preconditions.checkNotNull((Object)table);
            if (table instanceof FeView && this.dropTable_) {
                if (this.ifExists_) {
                    return;
                }
                throw new AnalysisException(String.format("DROP TABLE not allowed on a view: %s.%s", this.dbName_, this.getTbl()));
            }
            if (!(table instanceof FeView) && !this.dropTable_) {
                if (this.ifExists_) {
                    return;
                }
                throw new AnalysisException(String.format("DROP VIEW not allowed on a table: %s.%s", this.dbName_, this.getTbl()));
            }
            if (this.dropTable_ && !MetaStoreUtil.isBucketedTable(table.getMetaStoreTable())) {
                Analyzer.checkTableCapability(table, Analyzer.OperationType.WRITE);
            }
        }
        catch (TableLoadingException e) {
            analyzer.addAccessEvent(new TAccessEvent(analyzer.getFqTableName(this.tableName_).toString(), TCatalogObjectType.TABLE, Privilege.DROP.toString()));
            LOG.info("Ignoring TableLoadingException for {}", (Object)this.tableName_);
        }
    }

    public String getDb() {
        Preconditions.checkNotNull((Object)this.dbName_);
        return this.dbName_;
    }

    public String getTbl() {
        return this.tableName_.getTbl();
    }

    public boolean isDropTable() {
        return this.dropTable_;
    }
}

