/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TDropDbParams;

public class DropDbStmt
extends StatementBase {
    private final String dbName_;
    private final boolean ifExists_;
    private final boolean cascade_;
    private String serverName_;

    public DropDbStmt(String dbName, boolean ifExists, boolean cascade) {
        this.dbName_ = dbName;
        this.ifExists_ = ifExists;
        this.cascade_ = cascade;
    }

    public String getDb() {
        return this.dbName_;
    }

    public boolean getIfExists() {
        return this.ifExists_;
    }

    public boolean getCascade() {
        return this.cascade_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("DROP DATABASE");
        if (this.ifExists_) {
            sb.append(" IF EXISTS ");
        }
        sb.append(this.getDb());
        if (this.cascade_) {
            sb.append(" CASCADE");
        }
        return sb.toString();
    }

    public TDropDbParams toThrift() {
        TDropDbParams params = new TDropDbParams();
        params.setDb(this.getDb());
        params.setIf_exists(this.getIfExists());
        params.setCascade(this.getCascade());
        params.setServer_name(this.serverName_);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        String ownerUser;
        this.serverName_ = analyzer.getServerName();
        FeDb db = analyzer.getDb(this.dbName_, false);
        String string = ownerUser = db == null ? null : db.getOwnerUser();
        if (this.ifExists_) {
            analyzer.registerPrivReq(builder -> builder.allOf(Privilege.ANY).onDb(this.dbName_, ownerUser).build());
            if (!analyzer.dbExists(this.dbName_)) {
                return;
            }
        }
        if ((db = analyzer.getDb(this.dbName_, Privilege.DROP, false, false)) == null && !this.ifExists_) {
            throw new AnalysisException("Database does not exist: " + this.dbName_);
        }
        if (analyzer.getDefaultDb().toLowerCase().equals(this.dbName_.toLowerCase())) {
            throw new AnalysisException("Cannot drop current default database: " + this.dbName_);
        }
        if (db != null && db.numFunctions() > 0 && !this.cascade_) {
            throw new AnalysisException("Cannot drop non-empty database: " + this.dbName_);
        }
    }
}

