/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TDropDataSourceParams;

public class DropDataSrcStmt
extends StatementBase {
    private final String dataSrcName_;
    private final boolean ifExists_;

    public DropDataSrcStmt(String dataSrcName, boolean ifExists) {
        Preconditions.checkNotNull((Object)dataSrcName);
        this.dataSrcName_ = dataSrcName.toLowerCase();
        this.ifExists_ = ifExists;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (!MetastoreShim.validateName(this.dataSrcName_) || !this.ifExists_ && analyzer.getCatalog().getDataSource(this.dataSrcName_) == null) {
            throw new AnalysisException("Data source does not exist: " + this.dataSrcName_);
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP DATA SOURCE ");
        if (this.ifExists_) {
            sb.append("IF EXISTS ");
        }
        sb.append(this.dataSrcName_);
        return sb.toString();
    }

    public TDropDataSourceParams toThrift() {
        return new TDropDataSourceParams(this.dataSrcName_).setIf_exists(this.ifExists_);
    }
}

