/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TDescribeOutputStyle;
import org.apache.impala.thrift.TDescribeTableParams;

public class DescribeTableStmt
extends StatementBase {
    private final TDescribeOutputStyle outputStyle_;
    private final List<String> rawPath_;
    private Path path_;
    private FeTable table_;
    private StructType resultStruct_;

    public DescribeTableStmt(List<String> rawPath, TDescribeOutputStyle outputStyle) {
        Preconditions.checkNotNull(rawPath);
        Preconditions.checkArgument((!rawPath.isEmpty() ? 1 : 0) != 0);
        this.rawPath_ = rawPath;
        this.outputStyle_ = outputStyle;
        this.path_ = null;
        this.resultStruct_ = null;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("DESCRIBE ");
        if (this.outputStyle_ != TDescribeOutputStyle.MINIMAL) {
            sb.append(this.outputStyle_.toString() + " ");
        }
        return sb.toString() + StringUtils.join(this.rawPath_, (String)".");
    }

    public FeTable getTable() {
        return this.table_;
    }

    public TDescribeOutputStyle getOutputStyle() {
        return this.outputStyle_;
    }

    public boolean targetsTable() {
        Preconditions.checkState((boolean)this.isAnalyzed());
        return this.path_.destTable() != null;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.rawPath_, null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        try {
            this.path_ = analyzer.resolvePath(this.rawPath_, Path.PathType.ANY);
        }
        catch (AnalysisException ae) {
            if (this.rawPath_.size() > 1) {
                analyzer.registerPrivReq(builder -> builder.onTableUnknownOwner(this.rawPath_.get(0), this.rawPath_.get(1)).any().build());
            }
            analyzer.registerPrivReq(builder -> builder.onTableUnknownOwner(analyzer.getDefaultDb(), this.rawPath_.get(0)).any().build());
            throw ae;
        }
        catch (TableLoadingException tle) {
            throw new AnalysisException(tle.getMessage(), tle);
        }
        this.table_ = this.path_.getRootTable();
        analyzer.getTable(this.table_.getTableName(), true, Privilege.ANY);
        this.checkMinimalForIcebergMetadataTable();
        if (!this.targetsTable()) {
            this.analyzeComplexType(analyzer);
        }
    }

    private void analyzeComplexType(Analyzer analyzer) throws AnalysisException {
        analyzer.registerPrivReq(builder -> builder.onColumn(this.path_.getRootTable().getDb().getName(), this.path_.getRootTable().getName(), this.path_.getRawPath().get(0), this.path_.getRootTable().getOwnerUser()).any().build());
        if (!this.path_.destType().isComplexType()) {
            throw new AnalysisException("Cannot describe path '" + Joiner.on((char)'.').join(this.rawPath_) + "' targeting scalar type: " + this.path_.destType().toSql());
        }
        if (this.outputStyle_ == TDescribeOutputStyle.FORMATTED || this.outputStyle_ == TDescribeOutputStyle.EXTENDED) {
            throw new AnalysisException("DESCRIBE FORMATTED|EXTENDED must refer to a table");
        }
        Preconditions.checkState((this.outputStyle_ == TDescribeOutputStyle.MINIMAL ? 1 : 0) != 0);
        this.resultStruct_ = Path.getTypeAsStruct(this.path_.destType());
    }

    private void checkMinimalForIcebergMetadataTable() throws AnalysisException {
        if (this.table_ instanceof IcebergMetadataTable && this.outputStyle_ != TDescribeOutputStyle.MINIMAL) {
            throw new AnalysisException("DESCRIBE FORMATTED|EXTENDED cannot refer to a metadata table.");
        }
    }

    public TDescribeTableParams toThrift() {
        TDescribeTableParams params = new TDescribeTableParams();
        params.setOutput_style(this.outputStyle_);
        if (this.resultStruct_ != null) {
            params.setResult_struct(this.resultStruct_.toThrift());
        } else {
            Preconditions.checkNotNull((Object)this.table_);
            params.setTable_name(this.table_.getTableName().toThrift());
            if (this.table_ instanceof IcebergMetadataTable) {
                params.setMetadata_table_name(((IcebergMetadataTable)this.table_).getMetadataTableName());
            }
        }
        return params;
    }
}

