/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TDescribeDbParams;
import org.apache.impala.thrift.TDescribeOutputStyle;

public class DescribeDbStmt
extends StatementBase {
    private final TDescribeOutputStyle outputStyle_;
    private final String dbName_;

    public DescribeDbStmt(String dbName, TDescribeOutputStyle outputStyle) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0, (Object)"Invalid database name");
        this.dbName_ = dbName;
        this.outputStyle_ = outputStyle;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("DESCRIBE DATABASE ");
        if (this.outputStyle_ != TDescribeOutputStyle.MINIMAL) {
            sb.append(this.outputStyle_.toString() + " ");
        }
        return sb.toString() + this.dbName_;
    }

    public String getDb() {
        return this.dbName_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        analyzer.getDb(this.dbName_, Privilege.VIEW_METADATA);
    }

    public TDescribeDbParams toThrift() {
        TDescribeDbParams params = new TDescribeDbParams();
        params.setDb(this.dbName_);
        params.setOutput_style(this.outputStyle_);
        return params;
    }
}

