/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.CreateOrAlterViewStmtBase;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TCatalogObjectType;

public class CreateViewStmt
extends CreateOrAlterViewStmtBase {
    public CreateViewStmt(boolean ifNotExists, TableName tableName, List<ColumnDef> columnDefs, String comment, Map<String, String> tblpropertiesMap, QueryStmt viewDefStmt) {
        super(ifNotExists, tableName, columnDefs, comment, tblpropertiesMap, viewDefStmt);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.tableName_ != null && !this.tableName_.isEmpty() ? 1 : 0) != 0);
        analyzer.getFqTableName(this.tableName_).analyze();
        Analyzer viewAnalyzerr = new Analyzer(analyzer);
        viewAnalyzerr.setUseHiveColLabels(true);
        this.viewDefStmt_.analyze(viewAnalyzerr);
        this.dbName_ = analyzer.getTargetDbName(this.tableName_);
        this.owner_ = analyzer.getUserShortName();
        this.serverName_ = analyzer.getServerName();
        if (analyzer.dbContainsTable(this.dbName_, this.tableName_.getTbl(), Privilege.CREATE) && !this.ifNotExists_) {
            throw new AnalysisException("View already exists: " + String.format("%s.%s", this.dbName_, this.tableName_.getTbl()));
        }
        analyzer.addAccessEvent(new TAccessEvent(this.dbName_ + "." + this.tableName_.getTbl(), TCatalogObjectType.VIEW, Privilege.CREATE.toString()));
        this.createColumnAndViewDefs(analyzer);
        if (BackendConfig.INSTANCE.getComputeLineage() || RuntimeEnv.INSTANCE.isTestEnv()) {
            this.computeLineageGraph(analyzer);
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE VIEW ");
        if (this.ifNotExists_) {
            sb.append("IF NOT EXISTS ");
        }
        if (this.tableName_.getDb() != null) {
            sb.append(this.tableName_.getDb() + ".");
        }
        sb.append(this.tableName_.getTbl());
        if (this.columnDefs_ != null) {
            sb.append("(" + this.getColumnNames() + ")");
        }
        if (this.tblPropertyMap_ != null && !this.tblPropertyMap_.isEmpty()) {
            sb.append(" TBLPROPERTIES " + this.getTblProperties());
        }
        sb.append(" AS ");
        sb.append(this.viewDefStmt_.toSql(options));
        return sb.toString();
    }
}

