/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CreateFunctionStmtBase;
import org.apache.impala.analysis.FunctionArgs;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TSymbolType;

public class CreateUdaStmt
extends CreateFunctionStmtBase {
    private final TypeDef intermediateTypeDef_;

    public CreateUdaStmt(FunctionName fnSymbol, FunctionArgs args, TypeDef retTypeDef, TypeDef intermediateTypeDef, HdfsUri location, boolean ifNotExists, Map<CreateFunctionStmtBase.OptArg, String> optArgs) {
        super(fnSymbol, args, retTypeDef, location, ifNotExists, optArgs);
        this.intermediateTypeDef_ = intermediateTypeDef;
    }

    private void reportCouldNotInferSymbol(String function) throws AnalysisException {
        throw new AnalysisException("Could not infer symbol for " + function + "() function.");
    }

    private String getSymbolSymbol(CreateFunctionStmtBase.OptArg arg, String defaultSymbol) {
        if (this.optArgs_.get((Object)arg) != null) {
            return (String)this.optArgs_.get((Object)arg);
        }
        String updateFn = (String)this.optArgs_.get((Object)CreateFunctionStmtBase.OptArg.UPDATE_FN);
        if (updateFn.startsWith("_Z")) {
            return null;
        }
        if (updateFn.contains("update")) {
            return updateFn.replace("update", defaultSymbol);
        }
        if (updateFn.contains("Update")) {
            char[] array = defaultSymbol.toCharArray();
            array[0] = Character.toUpperCase(array[0]);
            String s = new String(array);
            return updateFn.replace("Update", s);
        }
        return null;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        Preconditions.checkNotNull((Object)this.fn_);
        Preconditions.checkState((boolean)(this.fn_ instanceof AggregateFunction));
        AggregateFunction uda = (AggregateFunction)this.fn_;
        if (uda.getNumArgs() == 0) {
            throw new AnalysisException("UDAs must take at least one argument.");
        }
        if (uda.getBinaryType() == TFunctionBinaryType.JAVA) {
            throw new AnalysisException("Java UDAs are not supported.");
        }
        if (uda.getBinaryType() == TFunctionBinaryType.IR) {
            throw new AnalysisException("IR UDAs are not yet supported.");
        }
        if (this.fn_.hasVarArgs()) {
            throw new AnalysisException("UDAs with varargs are not yet supported.");
        }
        if (this.fn_.getNumArgs() > 8) {
            throw new AnalysisException("UDAs with more than 8 arguments are not yet supported.");
        }
        if (uda.getReturnType().getPrimitiveType() == PrimitiveType.CHAR) {
            throw new AnalysisException("UDAs with CHAR return type are not yet supported.");
        }
        if (uda.getReturnType().getPrimitiveType() == PrimitiveType.VARCHAR) {
            throw new AnalysisException("UDAs with VARCHAR return type are not yet supported.");
        }
        for (int i = 0; i < uda.getNumArgs(); ++i) {
            if (uda.getArgs()[i].getPrimitiveType() == PrimitiveType.CHAR) {
                throw new AnalysisException("UDAs with CHAR arguments are not yet supported.");
            }
            if (uda.getArgs()[i].getPrimitiveType() != PrimitiveType.VARCHAR) continue;
            throw new AnalysisException("UDAs with VARCHAR arguments are not yet supported.");
        }
        Type intermediateType = null;
        if (this.intermediateTypeDef_ == null) {
            intermediateType = uda.getReturnType();
        } else {
            this.intermediateTypeDef_.analyze(analyzer);
            intermediateType = this.intermediateTypeDef_.getType();
        }
        uda.setIntermediateType(intermediateType);
        this.checkOptArgNotSet(CreateFunctionStmtBase.OptArg.SYMBOL);
        this.checkOptArgNotSet(CreateFunctionStmtBase.OptArg.PREPARE_FN);
        this.checkOptArgNotSet(CreateFunctionStmtBase.OptArg.CLOSE_FN);
        uda.setUpdateFnSymbol(uda.lookupSymbol(this.checkAndGetOptArg(CreateFunctionStmtBase.OptArg.UPDATE_FN), TSymbolType.UDF_EVALUATE, intermediateType, uda.hasVarArgs(), uda.getArgs()));
        Preconditions.checkNotNull((Object)uda.getUpdateFnSymbol());
        uda.setInitFnSymbol(this.getSymbolSymbol(CreateFunctionStmtBase.OptArg.INIT_FN, "init"));
        uda.setSerializeFnSymbol(this.getSymbolSymbol(CreateFunctionStmtBase.OptArg.SERIALIZE_FN, "serialize"));
        uda.setMergeFnSymbol(this.getSymbolSymbol(CreateFunctionStmtBase.OptArg.MERGE_FN, "merge"));
        uda.setFinalizeFnSymbol(this.getSymbolSymbol(CreateFunctionStmtBase.OptArg.FINALIZE_FN, "finalize"));
        if (uda.getInitFnSymbol() == null) {
            this.reportCouldNotInferSymbol("init");
        }
        if (uda.getMergeFnSymbol() == null) {
            this.reportCouldNotInferSymbol("merge");
        }
        uda.setInitFnSymbol(uda.lookupSymbol(uda.getInitFnSymbol(), TSymbolType.UDF_EVALUATE, intermediateType, false, new Type[0]));
        uda.setMergeFnSymbol(uda.lookupSymbol(uda.getMergeFnSymbol(), TSymbolType.UDF_EVALUATE, intermediateType, false, intermediateType));
        if (uda.getSerializeFnSymbol() != null) {
            try {
                uda.setSerializeFnSymbol(uda.lookupSymbol(uda.getSerializeFnSymbol(), TSymbolType.UDF_EVALUATE, null, false, intermediateType));
            }
            catch (AnalysisException e) {
                if (this.optArgs_.get((Object)CreateFunctionStmtBase.OptArg.SERIALIZE_FN) != null) {
                    throw e;
                }
                uda.setSerializeFnSymbol(null);
            }
        }
        if (uda.getFinalizeFnSymbol() != null) {
            try {
                uda.setFinalizeFnSymbol(uda.lookupSymbol(uda.getFinalizeFnSymbol(), TSymbolType.UDF_EVALUATE, null, false, intermediateType));
            }
            catch (AnalysisException e) {
                if (this.optArgs_.get((Object)CreateFunctionStmtBase.OptArg.FINALIZE_FN) != null) {
                    throw e;
                }
                uda.setFinalizeFnSymbol(null);
            }
        }
        if (!intermediateType.equals(this.fn_.getReturnType()) && uda.getFinalizeFnSymbol() == null) {
            throw new AnalysisException("Finalize() is required for this UDA.");
        }
        this.sqlString_ = uda.toSql(this.ifNotExists_);
    }

    @Override
    protected Function createFunction(FunctionName fnName, List<Type> argTypes, Type retType, boolean hasVarArgs) {
        return new AggregateFunction(this.fnName_, this.args_.getArgTypes(), this.retTypeDef_.getType(), this.args_.hasVarArgs());
    }
}

