/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.impala.analysis.AnalysisUtils;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.ColumnLineageGraph;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.HdfsCachingOp;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.IcebergPartitionTransform;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TableDef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.RowFormat;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TBucketInfo;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TCreateTableParams;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergFileFormat;
import org.apache.impala.thrift.TIcebergPartitionTransformType;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.AvroSchemaConverter;
import org.apache.impala.util.AvroSchemaParser;
import org.apache.impala.util.AvroSchemaUtils;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.KuduUtil;
import org.apache.impala.util.MetaStoreUtil;

public class CreateTableStmt
extends StatementBase {
    @VisibleForTesting
    static final String KUDU_STORAGE_HANDLER_ERROR_MESSAGE = "Kudu tables must be specified using 'STORED AS KUDU'.";
    private final TableDef tableDef_;
    private String owner_;
    private String serverName_;

    public CreateTableStmt(TableDef tableDef) {
        Preconditions.checkNotNull((Object)tableDef);
        this.tableDef_ = tableDef;
    }

    public CreateTableStmt(CreateTableStmt other) {
        this(other.tableDef_);
        this.owner_ = other.owner_;
    }

    @Override
    public void reset() {
        super.reset();
        this.tableDef_.reset();
    }

    @Override
    public CreateTableStmt clone() {
        return new CreateTableStmt(this);
    }

    public String getTbl() {
        return this.getTblName().getTbl();
    }

    public TableName getTblName() {
        return this.tableDef_.getTblName();
    }

    public boolean getIfNotExists() {
        return this.tableDef_.getIfNotExists();
    }

    public List<ColumnDef> getColumnDefs() {
        return this.tableDef_.getColumnDefs();
    }

    private void setColumnDefs(List<ColumnDef> colDefs) {
        this.getColumnDefs().clear();
        this.getColumnDefs().addAll(colDefs);
    }

    public List<ColumnDef> getPrimaryKeyColumnDefs() {
        return this.tableDef_.getPrimaryKeyColumnDefs();
    }

    public boolean isPrimaryKeyUnique() {
        return this.tableDef_.isPrimaryKeyUnique();
    }

    public List<SQLPrimaryKey> getPrimaryKeys() {
        return this.tableDef_.getSqlPrimaryKeys();
    }

    public List<SQLForeignKey> getForeignKeys() {
        return this.tableDef_.getSqlForeignKeys();
    }

    public boolean isExternal() {
        return this.tableDef_.isExternal();
    }

    public List<ColumnDef> getPartitionColumnDefs() {
        return this.tableDef_.getPartitionColumnDefs();
    }

    public List<KuduPartitionParam> getKuduPartitionParams() {
        return this.tableDef_.getKuduPartitionParams();
    }

    public List<String> getSortColumns() {
        return this.tableDef_.getSortColumns();
    }

    public TSortingOrder getSortingOrder() {
        return this.tableDef_.getSortingOrder();
    }

    public String getComment() {
        return this.tableDef_.getComment();
    }

    public Map<String, String> getTblProperties() {
        return this.tableDef_.getTblProperties();
    }

    private HdfsCachingOp getCachingOp() {
        return this.tableDef_.getCachingOp();
    }

    public HdfsUri getLocation() {
        return this.tableDef_.getLocation();
    }

    Map<String, String> getSerdeProperties() {
        return this.tableDef_.getSerdeProperties();
    }

    public THdfsFileFormat getFileFormat() {
        return this.tableDef_.getFileFormat();
    }

    RowFormat getRowFormat() {
        return this.tableDef_.getRowFormat();
    }

    private void putGeneratedProperty(String key, String value) {
        this.tableDef_.putGeneratedProperty(key, value);
    }

    public Map<String, String> getGeneratedKuduProperties() {
        return this.tableDef_.getGeneratedProperties();
    }

    public TBucketInfo geTBucketInfo() {
        return this.tableDef_.geTBucketInfo();
    }

    List<String> getTblPrimaryKeyColumnNames() {
        return this.tableDef_.getPrimaryKeyColumnNames();
    }

    public List<IcebergPartitionSpec> getIcebergPartitionSpecs() {
        return this.tableDef_.getIcebergPartitionSpecs();
    }

    List<String> getForeignKeysSql() {
        List<TableDef.ForeignKey> fkList = this.tableDef_.getForeignKeysList();
        ArrayList<String> foreignKeysSql = new ArrayList<String>();
        if (fkList != null && !fkList.isEmpty()) {
            for (TableDef.ForeignKey fk : fkList) {
                StringBuilder sb = new StringBuilder("(");
                Joiner.on((String)", ").appendTo(sb, fk.getForeignKeyColNames()).append(")");
                sb.append(" REFERENCES ");
                sb.append(fk.getFullyQualifiedPkTableName() + "(");
                Joiner.on((String)", ").appendTo(sb, fk.getPrimaryKeyColNames()).append(")");
                foreignKeysSql.add(sb.toString());
            }
        }
        return foreignKeysSql;
    }

    public String getOwner() {
        Preconditions.checkNotNull((Object)this.owner_);
        return this.owner_;
    }

    public String getDb() {
        Preconditions.checkState((boolean)this.isAnalyzed());
        return this.getTblName().getDb();
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return ToSqlUtils.getCreateTableSql(this);
    }

    public TCreateTableParams toThrift() {
        TCreateTableParams params = new TCreateTableParams();
        params.setTable_name(new TTableName(this.getDb(), this.getTbl()));
        ArrayList<TColumn> tColumns = new ArrayList<TColumn>();
        for (ColumnDef col : this.getColumnDefs()) {
            tColumns.add(col.toThrift());
        }
        params.setColumns(tColumns);
        for (ColumnDef col : this.getPartitionColumnDefs()) {
            params.addToPartition_columns(col.toThrift());
        }
        params.setOwner(this.getOwner());
        params.setIs_external(this.isExternal());
        params.setComment(this.getComment());
        params.setLocation(this.getLocation() == null ? null : this.getLocation().toString());
        if (this.getCachingOp() != null) {
            params.setCache_op(this.getCachingOp().toThrift());
        }
        if (this.getRowFormat() != null) {
            params.setRow_format(this.getRowFormat().toThrift());
        }
        params.setFile_format(this.getFileFormat());
        params.setIf_not_exists(this.getIfNotExists());
        if (this.geTBucketInfo() != null) {
            params.setBucket_info(this.geTBucketInfo());
        }
        params.setSort_columns(this.getSortColumns());
        params.setSorting_order(this.getSortingOrder());
        params.setTable_properties(Maps.newHashMap(this.getTblProperties()));
        params.getTable_properties().putAll(Maps.newHashMap(this.getGeneratedKuduProperties()));
        params.setSerde_properties(this.getSerdeProperties());
        params.setIs_primary_key_unique(this.isPrimaryKeyUnique());
        for (KuduPartitionParam d : this.getKuduPartitionParams()) {
            params.addToPartition_by(d.toThrift());
        }
        for (ColumnDef pkColDef : this.getPrimaryKeyColumnDefs()) {
            params.addToPrimary_key_column_names(pkColDef.getColName());
        }
        for (SQLPrimaryKey pk : this.getPrimaryKeys()) {
            params.addToPrimary_keys(pk);
        }
        for (SQLForeignKey fk : this.getForeignKeys()) {
            params.addToForeign_keys(fk);
        }
        params.setServer_name(this.serverName_);
        if (!this.getIcebergPartitionSpecs().isEmpty()) {
            Preconditions.checkState((this.getIcebergPartitionSpecs().size() == 1 ? 1 : 0) != 0);
            params.setPartition_spec(this.getIcebergPartitionSpecs().get(0).toThrift());
        }
        return params;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableDef_.getTblName().toPath(), null));
        for (TableDef.ForeignKey fk : this.tableDef_.getForeignKeysList()) {
            tblRefs.add(new TableRef(fk.getPkTableName().toPath(), null));
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.owner_ = analyzer.getUserShortName();
        this.serverName_ = analyzer.getServerName();
        this.tableDef_.analyze(analyzer);
        this.analyzeKuduFormat(analyzer);
        if (this.getColumnDefs().isEmpty() && this.getFileFormat() != THdfsFileFormat.AVRO && this.getFileFormat() != THdfsFileFormat.KUDU && this.getFileFormat() != THdfsFileFormat.ICEBERG) {
            throw new AnalysisException("Table requires at least 1 column");
        }
        if (this.getRowFormat() != null) {
            String fieldDelimiter = this.getRowFormat().getFieldDelimiter();
            String lineDelimiter = this.getRowFormat().getLineDelimiter();
            String escapeChar = this.getRowFormat().getEscapeChar();
            if (this.getFileFormat() != THdfsFileFormat.TEXT && this.getFileFormat() != THdfsFileFormat.SEQUENCE_FILE) {
                if (fieldDelimiter != null) {
                    analyzer.addWarning("'ROW FORMAT DELIMITED FIELDS TERMINATED BY '" + fieldDelimiter + "'' is ignored.");
                }
                if (lineDelimiter != null) {
                    analyzer.addWarning("'ROW FORMAT DELIMITED LINES TERMINATED BY '" + lineDelimiter + "'' is ignored.");
                }
                if (escapeChar != null) {
                    analyzer.addWarning("'ROW FORMAT DELIMITED ESCAPED BY '" + escapeChar + "'' is ignored.");
                }
            }
        }
        if (this.getFileFormat() == THdfsFileFormat.AVRO) {
            this.setColumnDefs(this.analyzeAvroSchema(analyzer));
            if (this.getColumnDefs().isEmpty()) {
                throw new AnalysisException("An Avro table requires column definitions or an Avro schema.");
            }
            AvroSchemaUtils.setFromSerdeComment(this.getColumnDefs());
        }
        if (this.getFileFormat() == THdfsFileFormat.ICEBERG) {
            this.analyzeIcebergColumns();
            this.analyzeIcebergFormat(analyzer);
        } else {
            List<IcebergPartitionSpec> iceSpec = this.tableDef_.getIcebergPartitionSpecs();
            if (iceSpec != null && !iceSpec.isEmpty()) {
                throw new AnalysisException("PARTITIONED BY SPEC is only valid for Iceberg tables.");
            }
        }
        if (this.getFileFormat() == THdfsFileFormat.JDBC) {
            this.analyzeJdbcSchema(analyzer);
        }
        if (BackendConfig.INSTANCE.getComputeLineage() || RuntimeEnv.INSTANCE.isTestEnv()) {
            this.computeLineageGraph(analyzer);
        }
    }

    protected void computeLineageGraph(Analyzer analyzer) {
        ColumnLineageGraph graph = analyzer.getColumnLineageGraph();
        graph.computeLineageGraph(new ArrayList<Expr>(), analyzer);
    }

    private void analyzeKuduFormat(Analyzer analyzer) throws AnalysisException {
        if (this.getFileFormat() != THdfsFileFormat.KUDU) {
            String handler = this.getTblProperties().get("storage_handler");
            if (KuduTable.isKuduStorageHandler(handler)) {
                throw new AnalysisException(KUDU_STORAGE_HANDLER_ERROR_MESSAGE);
            }
            AnalysisUtils.throwIfNotEmpty(this.getKuduPartitionParams(), "Only Kudu tables can use the PARTITION BY clause.");
            return;
        }
        this.analyzeKuduTableProperties(analyzer);
        if (this.isExternalWithNoPurge()) {
            this.analyzeExternalKuduTableParams(analyzer);
        } else {
            this.analyzeSynchronizedKuduTableParams(analyzer);
        }
    }

    private void analyzeKuduTableProperties(Analyzer analyzer) throws AnalysisException {
        String handler;
        String kuduMasters = this.getKuduMasters(analyzer);
        if (kuduMasters.isEmpty()) {
            throw new AnalysisException(String.format("Table property '%s' is required when the impalad startup flag -kudu_master_hosts is not used.", "kudu.master_addresses"));
        }
        this.putGeneratedProperty("kudu.master_addresses", kuduMasters);
        AuthorizationConfig authzConfig = analyzer.getAuthzConfig();
        if (authzConfig.isEnabled()) {
            boolean isExternal;
            boolean bl = isExternal = this.tableDef_.isExternal() || MetaStoreUtil.findTblPropKeyCaseInsensitive(this.getTblProperties(), "EXTERNAL") != null;
            if (isExternal) {
                String externalTableName = this.getTblProperties().get("kudu.table_name");
                AnalysisUtils.throwIfNull(externalTableName, String.format("Table property %s must be specified when creating an external Kudu table.", "kudu.table_name"));
                List<String> storageUris = this.getUrisForAuthz(kuduMasters, externalTableName);
                for (String storageUri : storageUris) {
                    analyzer.registerPrivReq(builder -> builder.onStorageHandlerUri("kudu", storageUri).rwstorage().build());
                }
            }
            if (this.getTblProperties().containsKey("kudu.master_addresses")) {
                String authzServer = authzConfig.getServerName();
                Preconditions.checkNotNull((Object)authzServer);
                analyzer.registerPrivReq(builder -> builder.onServer(authzServer).all().build());
            }
        }
        if ((handler = this.getTblProperties().get("storage_handler")) != null && !KuduTable.isKuduStorageHandler(handler)) {
            throw new AnalysisException("Invalid storage handler specified for Kudu table: " + handler);
        }
        this.putGeneratedProperty("storage_handler", "org.apache.hadoop.hive.kudu.KuduStorageHandler");
        AnalysisUtils.throwIfNotNull(this.getCachingOp(), "A Kudu table cannot be cached in HDFS.");
        AnalysisUtils.throwIfNotNull(this.getLocation(), "LOCATION cannot be specified for a Kudu table.");
        AnalysisUtils.throwIfNotEmpty(this.tableDef_.getPartitionColumnDefs(), "PARTITIONED BY cannot be used in Kudu tables.");
        AnalysisUtils.throwIfNotNull(this.getTblProperties().get("kudu.table_id"), String.format("Table property %s should not be specified when creating a Kudu table.", "kudu.table_id"));
    }

    private List<String> getUrisForAuthz(String kuduMasterAddresses, String kuduTableName) {
        ArrayList masterAddresses = Lists.newArrayList((Object[])kuduMasterAddresses.split(","));
        ArrayList<String> uris = new ArrayList<String>();
        for (String masterAddress : masterAddresses) {
            uris.add(masterAddress + "/" + kuduTableName);
        }
        return uris;
    }

    private String getKuduMasters(Analyzer analyzer) {
        String kuduMasters = this.getTblProperties().get("kudu.master_addresses");
        if (Strings.isNullOrEmpty((String)kuduMasters)) {
            kuduMasters = analyzer.getCatalog().getDefaultKuduMasterHosts();
        }
        return kuduMasters;
    }

    private void analyzeExternalKuduTableParams(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((!Boolean.parseBoolean(this.getTblProperties().get("external.table.purge")) ? 1 : 0) != 0);
        AnalysisUtils.throwIfNull(this.getTblProperties().get("kudu.table_name"), String.format("Table property %s must be specified when creating an external Kudu table.", "kudu.table_name"));
        if (this.hasPrimaryKey() || this.getTblProperties().containsKey("kudu.key_columns")) {
            throw new AnalysisException("Primary keys cannot be specified for an external Kudu table");
        }
        AnalysisUtils.throwIfNotNull(this.getTblProperties().get("kudu.num_tablet_replicas"), String.format("Table property '%s' cannot be used with an external Kudu table.", "kudu.num_tablet_replicas"));
        AnalysisUtils.throwIfNotEmpty(this.getColumnDefs(), "Columns cannot be specified with an external Kudu table.");
        AnalysisUtils.throwIfNotEmpty(this.getKuduPartitionParams(), "PARTITION BY cannot be used with an external Kudu table.");
    }

    private void analyzeSynchronizedKuduTableParams(Analyzer analyzer) throws AnalysisException {
        if (!this.isExternal() && Boolean.parseBoolean(this.getTblProperties().get("external.table.purge"))) {
            throw new AnalysisException(String.format("Table property '%s' cannot be set to true with an managed Kudu table.", "external.table.purge"));
        }
        this.analyzeSynchronizedKuduTableName(analyzer);
        for (ColumnDef col : this.getColumnDefs()) {
            try {
                KuduUtil.fromImpalaType(col.getType());
            }
            catch (ImpalaRuntimeException e) {
                throw new AnalysisException(String.format("Cannot create table '%s': %s", this.getTbl(), e.getMessage()));
            }
        }
        AnalysisUtils.throwIfNotNull(this.getTblProperties().get("kudu.key_columns"), String.format("PRIMARY KEY must be used instead of the table property '%s'.", "kudu.key_columns"));
        if (!this.hasPrimaryKey()) {
            throw new AnalysisException("A primary key is required for a Kudu table.");
        }
        String tabletReplicas = this.getTblProperties().get("kudu.num_tablet_replicas");
        if (tabletReplicas != null) {
            Integer r = Ints.tryParse((String)tabletReplicas);
            if (r == null) {
                throw new AnalysisException(String.format("Table property '%s' must be an integer.", "kudu.num_tablet_replicas"));
            }
            if (r <= 0) {
                throw new AnalysisException("Number of tablet replicas must be greater than zero. Given number of replicas is: " + r.toString());
            }
        }
        this.analyzeKuduPartitionParams(analyzer);
    }

    private void analyzeSynchronizedKuduTableName(Analyzer analyzer) throws AnalysisException {
        boolean isHMSIntegrationEnabled;
        AnalysisUtils.throwIfNotNull(this.getTblProperties().get("kudu.table_name"), String.format("Not allowed to set '%s' manually for synchronized Kudu tables.", "kudu.table_name"));
        String kuduMasters = this.getKuduMasters(analyzer);
        try {
            isHMSIntegrationEnabled = KuduTable.isHMSIntegrationEnabled(kuduMasters);
        }
        catch (ImpalaRuntimeException e) {
            throw new AnalysisException(String.format("Cannot analyze Kudu table '%s': %s", this.getTbl(), e.getMessage()));
        }
        this.putGeneratedProperty("kudu.table_name", KuduUtil.getDefaultKuduTableName(this.getDb(), this.getTbl(), isHMSIntegrationEnabled));
    }

    private void analyzeKuduPartitionParams(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.getFileFormat() == THdfsFileFormat.KUDU ? 1 : 0) != 0);
        if (this.getKuduPartitionParams().isEmpty()) {
            analyzer.addWarning("Unpartitioned Kudu tables are inefficient for large data sizes.");
            return;
        }
        Map<String, ColumnDef> pkColDefsByName = ColumnDef.mapByColumnNames(this.getPrimaryKeyColumnDefs());
        for (KuduPartitionParam partitionParam : this.getKuduPartitionParams()) {
            partitionParam.setPkColumnDefMap(pkColDefsByName);
            partitionParam.analyze(analyzer);
        }
    }

    private boolean hasPrimaryKey() {
        Preconditions.checkState((boolean)this.tableDef_.isAnalyzed());
        return !this.tableDef_.getPrimaryKeyColumnDefs().isEmpty();
    }

    private List<ColumnDef> analyzeAvroSchema(Analyzer analyzer) throws AnalysisException {
        List<ColumnDef> avroCols;
        Preconditions.checkState((this.getFileFormat() == THdfsFileFormat.AVRO ? 1 : 0) != 0);
        ArrayList<Map<String, String>> schemaSearchLocations = new ArrayList<Map<String, String>>();
        schemaSearchLocations.add(this.getSerdeProperties());
        schemaSearchLocations.add(this.getTblProperties());
        try {
            String avroSchema = AvroSchemaUtils.getAvroSchema(schemaSearchLocations);
            if (avroSchema == null) {
                Schema inferredSchema = AvroSchemaConverter.convertColumnDefs(this.getColumnDefs(), this.getTblName().toString());
                avroSchema = inferredSchema.toString();
            }
            if (Strings.isNullOrEmpty((String)avroSchema)) {
                throw new AnalysisException("Avro schema is null or empty: " + this.getTblName().toString());
            }
            avroCols = AvroSchemaParser.parse(avroSchema);
        }
        catch (SchemaParseException e) {
            throw new AnalysisException(String.format("Error parsing Avro schema for table '%s': %s", this.getTblName().toString(), e.getMessage()));
        }
        Preconditions.checkNotNull(avroCols);
        StringBuilder warning = new StringBuilder();
        List<ColumnDef> reconciledColDefs = AvroSchemaUtils.reconcileSchemas(this.getColumnDefs(), avroCols, warning);
        if (warning.length() > 0) {
            analyzer.addWarning(warning.toString());
        }
        return reconciledColDefs;
    }

    static void unescapeProperties(Map<String, String> propertyMap) {
        if (propertyMap == null) {
            return;
        }
        for (Map.Entry<String, String> kv : propertyMap.entrySet()) {
            propertyMap.put(kv.getKey(), new StringLiteral(kv.getValue()).getUnescapedValue());
        }
    }

    private void analyzeIcebergFormat(Analyzer analyzer) throws AnalysisException {
        String handler;
        if (!this.isExternal() && Boolean.parseBoolean(this.getTblProperties().get("external.table.purge"))) {
            throw new AnalysisException(String.format("Table property '%s' cannot be set to true with a managed Iceberg table.", "external.table.purge"));
        }
        if (!this.isExternal() || Boolean.parseBoolean(this.getTblProperties().get("external.table.purge"))) {
            if (this.getColumnDefs().isEmpty()) {
                throw new AnalysisException("Table requires at least 1 column for managed iceberg table.");
            }
            this.checkPartitionColumns(analyzer);
        }
        if ((handler = this.getTblProperties().get("storage_handler")) != null && !IcebergTable.isIcebergStorageHandler(handler)) {
            throw new AnalysisException("Invalid storage handler specified for Iceberg format: " + handler);
        }
        this.putGeneratedProperty("storage_handler", "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler");
        this.putGeneratedProperty("engine.hive.enabled", "true");
        this.addMergeOnReadPropertiesIfNeeded();
        String fileformat = this.getTblProperties().get("write.format.default");
        TIcebergFileFormat icebergFileFormat = IcebergUtil.getIcebergFileFormat(fileformat);
        if (fileformat != null && icebergFileFormat == null) {
            throw new AnalysisException("Invalid fileformat for Iceberg table: " + fileformat);
        }
        if (fileformat == null || fileformat.isEmpty()) {
            this.putGeneratedProperty("write.format.default", "parquet");
        }
        this.validateIcebergParquetCompressionCodec(icebergFileFormat);
        this.validateIcebergParquetRowGroupSize(icebergFileFormat);
        this.validateIcebergParquetPageSize(icebergFileFormat, "write.parquet.page-size-bytes", "page size");
        this.validateIcebergParquetPageSize(icebergFileFormat, "write.parquet.dict-size-bytes", "dictionary page size");
        String catalogStr = this.getTblProperties().get("iceberg.catalog");
        TIcebergCatalog catalog = catalogStr == null || catalogStr.isEmpty() ? TIcebergCatalog.HIVE_CATALOG : IcebergUtil.getTIcebergCatalog(catalogStr);
        this.validateIcebergTableProperties(catalog);
    }

    private void addMergeOnReadPropertiesIfNeeded() {
        Map<String, String> tblProps = this.getTblProperties();
        String formatVersion = tblProps.get("format-version");
        if (formatVersion == null || Integer.valueOf(formatVersion) < 2) {
            return;
        }
        String MERGE_ON_READ = "merge-on-read";
        if (!IcebergUtil.isAnyWriteModeSet(tblProps)) {
            this.putGeneratedProperty("write.delete.mode", "merge-on-read");
            this.putGeneratedProperty("write.update.mode", "merge-on-read");
            this.putGeneratedProperty("write.merge.mode", "merge-on-read");
        }
    }

    private void validateIcebergParquetCompressionCodec(TIcebergFileFormat icebergFileFormat) throws AnalysisException {
        if (icebergFileFormat != TIcebergFileFormat.PARQUET) {
            if (this.getTblProperties().containsKey("write.parquet.compression-codec")) {
                throw new AnalysisException("write.parquet.compression-codec should be set only for parquet file format");
            }
            if (this.getTblProperties().containsKey("write.parquet.compression-level")) {
                throw new AnalysisException("write.parquet.compression-level should be set only for parquet file format");
            }
        } else {
            StringBuilder errMsg = new StringBuilder();
            if (IcebergUtil.parseParquetCompressionCodec(true, this.getTblProperties(), errMsg) == null) {
                throw new AnalysisException(errMsg.toString());
            }
        }
    }

    private void validateIcebergParquetRowGroupSize(TIcebergFileFormat icebergFileFormat) throws AnalysisException {
        if (this.getTblProperties().containsKey("write.parquet.row-group-size-bytes") && icebergFileFormat != TIcebergFileFormat.PARQUET) {
            throw new AnalysisException("write.parquet.row-group-size-bytes should be set only for parquet file format");
        }
        StringBuilder errMsg = new StringBuilder();
        if (IcebergUtil.parseParquetRowGroupSize(this.getTblProperties(), errMsg) == null) {
            throw new AnalysisException(errMsg.toString());
        }
    }

    private void validateIcebergParquetPageSize(TIcebergFileFormat icebergFileFormat, String pageSizeTblProp, String descr) throws AnalysisException {
        if (this.getTblProperties().containsKey(pageSizeTblProp) && icebergFileFormat != TIcebergFileFormat.PARQUET) {
            throw new AnalysisException(pageSizeTblProp + " should be set only for parquet file format");
        }
        StringBuilder errMsg = new StringBuilder();
        if (IcebergUtil.parseParquetPageSize(this.getTblProperties(), pageSizeTblProp, descr, errMsg) == null) {
            throw new AnalysisException(errMsg.toString());
        }
    }

    private void validateIcebergTableProperties(TIcebergCatalog catalog) throws AnalysisException {
        if (this.getTblProperties().get("metadata_location") != null) {
            throw new AnalysisException(String.format("%s cannot be set for Iceberg tables", "metadata_location"));
        }
        switch (catalog) {
            case HIVE_CATALOG: {
                this.validateTableInHiveCatalog();
                break;
            }
            case HADOOP_CATALOG: {
                this.validateTableInHadoopCatalog();
                break;
            }
            case HADOOP_TABLES: {
                this.validateTableInHadoopTables();
                break;
            }
            case CATALOGS: {
                this.validateTableInCatalogs();
                break;
            }
            default: {
                throw new AnalysisException(String.format("Unknown Iceberg catalog type: %s", new Object[]{catalog}));
            }
        }
        if (!this.isExternal() && !IcebergUtil.isHiveCatalog(this.getTblProperties()) && "false".equalsIgnoreCase(this.getTblProperties().get("external.table.purge"))) {
            this.analyzer_.addWarning("The table property 'external.table.purge' will be set to 'TRUE' on newly created managed Iceberg tables.");
        }
        if (this.isExternalWithNoPurge() && IcebergUtil.isHiveCatalog(this.getTblProperties())) {
            throw new AnalysisException("Cannot create EXTERNAL Iceberg table in the Hive Catalog.");
        }
    }

    private void validateTableInHiveCatalog() throws AnalysisException {
        if (this.getTblProperties().get("iceberg.catalog_location") != null) {
            throw new AnalysisException(String.format("%s cannot be set for Iceberg table stored in hive.catalog", "iceberg.catalog_location"));
        }
    }

    private void validateTableInHadoopCatalog() throws AnalysisException {
        if (this.getLocation() != null) {
            throw new AnalysisException(String.format("Location cannot be set for Iceberg table with 'hadoop.catalog'.", new Object[0]));
        }
        String catalogLoc = this.getTblProperties().get("iceberg.catalog_location");
        if (catalogLoc == null || catalogLoc.isEmpty()) {
            throw new AnalysisException(String.format("Table property '%s' is necessary for Iceberg table with 'hadoop.catalog'.", "iceberg.catalog_location"));
        }
    }

    private void validateTableInHadoopTables() throws AnalysisException {
        if (this.getTblProperties().get("iceberg.catalog_location") != null) {
            throw new AnalysisException(String.format("%s cannot be set for Iceberg table stored in hadoop.tables", "iceberg.catalog_location"));
        }
        if (this.isExternalWithNoPurge() && this.getLocation() == null) {
            throw new AnalysisException("Set LOCATION for external Iceberg tables stored in hadoop.tables. For creating a completely new Iceberg table, use 'CREATE TABLE' (no EXTERNAL keyword).");
        }
    }

    private void validateTableInCatalogs() {
        String tableId = this.getTblProperties().get("iceberg.table_identifier");
        if (tableId != null && !tableId.isEmpty()) {
            this.putGeneratedProperty("name", tableId);
        }
    }

    private void checkPartitionColumns(Analyzer analyzer) throws AnalysisException {
        List<IcebergPartitionSpec> specs = this.tableDef_.getIcebergPartitionSpecs();
        if (specs == null || specs.isEmpty()) {
            return;
        }
        IcebergPartitionSpec spec = specs.get(0);
        spec.analyze(analyzer);
        List<IcebergPartitionField> fields = spec.getIcebergPartitionFields();
        Preconditions.checkState((fields != null && !fields.isEmpty() ? 1 : 0) != 0);
        for (IcebergPartitionField field : fields) {
            String fieldName = field.getFieldName();
            boolean containFlag = false;
            for (ColumnDef columnDef : this.tableDef_.getColumnDefs()) {
                if (!columnDef.getColName().equalsIgnoreCase(fieldName)) continue;
                containFlag = true;
                break;
            }
            if (containFlag) continue;
            throw new AnalysisException("Cannot find source column: " + fieldName);
        }
    }

    private void analyzeIcebergColumns() {
        if (!this.getPartitionColumnDefs().isEmpty()) {
            this.createIcebergPartitionSpecFromPartitionColumns();
        }
        for (ColumnDef def : this.getColumnDefs()) {
            if (def.isNullabilitySet()) continue;
            def.setNullable(true);
        }
    }

    private void createIcebergPartitionSpecFromPartitionColumns() {
        Preconditions.checkState((!this.getPartitionColumnDefs().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.getIcebergPartitionSpecs().isEmpty());
        ArrayList<IcebergPartitionField> partFields = new ArrayList<IcebergPartitionField>();
        for (ColumnDef colDef : this.getPartitionColumnDefs()) {
            partFields.add(new IcebergPartitionField(colDef.getColName(), new IcebergPartitionTransform(TIcebergPartitionTransformType.IDENTITY)));
        }
        this.getIcebergPartitionSpecs().add(new IcebergPartitionSpec(partFields));
        this.getColumnDefs().addAll(this.getPartitionColumnDefs());
        this.getPartitionColumnDefs().clear();
    }

    private void analyzeJdbcSchema(Analyzer analyzer) throws AnalysisException {
        if (!this.isExternal()) {
            throw new AnalysisException("JDBC table must be created as external table");
        }
        for (ColumnDef col : this.getColumnDefs()) {
            if (DataSourceTable.isSupportedColumnType(col.getType())) continue;
            throw new AnalysisException("Tables stored by JDBC do not support the column type: " + col.getType());
        }
        AnalysisUtils.throwIfNotNull(this.getCachingOp(), "A JDBC table cannot be cached in HDFS.");
        AnalysisUtils.throwIfNotNull(this.getLocation(), "LOCATION cannot be specified for a JDBC table.");
        AnalysisUtils.throwIfNotEmpty(this.tableDef_.getPartitionColumnDefs(), "PARTITIONED BY cannot be used in a JDBC table.");
        try {
            DataSourceTable.setJdbcDataSourceProperties(this.getTblProperties());
        }
        catch (ImpalaRuntimeException e) {
            throw new AnalysisException(String.format("Cannot create table '%s': %s", this.getTbl(), e.getMessage()));
        }
    }

    private boolean isExternalWithNoPurge() {
        return this.isExternal() && !Boolean.parseBoolean(this.getTblProperties().get("external.table.purge"));
    }
}

