/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.OrcSchemaExtractor;
import org.apache.impala.analysis.ParquetSchemaExtractor;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.HdfsCompression;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TSortingOrder;

public class CreateTableLikeFileStmt
extends CreateTableStmt {
    private final HdfsUri schemaLocation_;
    private final THdfsFileFormat schemaFileFormat_;

    public CreateTableLikeFileStmt(CreateTableStmt createTableStmt, THdfsFileFormat schemaFileFormat, HdfsUri schemaLocation) {
        super(createTableStmt);
        this.schemaLocation_ = schemaLocation;
        this.schemaFileFormat_ = schemaFileFormat;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        ArrayList<String> colsSql = new ArrayList<String>();
        ArrayList<String> partitionColsSql = new ArrayList<String>();
        HdfsCompression compression = HdfsCompression.fromFileName(this.schemaLocation_.toString());
        String s = ToSqlUtils.getCreateTableSql(this.getDb(), this.getTbl() + " __LIKE_FILEFORMAT__ ", this.getComment(), colsSql, partitionColsSql, true, null, null, null, new Pair<List<String>, TSortingOrder>(this.getSortColumns(), this.getSortingOrder()), this.getTblProperties(), this.getSerdeProperties(), this.isExternal(), this.getIfNotExists(), this.getRowFormat(), HdfsFileFormat.fromThrift(this.getFileFormat()), compression, null, this.getLocation(), null, null);
        s = s.replace("__LIKE_FILEFORMAT__", String.format("LIKE %s '%s'", new Object[]{this.schemaFileFormat_, this.schemaLocation_.toString()}));
        return s;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.getFileFormat() == THdfsFileFormat.KUDU) {
            throw new AnalysisException("CREATE TABLE LIKE FILE statement is not supported for Kudu tables.");
        }
        if (this.getFileFormat() == THdfsFileFormat.JDBC) {
            throw new AnalysisException("CREATE TABLE LIKE FILE statement is not supported for JDBC tables.");
        }
        this.schemaLocation_.analyze(analyzer, Privilege.ALL, FsAction.READ);
        switch (this.schemaFileFormat_) {
            case PARQUET: {
                this.getColumnDefs().addAll(ParquetSchemaExtractor.extract(this.schemaLocation_));
                break;
            }
            case ORC: {
                if (MetastoreShim.getMajorVersion() < 3L) {
                    throw new AnalysisException("Creating table like ORC file is unsupported for Hive with version < 3");
                }
                this.getColumnDefs().addAll(OrcSchemaExtractor.extract(this.schemaLocation_));
                break;
            }
            default: {
                throw new AnalysisException("Unsupported file type for schema inference: " + (Object)((Object)this.schemaFileFormat_));
            }
        }
        super.analyze(analyzer);
    }
}

