/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.iceberg.IcebergCtasTarget;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.thrift.THdfsFileFormat;

public class CreateTableAsSelectStmt
extends StatementBase {
    private final List<String> partitionKeys_;
    private final CreateTableStmt createStmt_;
    private final InsertStmt insertStmt_;
    private static final EnumSet<THdfsFileFormat> SUPPORTED_INSERT_FORMATS = EnumSet.of(THdfsFileFormat.ICEBERG, THdfsFileFormat.PARQUET, THdfsFileFormat.TEXT, THdfsFileFormat.KUDU);

    public CreateTableAsSelectStmt(CtasParams params, List<PlanHint> planHints) {
        this.createStmt_ = params.createStmt;
        this.partitionKeys_ = params.partitionKeys;
        ArrayList<PartitionKeyValue> pkvs = null;
        if (this.partitionKeys_ != null) {
            pkvs = new ArrayList<PartitionKeyValue>();
            for (String key : this.partitionKeys_) {
                pkvs.add(new PartitionKeyValue(key, null));
            }
        }
        this.insertStmt_ = InsertStmt.createInsert(null, this.createStmt_.getTblName(), false, pkvs, planHints, null, params.queryStmt, null);
    }

    public QueryStmt getQueryStmt() {
        return this.insertStmt_.getQueryStmt();
    }

    public InsertStmt getInsertStmt() {
        return this.insertStmt_;
    }

    public CreateTableStmt getCreateStmt() {
        return this.createStmt_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return ToSqlUtils.getCreateTableSql(this, options);
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        this.createStmt_.collectTableRefs(tblRefs);
        this.insertStmt_.collectTableRefs(tblRefs);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        int colCnt;
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        if (!SUPPORTED_INSERT_FORMATS.contains((Object)this.createStmt_.getFileFormat())) {
            throw new AnalysisException(String.format("CREATE TABLE AS SELECT does not support the (%s) file format. Supported formats are: (%s)", this.createStmt_.getFileFormat().toString().replace("_", ""), "PARQUET, TEXTFILE, KUDU, ICEBERG"));
        }
        if (this.createStmt_.getFileFormat() == THdfsFileFormat.KUDU && this.createStmt_.isExternal()) {
            throw new AnalysisException(String.format("CREATE TABLE AS SELECT is not supported for external Kudu tables.", new Object[0]));
        }
        if (this.createStmt_.getFileFormat() == THdfsFileFormat.JDBC) {
            throw new AnalysisException("CREATE TABLE AS SELECT is not supported for JDBC tables.");
        }
        Analyzer dummyRootAnalyzer = new Analyzer(analyzer.getStmtTableCache(), analyzer.getQueryCtx(), analyzer.getAuthzFactory(), analyzer.getAuthzCtx());
        QueryStmt tmpQueryStmt = this.insertStmt_.getQueryStmt().clone();
        Analyzer tmpAnalyzer = new Analyzer(dummyRootAnalyzer);
        tmpAnalyzer.setUseHiveColLabels(true);
        tmpQueryStmt.analyze(tmpAnalyzer);
        if (analyzer.containsSubquery()) {
            return;
        }
        if (this.partitionKeys_ != null) {
            int firstCol;
            colCnt = tmpQueryStmt.getColLabels().size();
            int partColCnt = this.partitionKeys_.size();
            if (partColCnt >= colCnt) {
                throw new AnalysisException(String.format("Number of partition columns (%s) must be smaller than the number of columns in the select statement (%s).", partColCnt, colCnt));
            }
            int i = firstCol = colCnt - partColCnt;
            int j = 0;
            while (i < colCnt) {
                String colLabel;
                String partitionLabel = this.partitionKeys_.get(j);
                if (!partitionLabel.equals(colLabel = tmpQueryStmt.getColLabels().get(i))) {
                    throw new AnalysisException(String.format("Partition column name mismatch: %s != %s", partitionLabel, colLabel));
                }
                ColumnDef colDef = new ColumnDef(colLabel, null);
                colDef.setType(tmpQueryStmt.getBaseTblResultExprs().get(i).getType());
                this.createStmt_.getPartitionColumnDefs().add(colDef);
                ++i;
                ++j;
            }
            tmpQueryStmt.getColLabels().subList(firstCol, colCnt).clear();
        }
        colCnt = tmpQueryStmt.getColLabels().size();
        HashSet hashedPrimaryKeyColNames = Sets.newHashSet(this.createStmt_.getTblPrimaryKeyColumnNames());
        for (int i = 0; i < colCnt; ++i) {
            ColumnDef colDef = new ColumnDef(tmpQueryStmt.getColLabels().get(i), null, Collections.emptyMap());
            colDef.setType(tmpQueryStmt.getBaseTblResultExprs().get(i).getType());
            if (colDef.getType() == Type.NULL) {
                throw new AnalysisException(String.format("Unable to infer the column type for column '%s'. Use cast() to explicitly specify the column type for column '%s'.", colDef.getColName(), colDef.getColName()));
            }
            if (this.createStmt_.getFileFormat() == THdfsFileFormat.ICEBERG && hashedPrimaryKeyColNames.contains(colDef.getColName())) {
                colDef.setNullable(false);
            }
            this.createStmt_.getColumnDefs().add(colDef);
        }
        this.createStmt_.analyze(analyzer);
        FeDb db = analyzer.getDb(this.createStmt_.getDb(), Privilege.ANY);
        if (db == null) {
            throw new AnalysisException("Database does not exist: " + this.createStmt_.getDb());
        }
        Table msTbl = CatalogOpExecutor.createMetaStoreTable(this.createStmt_.toThrift());
        try {
            if (msTbl.getSd().getLocation() == null || msTbl.getSd().getLocation().isEmpty()) {
                msTbl.getSd().setLocation(MetastoreShim.getPathForNewTable(db.getMetaStoreDb(), msTbl));
            }
            FeTable tmpTable = null;
            if (KuduTable.isKuduTable(msTbl)) {
                tmpTable = db.createKuduCtasTarget(msTbl, this.createStmt_.getColumnDefs(), this.createStmt_.getPrimaryKeyColumnDefs(), this.createStmt_.isPrimaryKeyUnique(), this.createStmt_.getKuduPartitionParams());
            } else if (IcebergTable.isIcebergTable(msTbl)) {
                IcebergPartitionSpec partSpec = null;
                if (this.createStmt_.getIcebergPartitionSpecs() != null && !this.createStmt_.getIcebergPartitionSpecs().isEmpty()) {
                    Preconditions.checkState((this.createStmt_.getIcebergPartitionSpecs().size() == 1 ? 1 : 0) != 0);
                    partSpec = this.createStmt_.getIcebergPartitionSpecs().get(0);
                }
                tmpTable = new IcebergCtasTarget(db, msTbl, this.createStmt_.getColumnDefs(), this.createStmt_.getTblPrimaryKeyColumnNames(), partSpec);
            } else if (HdfsFileFormat.isHdfsInputFormatClass(msTbl.getSd().getInputFormat())) {
                tmpTable = db.createFsCtasTarget(msTbl);
            }
            Preconditions.checkState((tmpTable != null && (tmpTable instanceof FeFsTable || tmpTable instanceof FeKuduTable) ? 1 : 0) != 0);
            this.insertStmt_.setTargetTable(tmpTable);
            if (tmpTable instanceof FeFsTable) {
                this.insertStmt_.setMaxTableSinks(this.analyzer_.getQueryOptions().getMax_fs_writers());
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e.getMessage(), e);
        }
        this.insertStmt_.analyze(analyzer);
    }

    @Override
    public List<Expr> getResultExprs() {
        return this.insertStmt_.getResultExprs();
    }

    @Override
    public void castResultExprs(List<Type> types) throws AnalysisException {
        int i;
        super.castResultExprs(types);
        List<ColumnDef> colDefs = this.createStmt_.getColumnDefs();
        List<ColumnDef> partitionColDefs = this.createStmt_.getPartitionColumnDefs();
        Preconditions.checkState((colDefs.size() + partitionColDefs.size() == types.size() ? 1 : 0) != 0);
        for (i = 0; i < colDefs.size(); ++i) {
            colDefs.get(i).setType(types.get(i));
        }
        for (i = 0; i < partitionColDefs.size(); ++i) {
            partitionColDefs.get(i).setType(types.get(i + colDefs.size()));
        }
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        this.insertStmt_.rewriteExprs(rewriter);
    }

    @Override
    public void reset() {
        super.reset();
        this.createStmt_.reset();
        this.createStmt_.getPartitionColumnDefs().clear();
        this.insertStmt_.reset();
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        return this.getQueryStmt().resolveTableMask(analyzer);
    }

    public static class CtasParams {
        public CreateTableStmt createStmt;
        public QueryStmt queryStmt;
        public List<String> partitionKeys;

        public CtasParams(CreateTableStmt createStmt, QueryStmt queryStmt, List<String> partitionKeys) {
            this.createStmt = (CreateTableStmt)Preconditions.checkNotNull((Object)createStmt);
            this.queryStmt = (QueryStmt)Preconditions.checkNotNull((Object)queryStmt);
            this.partitionKeys = partitionKeys;
        }
    }
}

