/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.ColumnLineageGraph;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCreateOrAlterViewParams;
import org.apache.impala.thrift.TTableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CreateOrAlterViewStmtBase
extends StatementBase {
    private static final Logger LOG = LoggerFactory.getLogger(CreateOrAlterViewStmtBase.class);
    protected final boolean ifNotExists_;
    protected final TableName tableName_;
    protected final List<ColumnDef> columnDefs_;
    protected final String comment_;
    protected final QueryStmt viewDefStmt_;
    protected Map<String, String> tblPropertyMap_;
    protected String dbName_;
    protected String owner_;
    protected String serverName_;
    protected String originalViewDef_;
    protected String inlineViewDef_;
    protected List<ColumnDef> finalColDefs_;

    public CreateOrAlterViewStmtBase(boolean ifNotExists, TableName tableName, List<ColumnDef> columnDefs, String comment, Map<String, String> tblPropertyMap, QueryStmt viewDefStmt) {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)viewDefStmt);
        this.ifNotExists_ = ifNotExists;
        this.tableName_ = tableName;
        this.columnDefs_ = columnDefs;
        this.comment_ = comment;
        this.tblPropertyMap_ = tblPropertyMap;
        this.viewDefStmt_ = viewDefStmt;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
        this.viewDefStmt_.collectTableRefs(tblRefs);
    }

    protected void createColumnAndViewDefs(Analyzer analyzer) throws AnalysisException {
        int i;
        Preconditions.checkNotNull((Object)this.dbName_);
        Preconditions.checkNotNull((Object)this.owner_);
        if (this.columnDefs_ != null) {
            Preconditions.checkState((!this.columnDefs_.isEmpty() ? 1 : 0) != 0);
            if (this.columnDefs_.size() != this.viewDefStmt_.getColLabels().size()) {
                String cmp = this.columnDefs_.size() > this.viewDefStmt_.getColLabels().size() ? "more" : "fewer";
                throw new AnalysisException(String.format("Column-definition list has %s columns (%s) than the view-definition query statement returns (%s).", cmp, this.columnDefs_.size(), this.viewDefStmt_.getColLabels().size()));
            }
            this.finalColDefs_ = this.columnDefs_;
            Preconditions.checkState((this.columnDefs_.size() == this.viewDefStmt_.getBaseTblResultExprs().size() ? 1 : 0) != 0);
            for (int i2 = 0; i2 < this.columnDefs_.size(); ++i2) {
                this.columnDefs_.get(i2).setType(this.viewDefStmt_.getBaseTblResultExprs().get(i2).getType());
            }
        } else {
            this.finalColDefs_ = new ArrayList<ColumnDef>();
            List<Expr> exprs = this.viewDefStmt_.getBaseTblResultExprs();
            List<String> labels = this.viewDefStmt_.getColLabels();
            Preconditions.checkState((exprs.size() == labels.size() ? 1 : 0) != 0);
            for (i = 0; i < this.viewDefStmt_.getColLabels().size(); ++i) {
                ColumnDef colDef = new ColumnDef(labels.get(i), null);
                colDef.setType(exprs.get(i).getType());
                this.finalColDefs_.add(colDef);
            }
        }
        HashSet<String> distinctColNames = new HashSet<String>();
        for (ColumnDef colDesc : this.finalColDefs_) {
            if (colDesc.getType() == Type.NULL) {
                throw new AnalysisException(String.format("Unable to infer the column type for column '%s'. Use cast() to explicitly specify the column type for column '%s'.", colDesc.getColName(), colDesc.getColName()));
            }
            colDesc.analyze(null);
            if (distinctColNames.add(colDesc.getColName().toLowerCase())) continue;
            throw new AnalysisException("Duplicate column name: " + colDesc.getColName());
        }
        this.originalViewDef_ = this.viewDefStmt_.toSql();
        if (this.columnDefs_ == null) {
            this.inlineViewDef_ = this.originalViewDef_;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (i = 0; i < this.finalColDefs_.size(); ++i) {
            String colRef = ToSqlUtils.getIdentSql(this.viewDefStmt_.getColLabels().get(i));
            String colAlias = ToSqlUtils.getIdentSql(this.finalColDefs_.get(i).getColName());
            sb.append(String.format("%s.%s AS %s", this.tableName_.getTbl(), colRef, colAlias));
            sb.append(i + 1 != this.finalColDefs_.size() ? ", " : "");
        }
        sb.append(String.format(" FROM (%s) %s", this.originalViewDef_, this.tableName_.getTbl()));
        this.inlineViewDef_ = sb.toString();
    }

    protected void computeLineageGraph(Analyzer analyzer) {
        ColumnLineageGraph graph = analyzer.getColumnLineageGraph();
        ArrayList<ColumnLineageGraph.ColumnLabel> colDefs = new ArrayList<ColumnLineageGraph.ColumnLabel>();
        for (ColumnDef colDef : this.finalColDefs_) {
            colDefs.add(new ColumnLineageGraph.ColumnLabel(colDef.getColName(), new TableName(this.dbName_, this.getTbl()), "view"));
        }
        graph.addTargetColumnLabels(colDefs);
        graph.computeLineageGraph(this.viewDefStmt_.getResultExprs(), analyzer);
        if (LOG.isTraceEnabled()) {
            LOG.trace("lineage: " + graph.debugString());
        }
    }

    public TCreateOrAlterViewParams toThrift() {
        TCreateOrAlterViewParams params = new TCreateOrAlterViewParams();
        params.setView_name(new TTableName(this.getDb(), this.getTbl()));
        for (ColumnDef col : this.finalColDefs_) {
            params.addToColumns(col.toThrift());
        }
        params.setOwner(this.getOwner());
        params.setIf_not_exists(this.getIfNotExists());
        params.setOriginal_view_def(this.originalViewDef_);
        params.setExpanded_view_def(this.inlineViewDef_);
        params.setServer_name(this.serverName_);
        params.setComment(this.comment_);
        params.setTblproperties(this.getTblPropertyMap());
        return params;
    }

    public String getDb() {
        Preconditions.checkNotNull((Object)this.dbName_);
        return this.dbName_;
    }

    public String getOwner() {
        Preconditions.checkNotNull((Object)this.owner_);
        return this.owner_;
    }

    protected String getColumnNames() {
        Preconditions.checkNotNull(this.columnDefs_);
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnDef colDef : this.columnDefs_) {
            columnNames.add(colDef.getColName());
        }
        return Joiner.on((String)", ").join(columnNames);
    }

    protected Map<String, String> getTblPropertyMap() {
        if (this.tblPropertyMap_ == null || this.tblPropertyMap_.size() == 0) {
            return Collections.emptyMap();
        }
        return this.tblPropertyMap_;
    }

    protected String getTblProperties() {
        if (this.tblPropertyMap_ == null) {
            return null;
        }
        return ToSqlUtils.propertyMapToSql(this.tblPropertyMap_);
    }

    public boolean getIfNotExists() {
        return this.ifNotExists_;
    }

    public String getInlineViewDef() {
        return this.inlineViewDef_;
    }

    public String getTbl() {
        return this.tableName_.getTbl();
    }
}

