/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.AuthorizationStmt;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCreateDropRoleParams;

public class CreateDropRoleStmt
extends AuthorizationStmt {
    private final String roleName_;
    private final boolean isDropRole_;

    public CreateDropRoleStmt(String roleName, boolean isDropRole) {
        Preconditions.checkNotNull((Object)roleName);
        this.roleName_ = roleName;
        this.isDropRole_ = isDropRole;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return String.format("%s ROLE %s", this.isDropRole_ ? "DROP" : "CREATE", this.roleName_);
    }

    public TCreateDropRoleParams toThrift() {
        TCreateDropRoleParams params = new TCreateDropRoleParams();
        params.setRole_name(this.roleName_);
        params.setIs_drop(this.isDropRole_);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
    }
}

