/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.QueryStringBuilder;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TConvertTableRequest;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.IcebergSchemaConverter;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.MigrateTableUtil;

public class ConvertTableToIcebergStmt
extends StatementBase {
    private TableName tableName_;
    private TableName tmpHdfsTableName_;
    private final Map<String, String> properties_;
    private String setHdfsTablePropertiesQuery_;
    private String renameHdfsTableToTemporaryQuery_;
    private String refreshTemporaryHdfsTableQuery_;
    private String resetTableNameQuery_;
    private String createIcebergTableQuery_;
    private String invalidateMetadataQuery_;
    private String postCreateAlterTableQuery_;
    private String dropTemporaryHdfsTableQuery_;

    public ConvertTableToIcebergStmt(TableName tableName, Map<String, String> properties) {
        this.tableName_ = tableName;
        this.properties_ = properties;
    }

    public ConvertTableToIcebergStmt(TableName tableName) {
        this(tableName, Maps.newHashMap());
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.tableName_ = analyzer.getFqTableName(this.tableName_);
        analyzer.getDb(this.tableName_.getDb(), Privilege.ALL);
        FeTable table = analyzer.getTable(this.tableName_, Privilege.ALL);
        if (!(table instanceof FeFsTable)) {
            throw new AnalysisException("CONVERT TO ICEBERG is not supported for " + table.getClass().getSimpleName());
        }
        if (table.getMetaStoreTable().getParameters() != null && AcidUtils.isTransactionalTable(table.getMetaStoreTable().getParameters())) {
            throw new AnalysisException("CONVERT TO ICEBERG is not supported for transactional tables");
        }
        if (!MetaStoreUtils.isExternalTable((Table)table.getMetaStoreTable())) {
            throw new AnalysisException("CONVERT TO ICEBERG is not supported for managed tables");
        }
        StorageDescriptor sd = table.getMetaStoreTable().getSd();
        if (MigrateTableUtil.getFileFormat(sd) == null) {
            throw new AnalysisException("CONVERT TO ICEBERG is not supported for " + sd.getInputFormat());
        }
        this.checkColumnTypeCompatibility(table);
        if (this.properties_.size() > 1 || this.properties_.keySet().stream().anyMatch(key -> !key.equalsIgnoreCase("iceberg.catalog"))) {
            throw new AnalysisException(String.format("CONVERT TO ICEBERG only accepts '%s' as TBLPROPERTY.", "iceberg.catalog"));
        }
        if (TIcebergCatalog.HADOOP_CATALOG == IcebergUtil.getTIcebergCatalog(this.properties_)) {
            throw new AnalysisException("The Hadoop Catalog is not supported because the location may change");
        }
        this.createSubQueryStrings((FeFsTable)table);
    }

    private void checkColumnTypeCompatibility(FeTable table) throws AnalysisException {
        try {
            IcebergSchemaConverter.convertToIcebergSchema(table.getMetaStoreTable());
        }
        catch (IllegalArgumentException e) {
            throw new AnalysisException("Incompatible column type in source table. " + e.getMessage());
        }
    }

    private void createSubQueryStrings(FeFsTable table) {
        this.setHdfsTablePropertiesQuery_ = QueryStringBuilder.SetTblProps.builder().table(table.getFullName()).property("external.table.purge", "false").property("TRANSLATED_TO_EXTERNAL", "FALSE").build();
        this.tmpHdfsTableName_ = this.createTmpTableName();
        Preconditions.checkState((boolean)this.tmpHdfsTableName_.isFullyQualified());
        this.renameHdfsTableToTemporaryQuery_ = QueryStringBuilder.Rename.builder().source(table.getFullName()).target(this.tmpHdfsTableName_.toString()).build();
        this.refreshTemporaryHdfsTableQuery_ = QueryStringBuilder.Refresh.builder().table(this.tmpHdfsTableName_.toString()).build();
        this.resetTableNameQuery_ = QueryStringBuilder.Rename.builder().source(this.tmpHdfsTableName_.toString()).target(table.getFullName()).build();
        if (!IcebergUtil.isHiveCatalog(this.properties_)) {
            Preconditions.checkState((boolean)this.tableName_.isFullyQualified());
            QueryStringBuilder.Create create = QueryStringBuilder.Create.builder().table(this.tableName_.toString(), true).storedAs(THdfsFileFormat.ICEBERG.toString()).tableLocation(table.getLocation());
            for (Map.Entry<String, String> propEntry : this.properties_.entrySet()) {
                create.property(propEntry.getKey(), propEntry.getValue());
            }
            this.createIcebergTableQuery_ = create.build();
            this.postCreateAlterTableQuery_ = QueryStringBuilder.SetTblProps.builder().table(this.tableName_.toString()).property("external.table.purge", "true").build();
        } else {
            this.invalidateMetadataQuery_ = QueryStringBuilder.Invalidate.builder().table(this.tableName_.toString()).build();
        }
        this.dropTemporaryHdfsTableQuery_ = QueryStringBuilder.Drop.builder().table(this.tmpHdfsTableName_.toString()).build();
    }

    private TableName createTmpTableName() {
        String tmpTableNameStr = QueryStringBuilder.createTmpTableName(this.tableName_.getDb(), this.tableName_.getTbl());
        return TableName.parse(tmpTableNameStr);
    }

    public TConvertTableRequest toThrift() {
        Preconditions.checkNotNull((Object)this.tableName_);
        Preconditions.checkNotNull((Object)this.tmpHdfsTableName_);
        TConvertTableRequest params = new TConvertTableRequest(this.tableName_.toThrift(), this.tmpHdfsTableName_.toThrift(), THdfsFileFormat.ICEBERG);
        params.setProperties(this.properties_);
        params.setSet_hdfs_table_properties_query(this.setHdfsTablePropertiesQuery_);
        params.setRename_hdfs_table_to_temporary_query(this.renameHdfsTableToTemporaryQuery_);
        params.setRefresh_temporary_hdfs_table_query(this.refreshTemporaryHdfsTableQuery_);
        params.setReset_table_name_query(this.resetTableNameQuery_);
        if (!Strings.isNullOrEmpty((String)this.createIcebergTableQuery_)) {
            params.setCreate_iceberg_table_query(this.createIcebergTableQuery_);
        }
        if (!Strings.isNullOrEmpty((String)this.invalidateMetadataQuery_)) {
            params.setInvalidate_metadata_query(this.invalidateMetadataQuery_);
        }
        if (!Strings.isNullOrEmpty((String)this.postCreateAlterTableQuery_)) {
            params.setPost_create_alter_table_query(this.postCreateAlterTableQuery_);
        }
        params.setDrop_temporary_hdfs_table_query(this.dropTemporaryHdfsTableQuery_);
        return params;
    }
}

