/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.DateLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TimestampLiteral;
import org.apache.impala.common.Pair;

public class ConstantPredicateHandler {
    private Map<Integer, Pair<Expr, Boolean>> equalityPreds_ = new HashMap<Integer, Pair<Expr, Boolean>>();
    private Map<SlotRef, List<Expr>> rangePreds_ = new HashMap<SlotRef, List<Expr>>();
    private Map<Integer, Expr> dateTimePreds_ = new HashMap<Integer, Expr>();

    public void classifyPredicates(List<Expr> conjuncts, BitSet candidates) {
        int i = candidates.nextSetBit(0);
        while (i >= 0) {
            BinaryPredicate bp;
            boolean isRangeOp;
            Expr conjunct = conjuncts.get(i);
            if (Expr.IS_BINARY_PREDICATE.apply((Object)conjunct) && ((isRangeOp = BinaryPredicate.IS_RANGE_PREDICATE.apply((Object)(bp = (BinaryPredicate)conjunct))) || bp.getOp() == BinaryPredicate.Operator.EQ)) {
                SlotRef slotRef = bp.getBoundSlot();
                if (slotRef == null || !((Expr)bp.getChild(1)).isConstant()) {
                    if (ConstantPredicateHandler.isCandidateDateTimeExpr(bp)) {
                        this.dateTimePreds_.put(i, bp);
                    }
                } else {
                    Expr constant = (Expr)bp.getChild(1);
                    if (!isRangeOp || constant instanceof DateLiteral || constant instanceof TimestampLiteral) {
                        if (isRangeOp) {
                            List rangePreds = this.rangePreds_.getOrDefault(slotRef, new ArrayList());
                            rangePreds.add(bp);
                            this.rangePreds_.put(slotRef, rangePreds);
                        } else {
                            this.equalityPreds_.put(i, new Pair<BinaryPredicate, Boolean>(bp, false));
                        }
                    }
                }
            }
            i = candidates.nextSetBit(i + 1);
        }
    }

    public void propagateConstantPreds(List<Expr> conjuncts, BitSet changed, List<Expr> keepConjuncts, Analyzer analyzer) {
        for (Map.Entry<Integer, Pair<Expr, Boolean>> entry : this.equalityPreds_.entrySet()) {
            Pair<Expr, Boolean> value = entry.getValue();
            if (((Boolean)value.second).booleanValue()) continue;
            BinaryPredicate bp = (BinaryPredicate)value.first;
            SlotRef slotRef = bp.getBoundSlot();
            Preconditions.checkNotNull((Object)slotRef);
            Expr subst = bp.getSlotBinding(slotRef.getSlotId());
            ExprSubstitutionMap smap = new ExprSubstitutionMap();
            smap.put(slotRef, ConstantPredicateHandler.getTargetExpr(slotRef, subst));
            for (int j = 0; j < conjuncts.size(); ++j) {
                Object rewritten;
                Expr toRewrite = conjuncts.get(j);
                if (toRewrite == bp || ((Expr)(rewritten = toRewrite.substitute(smap, analyzer, true))).equals(toRewrite)) continue;
                conjuncts.set(j, (Expr)rewritten);
                changed.set(j, true);
                if (!this.equalityPreds_.containsKey(j)) continue;
                this.equalityPreds_.get((Object)Integer.valueOf((int)j)).second = true;
            }
        }
        if (this.dateTimePreds_.size() == 0) {
            return;
        }
        for (Map.Entry<Integer, Object> entry : this.dateTimePreds_.entrySet()) {
            int index = entry.getKey();
            Expr dtExpr = (Expr)entry.getValue();
            ArrayList<Expr> rewrittenExprs = new ArrayList<Expr>();
            for (Map.Entry<SlotRef, List<Expr>> e : this.rangePreds_.entrySet()) {
                SlotRef slotRef = e.getKey();
                List<Expr> rangePredsList = e.getValue();
                if (rangePredsList.size() == 0) continue;
                for (Expr rangePred : rangePredsList) {
                    if (rangePred == dtExpr) continue;
                    BinaryPredicate bp = (BinaryPredicate)rangePred;
                    Expr subst = bp.getSlotBinding(slotRef.getSlotId());
                    ExprSubstitutionMap smap = new ExprSubstitutionMap();
                    smap.put(slotRef, ConstantPredicateHandler.getTargetExpr(slotRef, subst));
                    Expr toRewrite = dtExpr.clone();
                    Expr rewritten = (toRewrite = this.rewriteWithOp((BinaryPredicate)toRewrite, bp.getOp(), analyzer)).substitute(smap, analyzer, true);
                    if (rewritten.equals(toRewrite)) continue;
                    rewrittenExprs.add(rewritten);
                }
                if (rewrittenExprs.size() <= 0) continue;
                keepConjuncts.add(dtExpr);
                Expr finalRewritten = CompoundPredicate.createConjunctivePredicate(rewrittenExprs);
                conjuncts.set(index, finalRewritten);
                changed.set(index, true);
            }
        }
    }

    public static boolean isCandidateDateTimeExpr(BinaryPredicate bp) {
        return ((Expr)bp.getChild(0)).getType().isDateOrTimeType() && bp.getOp() == BinaryPredicate.Operator.EQ && bp.getChild(1) instanceof CastExpr;
    }

    private Expr rewriteWithOp(BinaryPredicate pred, BinaryPredicate.Operator newOp, Analyzer analyzer) {
        if (newOp == BinaryPredicate.Operator.LT) {
            newOp = BinaryPredicate.Operator.LE;
        } else if (newOp == BinaryPredicate.Operator.GT) {
            newOp = BinaryPredicate.Operator.GE;
        }
        if (pred.getOp() == newOp) {
            return pred;
        }
        BinaryPredicate newPred = new BinaryPredicate(newOp, (Expr)pred.getChild(0), (Expr)pred.getChild(1));
        newPred.analyzeNoThrow(analyzer);
        return newPred;
    }

    private static Expr getTargetExpr(SlotRef source, Expr target) {
        Expr expr = source.getType().equals(target.getType()) ? target : new CastExpr(source.getType(), target);
        return expr;
    }
}

