/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.SystemTableRef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TableSampleClause;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.PartitionStatsUtil;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.thrift.TComputeStatsParams;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TGetPartitionStatsResponse;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TUnit;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.log4j.Logger;

public class ComputeStatsStmt
extends StatementBase {
    private static final Logger LOG = Logger.getLogger(ComputeStatsStmt.class);
    private static String AVRO_SCHEMA_MSG_PREFIX = "Cannot COMPUTE STATS on Avro table '%s' because its column definitions do not match those in the Avro schema.";
    private static String AVRO_SCHEMA_MSG_SUFFIX = "Please re-create the table with column definitions, e.g., using the result of 'SHOW CREATE TABLE'";
    private static final String STATS_FETCH_PREFIX = "StatsFetch";
    private static final String STATS_FETCH_TIME = "StatsFetch.Time";
    private static final String STATS_FETCH_COMPRESSED_BYTES = "StatsFetch.CompressedBytes";
    private static final String STATS_FETCH_TOTAL_PARTITIONS = "StatsFetch.TotalPartitions";
    private static final String STATS_FETCH_NUM_PARTITIONS_WITH_STATS = "StatsFetch.NumPartitionsWithStats";
    private static final int MAX_INCREMENTAL_PARTITIONS = 1000;
    protected final TableName tableName_;
    protected final TableSampleClause sampleParams_;
    protected FeTable table_;
    protected double effectiveSamplePerc_ = -1.0;
    protected String tableStatsQueryStr_;
    protected String columnStatsQueryStr_;
    private boolean isIncremental_;
    private boolean expectAllPartitions_;
    private final List<TPartitionStats> validPartStats_ = new ArrayList<TPartitionStats>();
    private final List<List<String>> expectedPartitions_ = new ArrayList<List<String>>();
    private PartitionSet partitionSet_;
    private List<String> columnWhitelist_;
    private Set<Column> validatedColumnWhitelist_;

    private ComputeStatsStmt(TableName tableName, TableSampleClause sampleParams, boolean isIncremental, PartitionSet partitionSet, List<String> columns) {
        Preconditions.checkState((tableName != null && !tableName.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((isIncremental || partitionSet == null ? 1 : 0) != 0);
        Preconditions.checkState((!isIncremental || sampleParams == null ? 1 : 0) != 0);
        this.tableName_ = tableName;
        this.sampleParams_ = sampleParams;
        this.table_ = null;
        this.isIncremental_ = isIncremental;
        this.partitionSet_ = partitionSet;
        this.columnWhitelist_ = columns;
        if (this.partitionSet_ != null) {
            this.partitionSet_.setTableName(tableName);
            this.partitionSet_.setPrivilegeRequirement(Privilege.ALTER);
        }
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    public static ComputeStatsStmt createStatsStmt(TableName tableName, TableSampleClause sampleParams, List<String> columns) {
        return new ComputeStatsStmt(tableName, sampleParams, false, null, columns);
    }

    public static ComputeStatsStmt createIncrementalStatsStmt(TableName tableName, PartitionSet partitionSet, List<String> columns) {
        return new ComputeStatsStmt(tableName, null, true, partitionSet, columns);
    }

    private List<String> getBaseColumnStatsQuerySelectList(Analyzer analyzer) {
        ArrayList<String> columnStatsSelectList = new ArrayList<String>();
        int startColIdx = this.table_ instanceof FeHBaseTable ? 0 : this.table_.getNumClusteringCols();
        boolean computeMinMax = analyzer.getQueryCtx().getClient_request().getQuery_options().isCompute_column_minmax_stats() && this.hasAtLeastOneParquetPartition();
        for (int i = startColIdx; i < this.table_.getColumns().size(); ++i) {
            Column c = this.table_.getColumns().get(i);
            if (this.validatedColumnWhitelist_ != null && !this.validatedColumnWhitelist_.contains(c) || this.ignoreColumn(c)) continue;
            String colRefSql = ToSqlUtils.getIdentSql(c.getName());
            if (c.getType().isBinary()) {
                columnStatsSelectList.add("NULL AS " + colRefSql);
            } else if (this.isIncremental_) {
                columnStatsSelectList.add("NDV_NO_FINALIZE(" + colRefSql + ") AS " + colRefSql);
            } else if (this.isSampling()) {
                columnStatsSelectList.add(String.format("SAMPLED_NDV(%s, %.10f) AS %s", colRefSql, this.effectiveSamplePerc_, colRefSql));
            } else {
                columnStatsSelectList.add("NDV(" + colRefSql + ") AS " + colRefSql);
            }
            columnStatsSelectList.add("COUNT(CASE WHEN " + colRefSql + " IS NULL THEN 1 ELSE NULL END)");
            Type type = c.getType();
            if (type.isStringType()) {
                columnStatsSelectList.add("MAX(length(" + colRefSql + "))");
                columnStatsSelectList.add("AVG(length(" + colRefSql + "))");
            } else {
                Integer typeSize = type.getPrimitiveType().getSlotSize();
                columnStatsSelectList.add(typeSize.toString());
                columnStatsSelectList.add("CAST(" + typeSize.toString() + " as DOUBLE)");
            }
            if (this.isIncremental_) {
                columnStatsSelectList.add("COUNT(" + colRefSql + ")");
            }
            if (type.isBoolean()) {
                columnStatsSelectList.add("COUNT(CASE WHEN " + colRefSql + " = TRUE THEN 1 ELSE NULL END)");
                columnStatsSelectList.add("COUNT(CASE WHEN " + colRefSql + " = FALSE THEN 1 ELSE NULL END)");
            } else {
                columnStatsSelectList.add("NULL");
                columnStatsSelectList.add("NULL");
            }
            String min_expr = null;
            String max_expr = null;
            if (computeMinMax && MetaStoreUtil.canStoreMinmaxInHMS(type)) {
                min_expr = "MIN(" + colRefSql + ")";
                max_expr = "MAX(" + colRefSql + ")";
            } else {
                min_expr = "NULL";
                max_expr = "NULL";
            }
            columnStatsSelectList.add(min_expr);
            columnStatsSelectList.add(max_expr);
        }
        return columnStatsSelectList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        void var7_29;
        TableRef tableRef = new TableRef(this.tableName_.toPath(), null, Privilege.ALTER);
        tableRef = analyzer.resolveTableRef(tableRef);
        Preconditions.checkNotNull((Object)tableRef);
        tableRef.analyze(analyzer);
        if (tableRef instanceof InlineViewRef) {
            throw new AnalysisException(String.format("COMPUTE STATS not supported for view: %s", this.tableName_));
        }
        if (tableRef instanceof CollectionTableRef) {
            throw new AnalysisException(String.format("COMPUTE STATS not supported for nested collection: %s", this.tableName_));
        }
        if (tableRef instanceof SystemTableRef) {
            throw new AnalysisException(String.format("COMPUTE STATS not supported for system table: %s", this.tableName_));
        }
        this.table_ = analyzer.getTable(this.tableName_, Privilege.ALTER, Privilege.SELECT);
        if (!(this.table_ instanceof FeFsTable)) {
            if (this.partitionSet_ != null) {
                throw new AnalysisException("COMPUTE INCREMENTAL ... PARTITION not supported for non-HDFS table " + this.tableName_);
            }
            this.isIncremental_ = false;
        }
        if (this.table_ instanceof FeIcebergTable) {
            if (this.partitionSet_ != null) {
                throw new AnalysisException("COMPUTE INCREMENTAL ... PARTITION not supported for Iceberg table " + this.tableName_);
            }
            this.isIncremental_ = false;
        }
        if (this.columnWhitelist_ != null) {
            this.validatedColumnWhitelist_ = new HashSet<Column>();
            for (String colName : this.columnWhitelist_) {
                Column col = this.table_.getColumn(colName);
                if (col == null) {
                    throw new AnalysisException(colName + " not found in table: " + this.table_.getName());
                }
                if (this.table_ instanceof FeFsTable && this.table_.isClusteringColumn(col)) {
                    throw new AnalysisException("COMPUTE STATS not supported for partitioning column " + col.getName() + " of HDFS table.");
                }
                if (this.ignoreColumn(col)) {
                    throw new AnalysisException("COMPUTE STATS not supported for column " + col.getName() + " of complex type:" + col.getType().toSql());
                }
                this.validatedColumnWhitelist_.add(col);
            }
        }
        FeFsTable hdfsTable = null;
        if (this.table_ instanceof FeFsTable) {
            hdfsTable = (FeFsTable)this.table_;
            if (hdfsTable.usesAvroSchemaOverride()) {
                this.checkIncompleteAvroSchema(hdfsTable);
            }
            if (this.isIncremental_ && hdfsTable.getNumClusteringCols() == 0 && this.partitionSet_ != null) {
                throw new AnalysisException(String.format("Can't compute PARTITION stats on an unpartitioned table: %s", this.tableName_));
            }
            if (this.partitionSet_ != null) {
                Preconditions.checkState((boolean)(tableRef instanceof BaseTableRef));
                this.partitionSet_.setPartitionShouldExist();
                this.partitionSet_.analyze(analyzer);
            }
            if (this.isIncremental_) {
                long numOfAllIncStatsPartitions = 0L;
                Collection<? extends FeFsPartition> collection = FeCatalogUtils.loadAllPartitions(hdfsTable);
                if (this.partitionSet_ == null) {
                    numOfAllIncStatsPartitions = collection.size();
                } else {
                    HashSet hashSet = Sets.newHashSetWithExpectedSize((int)this.partitionSet_.getPartitions().size());
                    for (FeFsPartition feFsPartition : this.partitionSet_.getPartitions()) {
                        hashSet.add(feFsPartition.getId());
                    }
                    for (FeFsPartition feFsPartition : collection) {
                        if (!feFsPartition.hasIncrementalStats() || hashSet.contains(feFsPartition.getId())) continue;
                        ++numOfAllIncStatsPartitions;
                    }
                    numOfAllIncStatsPartitions += (long)this.partitionSet_.getPartitions().size();
                }
                long l = BackendConfig.INSTANCE.getIncStatsMaxSize();
                long l2 = (long)hdfsTable.getColumns().size() * numOfAllIncStatsPartitions * 200L;
                if (l2 > l) {
                    LOG.error((Object)("Incremental stats size estimate for table " + hdfsTable.getName() + " exceeded " + l + ", estimate = " + l2));
                    throw new AnalysisException("Incremental stats size estimate exceeds " + PrintUtils.printBytes(l) + ". Please try COMPUTE STATS instead.");
                }
            }
        }
        ArrayList<String> filterPreds = new ArrayList<String>();
        if (this.isIncremental_) {
            if (this.partitionSet_ == null) {
                boolean bl;
                boolean tableIsMissingColStats = false;
                boolean bl2 = true;
                Object var7_20 = null;
                for (Column column : this.table_.getNonClusteringColumns()) {
                    if (this.ignoreColumn(column)) continue;
                    if (!column.getStats().hasStats()) {
                        if (tableIsMissingColStats) continue;
                        tableIsMissingColStats = true;
                        String string = column.getName();
                        continue;
                    }
                    bl = false;
                }
                if (tableIsMissingColStats && !bl) {
                    void var7_21;
                    analyzer.addWarning("Column " + (String)var7_21 + " does not have statistics, recomputing stats for the whole table");
                }
                Collection<? extends FeFsPartition> allPartitions2 = FeCatalogUtils.loadAllPartitions(hdfsTable);
                Map<Long, TPartitionStats> map = ComputeStatsStmt.getOrFetchPartitionStats(analyzer, hdfsTable, allPartitions2, Collections.emptySet());
                for (FeFsPartition feFsPartition : allPartitions2) {
                    TPartitionStats partStats = map.get(feFsPartition.getId());
                    if (partStats == null || tableIsMissingColStats) {
                        if (!tableIsMissingColStats) {
                            filterPreds.add(feFsPartition.getConjunctSql());
                        }
                        List<String> partValues = PartitionKeyValue.getPartitionKeyValueStringList(feFsPartition.getPartitionValues(), "NULL");
                        this.expectedPartitions_.add(partValues);
                        continue;
                    }
                    this.validPartStats_.add(partStats);
                }
                if (this.expectedPartitions_.size() == hdfsTable.getPartitions().size()) {
                    this.expectedPartitions_.clear();
                    this.expectAllPartitions_ = true;
                }
            } else {
                for (FeFsPartition feFsPartition : this.partitionSet_.getPartitions()) {
                    filterPreds.add(feFsPartition.getConjunctSql());
                    List<String> list = PartitionKeyValue.getPartitionKeyValueStringList(feFsPartition.getPartitionValues(), "NULL");
                    this.expectedPartitions_.add(list);
                }
                HashSet targetPartitions = Sets.newHashSetWithExpectedSize((int)this.partitionSet_.getPartitions().size());
                for (FeFsPartition feFsPartition : this.partitionSet_.getPartitions()) {
                    targetPartitions.add(feFsPartition.getId());
                }
                Collection<? extends FeFsPartition> collection = FeCatalogUtils.loadAllPartitions(hdfsTable);
                Map<Long, TPartitionStats> map = ComputeStatsStmt.getOrFetchPartitionStats(analyzer, hdfsTable, collection, targetPartitions);
                this.validPartStats_.addAll(map.values());
            }
            if (filterPreds.size() == 0 && this.validPartStats_.size() != 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"No partitions selected for incremental stats update");
                }
                analyzer.addWarning("No partitions selected for incremental stats update");
                return;
            }
        } else {
            this.expectAllPartitions_ = true;
            if (this.table_ instanceof FeFsTable) {
                boolean bl = this.expectAllPartitions_ = !FeFsTable.Utils.isStatsExtrapolationEnabled((FeFsTable)this.table_);
            }
        }
        if (filterPreds.size() > 1000) {
            analyzer.addWarning("Too many partitions selected, doing full recomputation of incremental stats");
            filterPreds.clear();
            this.validPartStats_.clear();
        }
        String tableSampleSql = this.analyzeTableSampleClause(analyzer);
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        String string = "COUNT(*)";
        if (this.isSampling()) {
            String string2 = String.format("CAST(ROUND(COUNT(*) / %.10f) AS BIGINT)", this.effectiveSamplePerc_);
        }
        ArrayList tableStatsSelectList = Lists.newArrayList((Object[])new String[]{var7_29});
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.updateTableStatsOnly()) {
            for (Column column : hdfsTable.getClusteringColumns()) {
                arrayList.add(ToSqlUtils.getIdentSql(column.getName()));
            }
            tableStatsSelectList.addAll(arrayList);
        }
        stringBuilder.append(Joiner.on((String)", ").join((Iterable)tableStatsSelectList));
        stringBuilder.append(" FROM " + this.tableName_.toSql() + tableSampleSql);
        List<String> columnStatsSelectList = this.getBaseColumnStatsQuerySelectList(analyzer);
        if (this.isIncremental_) {
            columnStatsSelectList.addAll(arrayList);
        }
        StringBuilder stringBuilder2 = new StringBuilder("SELECT ");
        stringBuilder2.append(Joiner.on((String)", ").join(columnStatsSelectList));
        stringBuilder2.append(" FROM " + this.tableName_.toSql() + tableSampleSql);
        if (filterPreds.size() > 0 && (this.validPartStats_.size() > 0 || this.partitionSet_ != null)) {
            String filterClause = " WHERE " + Joiner.on((String)" OR ").join(filterPreds);
            stringBuilder2.append(filterClause);
            stringBuilder.append(filterClause);
        }
        if (arrayList.size() > 0) {
            String groupBy = " GROUP BY " + Joiner.on((String)", ").join(arrayList);
            if (this.isIncremental_) {
                stringBuilder2.append(groupBy);
            }
            stringBuilder.append(groupBy);
        }
        this.tableStatsQueryStr_ = stringBuilder.toString();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Table stats query: " + this.tableStatsQueryStr_));
        }
        if (columnStatsSelectList.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("No supported column types in table " + this.table_.getTableName() + ", no column statistics will be gathered."));
            }
            this.columnStatsQueryStr_ = null;
            return;
        }
        this.columnStatsQueryStr_ = stringBuilder2.toString();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Column stats query: " + this.columnStatsQueryStr_));
        }
    }

    private static Map<Long, TPartitionStats> getOrFetchPartitionStats(Analyzer analyzer, FeFsTable table, Collection<? extends FeFsPartition> partitions, Set<Long> excludedPartitions) throws AnalysisException {
        Preconditions.checkNotNull(partitions);
        Preconditions.checkNotNull(excludedPartitions);
        int expectedNumStats = partitions.size() - excludedPartitions.size();
        Preconditions.checkArgument((expectedNumStats >= 0 ? 1 : 0) != 0);
        if (!BackendConfig.INSTANCE.getBackendCfg().use_local_catalog && !RuntimeEnv.INSTANCE.isTestEnv()) {
            ArrayList<FeFsPartition> partitionsToFetch = new ArrayList<FeFsPartition>();
            for (FeFsPartition feFsPartition : partitions) {
                if (excludedPartitions.contains(feFsPartition.getId())) continue;
                partitionsToFetch.add(feFsPartition);
            }
            return ComputeStatsStmt.fetchPartitionStats(analyzer, table, partitionsToFetch);
        }
        HashMap ret = Maps.newHashMapWithExpectedSize((int)expectedNumStats);
        for (FeFsPartition feFsPartition : partitions) {
            if (excludedPartitions.contains(feFsPartition.getId()) || !feFsPartition.hasIncrementalStats()) continue;
            TPartitionStats stats = feFsPartition.getPartitionStats();
            Preconditions.checkNotNull((Object)stats);
            ret.put(feFsPartition.getId(), stats);
        }
        return ret;
    }

    private static Map<Long, TPartitionStats> fetchPartitionStats(Analyzer analyzer, FeFsTable table, List<FeFsPartition> partitions) throws AnalysisException {
        Preconditions.checkNotNull(partitions);
        Preconditions.checkState((!RuntimeEnv.INSTANCE.isTestEnv() ? 1 : 0) != 0);
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        Stopwatch sw = Stopwatch.createStarted();
        int numCompressedBytes = 0;
        int totalPartitions = 0;
        int numPartitionsWithStats = 0;
        try {
            TGetPartitionStatsResponse response = analyzer.getCatalog().getPartitionStats(table.getTableName());
            if (response.status.status_code != TErrorCode.OK) {
                throw new AnalysisException("Error fetching partition statistics: " + response.status.toString());
            }
            if (!response.isSetPartition_stats()) {
                Map<Long, TPartitionStats> map = Collections.emptyMap();
                return map;
            }
            HashMap partitionStats = Maps.newHashMapWithExpectedSize((int)partitions.size());
            totalPartitions = partitions.size();
            for (FeFsPartition part : partitions) {
                ByteBuffer compressedStats = response.partition_stats.get(FeCatalogUtils.getPartitionName(part));
                if (compressedStats == null) continue;
                byte[] compressedStatsBytes = new byte[compressedStats.remaining()];
                numCompressedBytes += compressedStatsBytes.length;
                compressedStats.get(compressedStatsBytes);
                TPartitionStats remoteStats = PartitionStatsUtil.partStatsFromCompressedBytes(compressedStatsBytes, part);
                if (remoteStats == null || !remoteStats.isSetIntermediate_col_stats()) continue;
                ++numPartitionsWithStats;
                partitionStats.put(part.getId(), remoteStats);
            }
            HashMap hashMap = partitionStats;
            return hashMap;
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, AnalysisException.class);
            throw new AnalysisException("Error fetching partition statistics", e);
        }
        finally {
            ComputeStatsStmt.recordFetchMetrics(numCompressedBytes, totalPartitions, numPartitionsWithStats, sw);
        }
    }

    private static void recordFetchMetrics(int numCompressedBytes, int totalPartitions, int numPartitionsWithStats, Stopwatch stopwatch) {
        FrontendProfile profile = FrontendProfile.getCurrentOrNull();
        if (profile == null) {
            return;
        }
        profile.addToCounter(STATS_FETCH_COMPRESSED_BYTES, TUnit.BYTES, numCompressedBytes);
        profile.addToCounter(STATS_FETCH_TOTAL_PARTITIONS, TUnit.NONE, totalPartitions);
        profile.addToCounter(STATS_FETCH_NUM_PARTITIONS_WITH_STATS, TUnit.NONE, numPartitionsWithStats);
        profile.addToCounter(STATS_FETCH_TIME, TUnit.TIME_MS, stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private String analyzeTableSampleClause(Analyzer analyzer) throws AnalysisException {
        if (this.sampleParams_ == null) {
            return "";
        }
        if (!(this.table_ instanceof FeFsTable)) {
            throw new AnalysisException("TABLESAMPLE is only supported on HDFS tables.");
        }
        FeFsTable hdfsTable = (FeFsTable)this.table_;
        if (!FeFsTable.Utils.isStatsExtrapolationEnabled(hdfsTable)) {
            throw new AnalysisException(String.format("COMPUTE STATS TABLESAMPLE requires stats extrapolation which is disabled.\nStats extrapolation can be enabled service-wide with %s=true or by altering the table to have tblproperty %s=true", "--enable_stats_extrapolation", "impala.enable.stats.extrapolation"));
        }
        this.sampleParams_.analyze(analyzer);
        long sampleSeed = this.sampleParams_.hasRandomSeed() ? this.sampleParams_.getRandomSeed() : System.currentTimeMillis();
        long minSampleBytes = analyzer.getQueryOptions().compute_stats_min_sample_size;
        long samplePerc = this.sampleParams_.getPercentBytes();
        Collection<? extends FeFsPartition> partitions = FeCatalogUtils.loadAllPartitions(hdfsTable);
        Map<Long, List<HdfsPartition.FileDescriptor>> sample = FeFsTable.Utils.getFilesSample(hdfsTable, partitions, samplePerc, minSampleBytes, sampleSeed);
        long sampleFileBytes = 0L;
        for (List<HdfsPartition.FileDescriptor> fds : sample.values()) {
            for (HdfsPartition.FileDescriptor fd : fds) {
                sampleFileBytes += fd.getFileLength();
            }
        }
        long totalFileBytes = ((FeFsTable)this.table_).getTotalHdfsBytes();
        this.effectiveSamplePerc_ = totalFileBytes > 0L ? (double)sampleFileBytes / (double)totalFileBytes : 0.0;
        Preconditions.checkState((this.effectiveSamplePerc_ >= 0.0 && this.effectiveSamplePerc_ <= 1.0 ? 1 : 0) != 0);
        if (this.effectiveSamplePerc_ == 1.0) {
            Preconditions.checkState((!this.isSampling() ? 1 : 0) != 0);
            analyzer.addWarning(String.format("Ignoring TABLESAMPLE because the effective sampling rate is 100%%.\nThe minimum sample size is COMPUTE_STATS_MIN_SAMPLE_SIZE=%s and the table size %s", PrintUtils.printBytes(minSampleBytes), PrintUtils.printBytes(totalFileBytes)));
        }
        if (!this.isSampling()) {
            return "";
        }
        return " " + this.sampleParams_.toSql(sampleSeed);
    }

    private void checkIncompleteAvroSchema(FeFsTable table) throws AnalysisException {
        Preconditions.checkState((boolean)table.usesAvroSchemaOverride());
        Table msTable = table.getMetaStoreTable();
        Iterator colDefs = msTable.getSd().getCols().iterator();
        Iterator<Column> avroSchemaCols = table.getColumns().iterator();
        for (int i = 0; i < table.getNumClusteringCols(); ++i) {
            if (!avroSchemaCols.hasNext()) continue;
            avroSchemaCols.next();
        }
        int pos = 0;
        while (colDefs.hasNext() || avroSchemaCols.hasNext()) {
            FieldSchema colDef;
            if (colDefs.hasNext() && avroSchemaCols.hasNext()) {
                colDef = (FieldSchema)colDefs.next();
                Column avroSchemaCol = avroSchemaCols.next();
                if (!colDef.getName().equalsIgnoreCase(avroSchemaCol.getName())) {
                    throw new AnalysisException(String.format(AVRO_SCHEMA_MSG_PREFIX + "\nDefinition of column '%s' of type '%s' does not match the Avro-schema column '%s' of type '%s' at position '%s'.\n" + AVRO_SCHEMA_MSG_SUFFIX, table.getName(), colDef.getName(), colDef.getType(), avroSchemaCol.getName(), avroSchemaCol.getType(), pos));
                }
            }
            if (colDefs.hasNext() && !avroSchemaCols.hasNext()) {
                colDef = (FieldSchema)colDefs.next();
                throw new AnalysisException(String.format(AVRO_SCHEMA_MSG_PREFIX + "\nMissing Avro-schema column corresponding to column definition '%s' of type '%s' at position '%s'.\n" + AVRO_SCHEMA_MSG_SUFFIX, table.getName(), colDef.getName(), colDef.getType(), pos));
            }
            if (!colDefs.hasNext() && avroSchemaCols.hasNext()) {
                Column avroSchemaCol = avroSchemaCols.next();
                throw new AnalysisException(String.format(AVRO_SCHEMA_MSG_PREFIX + "\nMissing column definition corresponding to Avro-schema column '%s' of type '%s' at position '%s'.\n" + AVRO_SCHEMA_MSG_SUFFIX, table.getName(), avroSchemaCol.getName(), avroSchemaCol.getType(), pos));
            }
            ++pos;
        }
    }

    private boolean updateTableStatsOnly() {
        if (!(this.table_ instanceof FeFsTable)) {
            return true;
        }
        return !this.isIncremental_ && FeFsTable.Utils.isStatsExtrapolationEnabled((FeFsTable)this.table_);
    }

    private boolean isSampling() {
        Preconditions.checkState((this.effectiveSamplePerc_ == -1.0 || this.effectiveSamplePerc_ >= 0.0 || this.effectiveSamplePerc_ <= 1.0 ? 1 : 0) != 0);
        return this.effectiveSamplePerc_ > 0.0 && this.effectiveSamplePerc_ < 1.0;
    }

    private boolean ignoreColumn(Column c) {
        Type t = c.getType();
        return !t.isValid() || !t.isSupported() || t.isComplexType();
    }

    public double getEffectiveSamplingPerc() {
        return this.effectiveSamplePerc_;
    }

    public String getTblStatsQuery() {
        return this.tableStatsQueryStr_;
    }

    public String getColStatsQuery() {
        return this.columnStatsQueryStr_;
    }

    public Set<Column> getValidatedColumnWhitelist() {
        return this.validatedColumnWhitelist_;
    }

    public boolean isColumnar() {
        if (!(this.table_ instanceof FeFsTable)) {
            return false;
        }
        Collection<? extends FeFsPartition> affectedPartitions = null;
        if (this.partitionSet_ != null) {
            affectedPartitions = this.partitionSet_.getPartitions();
        } else {
            FeFsTable hdfsTable = (FeFsTable)this.table_;
            affectedPartitions = FeCatalogUtils.loadAllPartitions(hdfsTable);
        }
        for (FeFsPartition feFsPartition : affectedPartitions) {
            if (feFsPartition.getFileFormat() == HdfsFileFormat.PARQUET || feFsPartition.getFileFormat() == HdfsFileFormat.HUDI_PARQUET || feFsPartition.getFileFormat() == HdfsFileFormat.ORC) continue;
            return false;
        }
        if (this.table_ instanceof FeIcebergTable) {
            return FeIcebergTable.Utils.isColumnar((FeIcebergTable)this.table_);
        }
        return true;
    }

    public boolean hasAtLeastOneParquetPartition() {
        if (!(this.table_ instanceof FeFsTable)) {
            return false;
        }
        FeFsTable hdfsTable = (FeFsTable)this.table_;
        Set<Long> partitionIds = hdfsTable.getPartitionIds();
        if (partitionIds.size() > 0) {
            for (Long partitionId : partitionIds) {
                FeFsPartition feFsPartition = FeCatalogUtils.loadPartition(hdfsTable, partitionId);
                if (!feFsPartition.getFileFormat().isParquetBased()) continue;
                return true;
            }
        } else {
            Collection<? extends FeFsPartition> allPartitions = FeCatalogUtils.loadAllPartitions(hdfsTable);
            for (FeFsPartition feFsPartition : allPartitions) {
                if (!feFsPartition.getFileFormat().isParquetBased()) continue;
                return true;
            }
        }
        return false;
    }

    public PartitionSet getPartitionSet() {
        return this.partitionSet_;
    }

    public TableName getTableName() {
        return this.tableName_;
    }

    public boolean isIncremental() {
        return this.isIncremental_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (!this.isIncremental_) {
            StringBuilder columnList = new StringBuilder();
            if (this.columnWhitelist_ != null) {
                columnList.append("(");
                columnList.append(Joiner.on((String)", ").join(this.columnWhitelist_));
                columnList.append(")");
            }
            String tblsmpl = "";
            if (this.sampleParams_ != null) {
                tblsmpl = " " + this.sampleParams_.toSql(options);
            }
            return "COMPUTE STATS " + this.tableName_.toSql() + columnList.toString() + tblsmpl;
        }
        return "COMPUTE INCREMENTAL STATS " + this.tableName_.toSql() + (this.partitionSet_ == null ? "" : this.partitionSet_.toSql(options));
    }

    public TComputeStatsParams toThrift() {
        TComputeStatsParams params = new TComputeStatsParams();
        params.setTable_name(new TTableName(this.table_.getDb().getName(), this.table_.getName()));
        params.setTbl_stats_query(this.tableStatsQueryStr_);
        if (this.columnStatsQueryStr_ != null) {
            params.setCol_stats_query(this.columnStatsQueryStr_);
        } else {
            params.setCol_stats_queryIsSet(false);
        }
        params.setIs_incremental(this.isIncremental_);
        params.setExisting_part_stats(this.validPartStats_);
        params.setExpect_all_partitions(this.expectAllPartitions_);
        if (!this.expectAllPartitions_) {
            params.setExpected_partitions(this.expectedPartitions_);
        }
        if (this.isIncremental_) {
            params.setNum_partition_cols(((FeFsTable)this.table_).getNumClusteringCols());
        }
        if (this.table_ instanceof FeFsTable) {
            params.setTotal_file_bytes(((FeFsTable)this.table_).getTotalHdfsBytes());
        }
        return params;
    }
}

