/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCommentOnParams;

public abstract class CommentOnStmt
extends StatementBase {
    protected final String comment_;

    public CommentOnStmt(String comment) {
        this.comment_ = comment;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.comment_ != null && this.comment_.length() > 256) {
            throw new AnalysisException(String.format("Comment exceeds maximum length of %d characters. The given comment has %d characters.", 256, this.comment_.length()));
        }
    }

    public TCommentOnParams toThrift() {
        TCommentOnParams params = new TCommentOnParams();
        params.setComment(this.comment_);
        return params;
    }
}

