/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnName;
import org.apache.impala.analysis.CommentOnStmt;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TColumnName;
import org.apache.impala.thrift.TCommentOnParams;

public class CommentOnColumnStmt
extends CommentOnStmt {
    private TableName tableName_;
    private final String columnName_;

    public CommentOnColumnStmt(ColumnName columnName, String comment) {
        super(comment);
        Preconditions.checkNotNull((Object)columnName);
        this.tableName_ = columnName.getTableName();
        this.columnName_ = columnName.getColumnName();
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        FeTable feTable;
        super.analyze(analyzer);
        this.tableName_ = analyzer.getFqTableName(this.tableName_);
        TableRef tableRef = new TableRef(this.tableName_.toPath(), null, Privilege.ALTER);
        tableRef = analyzer.resolveTableRef(tableRef);
        Preconditions.checkNotNull((Object)tableRef);
        tableRef.analyze(analyzer);
        String tableRefType = "";
        if (tableRef instanceof InlineViewRef) {
            InlineViewRef inlineViewRef = (InlineViewRef)tableRef;
            feTable = inlineViewRef.getView();
            tableRefType = "view";
        } else {
            feTable = tableRef.getTable();
            tableRefType = "table";
        }
        Column column = feTable.getColumn(this.columnName_);
        if (column == null) {
            throw new AnalysisException(String.format("Column '%s' does not exist in %s: %s", this.columnName_, tableRefType, this.tableName_));
        }
    }

    @Override
    public TCommentOnParams toThrift() {
        TCommentOnParams params = super.toThrift();
        params.setColumn_name(new TColumnName(this.tableName_.toThrift(), this.columnName_));
        return params;
    }
}

