/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.util.ExprUtil;
import org.apache.impala.util.KuduUtil;
import org.apache.kudu.ColumnSchema;

public class ColumnDef {
    private final String colName_;
    private final TypeDef typeDef_;
    private Type type_;
    private String comment_;
    private boolean isPrimaryKey_;
    private boolean isPrimaryKeyUnique_;
    private Boolean isNullable_;
    private String encodingVal_;
    private ColumnSchema.Encoding encoding_;
    private String compressionVal_;
    private ColumnSchema.CompressionAlgorithm compression_;
    private Expr defaultValue_;
    private Expr outputDefaultValue_;
    private LiteralExpr blockSize_;

    public ColumnDef(String colName, TypeDef typeDef, Map<Option, Object> options) {
        Preconditions.checkNotNull(options);
        this.colName_ = colName.toLowerCase();
        this.typeDef_ = typeDef;
        block9: for (Map.Entry<Option, Object> option : options.entrySet()) {
            switch (option.getKey()) {
                case IS_PRIMARY_KEY: {
                    Preconditions.checkState((boolean)(option.getValue() instanceof Pair));
                    this.isPrimaryKey_ = (Boolean)((Pair)option.getValue()).first;
                    this.isPrimaryKeyUnique_ = (Boolean)((Pair)option.getValue()).second;
                    continue block9;
                }
                case IS_NULLABLE: {
                    Preconditions.checkState((boolean)(option.getValue() instanceof Boolean));
                    this.isNullable_ = (Boolean)option.getValue();
                    continue block9;
                }
                case ENCODING: {
                    Preconditions.checkState((boolean)(option.getValue() instanceof String));
                    this.encodingVal_ = ((String)option.getValue()).toUpperCase();
                    continue block9;
                }
                case COMPRESSION: {
                    Preconditions.checkState((boolean)(option.getValue() instanceof String));
                    this.compressionVal_ = ((String)option.getValue()).toUpperCase();
                    continue block9;
                }
                case DEFAULT: {
                    Preconditions.checkState((boolean)(option.getValue() instanceof Expr));
                    this.defaultValue_ = (Expr)option.getValue();
                    continue block9;
                }
                case BLOCK_SIZE: {
                    Preconditions.checkState((boolean)(option.getValue() instanceof LiteralExpr));
                    this.blockSize_ = (LiteralExpr)option.getValue();
                    continue block9;
                }
                case COMMENT: {
                    Preconditions.checkState((boolean)(option.getValue() instanceof String));
                    this.comment_ = (String)option.getValue();
                    continue block9;
                }
            }
            throw new IllegalStateException(String.format("Illegal option %s", new Object[]{option.getKey()}));
        }
    }

    public ColumnDef(String colName, TypeDef typeDef) {
        this(colName, typeDef, Collections.emptyMap());
    }

    private ColumnDef(FieldSchema fs) throws AnalysisException {
        Type type = Type.parseColumnType(fs.getType());
        if (type == null) {
            throw new AnalysisException(String.format("Unsupported type '%s' in Hive field schema '%s'", fs.getType(), fs.getName()));
        }
        this.colName_ = fs.getName();
        this.typeDef_ = new TypeDef(type);
        this.comment_ = fs.getComment();
        this.analyze(null);
    }

    public String getColName() {
        return this.colName_;
    }

    public void setType(Type type) {
        this.type_ = type;
    }

    public Type getType() {
        return this.type_;
    }

    public TypeDef getTypeDef() {
        return this.typeDef_;
    }

    boolean isPrimaryKey() {
        return this.isPrimaryKey_;
    }

    boolean isPrimaryKeyUnique() {
        return this.isPrimaryKeyUnique_;
    }

    public void setComment(String comment) {
        this.comment_ = comment;
    }

    public String getComment() {
        return this.comment_;
    }

    public boolean hasKuduOptions() {
        return this.isPrimaryKey() || this.isNullabilitySet() || this.hasEncoding() || this.hasCompression() || this.hasDefaultValue() || this.hasBlockSize();
    }

    public boolean hasIcebergOptions() {
        return this.isNullabilitySet();
    }

    public boolean hasIncompatibleIcebergOptions() {
        return this.isPrimaryKey() || this.hasEncoding() || this.hasCompression() || this.hasDefaultValue() || this.hasBlockSize();
    }

    public boolean hasIncompatibleKuduOptions() {
        return false;
    }

    public boolean hasEncoding() {
        return this.encodingVal_ != null;
    }

    public boolean hasCompression() {
        return this.compressionVal_ != null;
    }

    public boolean hasBlockSize() {
        return this.blockSize_ != null;
    }

    public boolean isNullabilitySet() {
        return this.isNullable_ != null;
    }

    public boolean isExplicitNullable() {
        return this.isNullabilitySet() && this.isNullable_ != false;
    }

    public boolean isExplicitNotNullable() {
        return this.isNullabilitySet() && this.isNullable_ == false;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue_ != null;
    }

    public Expr getDefaultValue() {
        return this.defaultValue_;
    }

    public void setNullable(Boolean nullable) {
        this.isNullable_ = nullable;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (!MetastoreShim.validateColumnName(this.colName_)) {
            throw new AnalysisException("Invalid column/field name: " + this.colName_);
        }
        if (this.typeDef_ != null) {
            this.typeDef_.analyze(null);
            this.type_ = this.typeDef_.getType();
        }
        Preconditions.checkNotNull((Object)this.type_);
        Preconditions.checkState((boolean)this.type_.isValid());
        if (this.hasKuduOptions()) {
            Preconditions.checkNotNull((Object)analyzer);
            this.analyzeKuduOptions(analyzer);
        }
        if (this.comment_ != null && this.comment_.length() > 256) {
            throw new AnalysisException(String.format("Comment of column '%s' exceeds maximum length of %d characters:\n%s has %d characters.", this.colName_, 256, this.comment_, this.comment_.length()));
        }
    }

    private void analyzeKuduOptions(Analyzer analyzer) throws AnalysisException {
        if (this.isPrimaryKey_ && this.isNullable_ != null && this.isNullable_.booleanValue()) {
            throw new AnalysisException(KuduUtil.getPrimaryKeyString(this.isPrimaryKeyUnique_) + " columns cannot be nullable: " + this.toString());
        }
        if (this.encodingVal_ != null) {
            try {
                this.encoding_ = ColumnSchema.Encoding.valueOf((String)this.encodingVal_);
            }
            catch (IllegalArgumentException e) {
                throw new AnalysisException(String.format("Unsupported encoding value '%s'. Supported encoding values are: %s", this.encodingVal_, Joiner.on((String)", ").join((Object[])ColumnSchema.Encoding.values())));
            }
        }
        if (this.compressionVal_ != null) {
            try {
                this.compression_ = ColumnSchema.CompressionAlgorithm.valueOf((String)this.compressionVal_);
            }
            catch (IllegalArgumentException e) {
                throw new AnalysisException(String.format("Unsupported compression algorithm '%s'. Supported compression algorithms are: %s", this.compressionVal_, Joiner.on((String)", ").join((Object[])ColumnSchema.CompressionAlgorithm.values())));
            }
        }
        if (this.defaultValue_ != null) {
            try {
                this.defaultValue_.analyze(analyzer);
            }
            catch (AnalysisException e) {
                throw new AnalysisException(String.format("Only constant values are allowed for default values: %s", this.defaultValue_.toSql()), e);
            }
            if (!this.defaultValue_.isConstant()) {
                throw new AnalysisException(String.format("Only constant values are allowed for default values: %s", this.defaultValue_.toSql()));
            }
            LiteralExpr defaultValLiteral = LiteralExpr.createBounded(this.defaultValue_, analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
            if (defaultValLiteral == null) {
                throw new AnalysisException(String.format("Only constant values are allowed for default values: %s", this.defaultValue_.toSql()));
            }
            if (Expr.IS_NULL_VALUE.apply((Object)defaultValLiteral) && (this.isNullable_ != null && !this.isNullable_.booleanValue() || this.isPrimaryKey_)) {
                throw new AnalysisException(String.format("Default value of NULL not allowed on non-nullable column: '%s'", this.getColName()));
            }
            if (defaultValLiteral.getType().isStringType() && this.type_.isTimestamp()) {
                CastExpr e = new CastExpr(new TypeDef(Type.TIMESTAMP), (Expr)defaultValLiteral);
                e.analyze(analyzer);
                defaultValLiteral = LiteralExpr.create(e, analyzer.getQueryCtx());
                Preconditions.checkNotNull((Object)defaultValLiteral);
                if (Expr.IS_NULL_VALUE.apply((Object)defaultValLiteral)) {
                    throw new AnalysisException(String.format("String %s cannot be cast to a TIMESTAMP literal.", this.defaultValue_.toSql()));
                }
            }
            TypeCompatibility compatibility = analyzer.getRegularCompatibilityLevel(TypeCompatibility.STRICT);
            if (!Type.isImplicitlyCastable(defaultValLiteral.getType(), this.type_, compatibility)) {
                throw new AnalysisException(String.format("Default value %s (type: %s) is not compatible with column '%s' (type: %s).", this.defaultValue_.toSql(), this.defaultValue_.getType().toSql(), this.colName_, this.type_.toSql()));
            }
            if (!defaultValLiteral.getType().equals(this.type_)) {
                Expr castLiteral = defaultValLiteral.uncheckedCastTo(this.type_);
                Preconditions.checkNotNull((Object)castLiteral);
                defaultValLiteral = LiteralExpr.createBounded(castLiteral, analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
            }
            Preconditions.checkNotNull((Object)defaultValLiteral);
            this.outputDefaultValue_ = defaultValLiteral;
            if (this.type_.isTimestamp()) {
                try {
                    long unixTimeMicros = ExprUtil.utcTimestampToUnixTimeMicros(analyzer, defaultValLiteral);
                    this.outputDefaultValue_ = new NumericLiteral(BigInteger.valueOf(unixTimeMicros), (Type)Type.BIGINT);
                }
                catch (Exception e) {
                    throw new AnalysisException(String.format("%s cannot be cast to a TIMESTAMP literal.", this.defaultValue_.toSql()), e);
                }
            }
        }
        if (this.blockSize_ != null) {
            this.blockSize_.analyze(null);
            if (!this.blockSize_.getType().isIntegerType()) {
                throw new AnalysisException(String.format("Invalid value for BLOCK_SIZE: %s. A positive INTEGER value is expected.", this.blockSize_.toSql()));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.colName_).append(" ");
        if (this.type_ != null) {
            sb.append(this.type_.toSql());
        } else {
            sb.append(this.typeDef_.toSql());
        }
        if (this.isPrimaryKey_) {
            sb.append(" ").append(KuduUtil.getPrimaryKeyString(this.isPrimaryKeyUnique_));
        }
        if (this.isNullable_ != null) {
            sb.append(this.isNullable_ != false ? " NULL" : " NOT NULL");
        }
        if (this.encoding_ != null) {
            sb.append(" ENCODING " + this.encoding_.toString());
        }
        if (this.compression_ != null) {
            sb.append(" COMPRESSION " + this.compression_.toString());
        }
        if (this.defaultValue_ != null) {
            sb.append(" DEFAULT " + this.defaultValue_.toSql());
        }
        if (this.blockSize_ != null) {
            sb.append(" BLOCK_SIZE " + this.blockSize_.toSql());
        }
        if (this.comment_ != null) {
            sb.append(String.format(" COMMENT '%s'", this.comment_));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ColumnDef rhs = (ColumnDef)obj;
        return new EqualsBuilder().append((Object)this.colName_, (Object)rhs.colName_).append((Object)this.comment_, (Object)rhs.comment_).append(this.isPrimaryKey_, rhs.isPrimaryKey_).append(this.isPrimaryKeyUnique_, rhs.isPrimaryKeyUnique_).append((Object)this.typeDef_, (Object)rhs.typeDef_).append((Object)this.type_, (Object)rhs.type_).append((Object)this.isNullable_, (Object)rhs.isNullable_).append((Object)this.encoding_, (Object)rhs.encoding_).append((Object)this.compression_, (Object)rhs.compression_).append((Object)this.defaultValue_, (Object)rhs.defaultValue_).append((Object)this.blockSize_, (Object)rhs.blockSize_).isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.colName_, this.comment_, this.isPrimaryKey_, this.isPrimaryKeyUnique_, this.typeDef_, this.type_, this.isNullable_, this.encoding_, this.compression_, this.defaultValue_, this.blockSize_);
    }

    public TColumn toThrift() {
        TColumn col = new TColumn(this.getColName(), this.type_.toThrift());
        Integer blockSize = this.blockSize_ == null ? null : Integer.valueOf(((NumericLiteral)this.blockSize_).getIntValue());
        KuduUtil.setColumnOptions(col, this.isPrimaryKey_, this.isPrimaryKeyUnique_, this.isNullable_, false, this.encoding_, this.compression_, this.outputDefaultValue_, blockSize, this.colName_);
        if (this.comment_ != null) {
            col.setComment(this.comment_);
        }
        return col;
    }

    public static List<ColumnDef> createFromFieldSchemas(List<FieldSchema> fieldSchemas) throws AnalysisException {
        ArrayList result = Lists.newArrayListWithCapacity((int)fieldSchemas.size());
        for (FieldSchema fs : fieldSchemas) {
            result.add(new ColumnDef(fs));
        }
        return result;
    }

    public static List<FieldSchema> toFieldSchemas(List<ColumnDef> colDefs) {
        return Lists.transform(colDefs, (Function)new Function<ColumnDef, FieldSchema>(){

            public FieldSchema apply(ColumnDef colDef) {
                Preconditions.checkNotNull((Object)colDef.getType());
                return new FieldSchema(colDef.getColName(), colDef.getType().toSql(), colDef.getComment());
            }
        });
    }

    static List<String> toColumnNames(Collection<ColumnDef> colDefs) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (ColumnDef colDef : colDefs) {
            colNames.add(colDef.getColName());
        }
        return colNames;
    }

    static Map<String, ColumnDef> mapByColumnNames(Collection<ColumnDef> colDefs) {
        LinkedHashMap<String, ColumnDef> colDefsByColName = new LinkedHashMap<String, ColumnDef>();
        for (ColumnDef colDef : colDefs) {
            ColumnDef def = colDefsByColName.put(colDef.getColName(), colDef);
            Preconditions.checkState((def == null ? 1 : 0) != 0);
        }
        return colDefsByColName;
    }

    public static enum Option {
        IS_PRIMARY_KEY,
        IS_NULLABLE,
        ENCODING,
        COMPRESSION,
        DEFAULT,
        BLOCK_SIZE,
        COMMENT;

    }
}

