/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.UnnestExpr;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;

public class CollectionTableRef
extends TableRef {
    private Expr collectionExpr_;
    private boolean inSelectList_ = false;

    public CollectionTableRef(TableRef tableRef, Path resolvedPath, boolean inSelectList) {
        super(tableRef);
        Preconditions.checkState((boolean)resolvedPath.isResolved());
        this.resolvedPath_ = resolvedPath;
        this.inSelectList_ = inSelectList;
        if (this.hasExplicitAlias()) {
            return;
        }
        String implicitAlias = ((String)this.rawPath_.get(this.rawPath_.size() - 1)).toLowerCase();
        this.aliases_ = this.rawPath_.size() > 1 ? new String[]{String.join((CharSequence)".", this.rawPath_).toLowerCase(), implicitAlias} : new String[]{implicitAlias};
    }

    public CollectionTableRef(CollectionTableRef other) {
        super(other);
        this.inSelectList_ = other.inSelectList_;
        this.collectionExpr_ = other.collectionExpr_ != null ? other.collectionExpr_.clone() : null;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        SlotDescriptor parentSlotDesc;
        if (this.isAnalyzed_) {
            return;
        }
        InlineViewRef sourceView = null;
        if (this.resolvedPath_.getRootDesc() != null) {
            sourceView = this.resolvedPath_.getRootDesc().getSourceView();
        }
        if (this.zippingUnnestType_ == TableRef.ZippingUnnestType.FROM_CLAUSE_ZIPPING_UNNEST) {
            UnnestExpr.verifyNotInsideStruct(this.resolvedPath_);
            Type type = this.resolvedPath_.getMatchedTypes().get(this.resolvedPath_.getMatchedTypes().size() - 1);
            UnnestExpr.verifyContainsNoStruct(type);
        }
        if (sourceView != null && this.zippingUnnestType_ == TableRef.ZippingUnnestType.FROM_CLAUSE_ZIPPING_UNNEST) {
            String implicitAlias = ((String)this.rawPath_.get(this.rawPath_.size() - 1)).toLowerCase();
            analyzer.addZippingUnnestTupleId(analyzer.getDescriptor(implicitAlias).getId());
            TableRef existingTableRef = analyzer.getRegisteredTableRef(this.getUniqueAlias());
            existingTableRef.getDesc().setHidden(false);
        }
        if (sourceView == null || this.inSelectList_) {
            this.desc_ = analyzer.registerTableRef(this);
            if (this.inSelectList_) {
                this.setHidden(true);
                this.desc_.setHidden(true);
            }
        }
        if (!this.isRelative() && this.resolvedPath_.getRootTable() instanceof FeView) {
            throw new AnalysisException("Non-relative collections are currently not supported on collections from views.");
        }
        if (this.isRelative() && sourceView != null && !this.inSelectList_) {
            parentSlotDesc = analyzer.getSlotDescriptor(this.resolvedPath_.getFullyQualifiedRawPath());
            this.collectionExpr_ = new SlotRef(parentSlotDesc);
            this.collectionExpr_ = this.collectionExpr_.trySubstitute(sourceView.getBaseTblSmap(), analyzer, true);
            this.desc_ = ((SlotRef)this.collectionExpr_).getDesc().getItemTupleDesc();
            Preconditions.checkState((boolean)this.desc_.isHidden());
            this.desc_.setHidden(false);
            analyzer.addCollectionTableRef(this.getUniqueAlias(), this, this.desc_);
        }
        if (this.isRelative() && (!analyzer.hasWithClause() || this.inSelectList_)) {
            if (sourceView == null || this.inSelectList_) {
                parentSlotDesc = analyzer.registerSlotRef(this.resolvedPath_);
                parentSlotDesc.setItemTupleDesc(this.desc_);
                this.collectionExpr_ = new SlotRef(parentSlotDesc);
            }
            if (!this.inSelectList_) {
                analyzer.materializeSlots(this.collectionExpr_);
            }
            TupleId rootTupleId = this.resolvedPath_.getRootDesc().getId();
            if (this.resolvedPath_.isMaskedPath()) {
                Preconditions.checkState((boolean)this.resolvedPath_.getPathBeforeMasking().isRootedAtTuple());
                rootTupleId = this.resolvedPath_.getPathBeforeMasking().getRootDesc().getId();
            }
            Analyzer parentAnalyzer = analyzer.findAnalyzer(rootTupleId);
            Preconditions.checkNotNull((Object)parentAnalyzer);
            if (parentAnalyzer != analyzer) {
                TableRef parentRef = parentAnalyzer.getTableRef(rootTupleId);
                Preconditions.checkNotNull((Object)parentRef);
                Preconditions.checkState((!(parentRef instanceof InlineViewRef) || parentRef.isTableMaskingView() ? 1 : 0) != 0);
                this.correlatedTupleIds_.add(this.resolvedPath_.getRootDesc().getId());
            }
        }
        if (!this.isRelative()) {
            Preconditions.checkNotNull((Object)this.resolvedPath_.getRootTable());
            analyzer.registerAuthAndAuditEvent(this.resolvedPath_.getRootTable(), this.priv_, this.requireGrantOption_);
            analyzer.registerPrivReq(builder -> builder.allOf(Privilege.SELECT).onColumn(this.desc_.getTableName().getDb(), this.desc_.getTableName().getTbl(), this.desc_.getPath().getRawPath().get(0), this.resolvedPath_.getRootTable().getOwnerUser()).build());
        }
        this.isAnalyzed_ = true;
        this.analyzeTableSample(analyzer);
        this.analyzeHints(analyzer);
        this.analyzeJoin(analyzer);
    }

    @Override
    public boolean isRelative() {
        Preconditions.checkNotNull((Object)this.resolvedPath_);
        return this.resolvedPath_.getRootDesc() != null;
    }

    public Expr getCollectionExpr() {
        return this.collectionExpr_;
    }

    @Override
    public boolean isCollectionInSelectList() {
        return this.inSelectList_;
    }

    @Override
    protected CollectionTableRef clone() {
        return new CollectionTableRef(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.collectionExpr_ = null;
        this.inSelectList_ = false;
    }
}

