/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;

public class CollectionStructType
extends StructType {
    private final boolean isMapStruct_;
    private final StructField optionalField_;

    private CollectionStructType(List<StructField> fields, boolean isMapStruct) {
        super(fields);
        this.isMapStruct_ = isMapStruct;
        this.optionalField_ = this.isMapStruct_ ? this.getField("value") : this.getField("item");
        Preconditions.checkNotNull((Object)this.optionalField_);
    }

    public static CollectionStructType createArrayStructType(ArrayType arrayType) {
        Type itemType = arrayType.getItemType();
        ArrayList fields = Lists.newArrayListWithCapacity((int)2);
        fields.add(new StructField("item", itemType));
        fields.add(new StructField("pos", ScalarType.BIGINT));
        return new CollectionStructType(fields, false);
    }

    public static CollectionStructType createMapStructType(MapType mapType) {
        ArrayList mapFields = Lists.newArrayListWithCapacity((int)2);
        mapFields.add(new StructField("key", mapType.getKeyType()));
        mapFields.add(new StructField("value", mapType.getValueType()));
        return new CollectionStructType(mapFields, true);
    }

    public StructField getOptionalField() {
        return this.optionalField_;
    }

    public boolean isMapStruct() {
        return this.isMapStruct_;
    }

    public boolean isArrayStruct() {
        return !this.isMapStruct_;
    }
}

