/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TBoolLiteral;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class BoolLiteral
extends LiteralExpr {
    private final boolean value_;

    public BoolLiteral(boolean value) {
        this.value_ = value;
        this.selectivity_ = value ? 1.0 : 0.0;
        this.type_ = Type.BOOLEAN;
    }

    public BoolLiteral(String value) throws AnalysisException {
        this.type_ = Type.BOOLEAN;
        if (value.toLowerCase().equals("true")) {
            this.value_ = true;
            this.selectivity_ = 1.0;
        } else if (value.toLowerCase().equals("false")) {
            this.value_ = false;
            this.selectivity_ = 0.0;
        } else {
            throw new AnalysisException("invalid BOOLEAN literal: " + value);
        }
    }

    protected BoolLiteral(BoolLiteral other) {
        super(other);
        this.value_ = other.value_;
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value_).toString();
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && ((BoolLiteral)that).value_ == this.value_;
    }

    @Override
    public int hashCode() {
        return this.value_ ? 1 : 0;
    }

    public boolean getValue() {
        return this.value_;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return this.getStringValue();
    }

    @Override
    public String getStringValue() {
        return this.value_ ? "TRUE" : "FALSE";
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.BOOL_LITERAL;
        msg.bool_literal = new TBoolLiteral(this.value_);
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) throws AnalysisException {
        if (targetType.equals(this.type_)) {
            return this;
        }
        return new CastExpr(targetType, (Expr)this, compatibility);
    }

    @Override
    public int compareTo(LiteralExpr o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        BoolLiteral other = (BoolLiteral)o;
        if (this.value_ && !other.getValue()) {
            return 1;
        }
        if (!this.value_ && other.getValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public Expr clone() {
        return new BoolLiteral(this);
    }
}

