/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ExistsPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprId;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.Reference;
import org.apache.impala.extdatasource.thrift.TComparisonOp;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class BinaryPredicate
extends Predicate {
    private boolean isInferred_ = false;
    private ExprId betweenExprId_ = null;
    private double betweenSelectivity_ = -1.0;
    public static final com.google.common.base.Predicate<BinaryPredicate> IS_RANGE_PREDICATE = new com.google.common.base.Predicate<BinaryPredicate>(){

        public boolean apply(BinaryPredicate arg) {
            return arg.getOp() == Operator.LT || arg.getOp() == Operator.LE || arg.getOp() == Operator.GT || arg.getOp() == Operator.GE;
        }
    };
    public static final com.google.common.base.Predicate<BinaryPredicate> IS_EQ_PREDICATE = new com.google.common.base.Predicate<BinaryPredicate>(){

        public boolean apply(BinaryPredicate arg) {
            return arg.getOp() == Operator.EQ;
        }
    };
    private Operator op_;

    public static void initBuiltins(Db db) {
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull()) continue;
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.EQ.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.NE.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.LE.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.GE.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.LT.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.GT.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
        }
    }

    public Operator getOp() {
        return this.op_;
    }

    public void setOp(Operator op) {
        this.op_ = op;
    }

    public BinaryPredicate(Operator op, Expr e1, Expr e2) {
        this.op_ = op;
        Preconditions.checkNotNull((Object)e1);
        this.children_.add(e1);
        Preconditions.checkNotNull((Object)e2);
        this.children_.add(e2);
    }

    protected BinaryPredicate(BinaryPredicate other) {
        super(other);
        this.op_ = other.op_;
        this.isInferred_ = other.isInferred_;
        this.betweenExprId_ = other.betweenExprId_;
        this.betweenSelectivity_ = other.betweenSelectivity_;
    }

    public boolean isNullMatchingEq() {
        return this.op_ == Operator.NULL_MATCHING_EQ;
    }

    public boolean isInferred() {
        return this.isInferred_;
    }

    public void setIsInferred() {
        this.isInferred_ = true;
    }

    public boolean hasIdenticalOperands() {
        return this.getChild(0) != null && ((Expr)this.getChild(0)).equals(this.getChild(1));
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return ((Expr)this.getChild(0)).toSql(options) + " " + this.op_.toString() + " " + ((Expr)this.getChild(1)).toSql(options);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        Preconditions.checkState((this.children_.size() == 2 ? 1 : 0) != 0);
        Preconditions.checkState((!this.contains(Subquery.class) ? 1 : 0) != 0);
        Preconditions.checkState((((Expr)this.getChild(0)).getType().getPrimitiveType() == ((Expr)this.getChild(1)).getType().getPrimitiveType() ? 1 : 0) != 0, (Object)("child 0 type: " + ((Expr)this.getChild(0)).getType() + " child 1 type: " + ((Expr)this.getChild(1)).getType()));
        msg.node_type = TExprNodeType.FUNCTION_CALL;
    }

    @Override
    public String debugString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper((Object)this);
        toStrHelper.add("op", (Object)this.op_).addValue((Object)super.debugString());
        if (this.isAuxExpr()) {
            toStrHelper.add("isAux", true);
        }
        if (this.isInferred_) {
            toStrHelper.add("isInferred", true);
        }
        if (this.derivedFromBetween()) {
            toStrHelper.add("betweenExprId", (Object)this.betweenExprId_);
            toStrHelper.add("betweenSelectivity", this.betweenSelectivity_);
        }
        return toStrHelper.toString();
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        this.convertNumericLiteralsFromDecimal(analyzer);
        String opName = this.op_.getName().equals("null_matching_eq") ? "eq" : this.op_.getName();
        this.fn_ = this.getBuiltinFunction(analyzer, opName, this.collectChildReturnTypes(), Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        if (this.fn_ == null) {
            throw new AnalysisException("operands of type " + ((Expr)this.getChild(0)).getType().toSql() + " and " + ((Expr)this.getChild(1)).getType().toSql() + " are not comparable: " + this.toSql());
        }
        Preconditions.checkState((boolean)this.fn_.getReturnType().isBoolean());
        ArrayList subqueries = new ArrayList();
        this.collectAll(Predicates.instanceOf(Subquery.class), subqueries);
        if (subqueries.size() > 1) {
            throw new AnalysisException("Multiple subqueries are not supported in binary predicates: " + this.toSql());
        }
        if (this.contains(ExistsPredicate.class)) {
            throw new AnalysisException("EXISTS subquery predicates are not supported in binary predicates: " + this.toSql());
        }
        ArrayList inPredicates = new ArrayList();
        this.collect(InPredicate.class, inPredicates);
        for (InPredicate inPredicate : inPredicates) {
            if (!inPredicate.contains(Subquery.class)) continue;
            throw new AnalysisException("IN subquery predicates are not supported in binary predicates: " + this.toSql());
        }
        if (!this.contains(Subquery.class)) {
            this.castForFunctionCall(true, analyzer.getRegularCompatibilityLevel());
        }
        this.computeSelectivity();
    }

    protected void computeSelectivity() {
        FeTable table;
        if (this.hasValidSelectivityHint()) {
            return;
        }
        Reference<SlotRef> slotRefRef = new Reference<SlotRef>();
        if (!this.isSingleColumnPredicate(slotRefRef, null)) {
            return;
        }
        boolean rChildIsNull = Expr.IS_NULL_LITERAL.apply(this.getChild(1));
        long distinctValues = slotRefRef.getRef().getNumDistinctValues();
        if (distinctValues < 0L) {
            return;
        }
        if (distinctValues == 0L && (this.op_ == Operator.EQ || this.op_ == Operator.NE) || rChildIsNull && (this.op_ == Operator.EQ || this.op_ == Operator.NE)) {
            this.selectivity_ = 0.0;
            return;
        }
        if (this.op_ == Operator.EQ || this.op_ == Operator.NOT_DISTINCT) {
            this.selectivity_ = 1.0 / (double)distinctValues;
        } else if (this.op_ == Operator.NE || this.op_ == Operator.DISTINCT_FROM) {
            this.selectivity_ = this.op_ == Operator.DISTINCT_FROM && rChildIsNull ? 1.0 : (distinctValues == 1L ? 0.5 : 1.0 - 1.0 / (double)distinctValues);
        } else {
            return;
        }
        SlotDescriptor slotDesc = slotRefRef.getRef().getDesc();
        if (slotDesc.getStats().hasNullsStats() && (table = slotDesc.getParent().getTable()) != null && table.getNumRows() > 0L) {
            long numRows = table.getNumRows();
            long numNulls = slotDesc.getStats().getNumNulls();
            if (this.op_ == Operator.EQ || this.op_ == Operator.NE || this.op_ == Operator.DISTINCT_FROM && rChildIsNull || this.op_ == Operator.NOT_DISTINCT && !rChildIsNull) {
                this.selectivity_ *= (double)(numRows - numNulls) / (double)numRows;
            } else if (this.op_ == Operator.NOT_DISTINCT && rChildIsNull) {
                this.selectivity_ = numNulls / numRows;
            } else if (this.op_ == Operator.DISTINCT_FROM && !rChildIsNull) {
                this.selectivity_ = this.selectivity_ * (double)(numRows - numNulls) / (double)numRows + (double)(numNulls / numRows);
            }
        }
        this.selectivity_ = Math.max(0.0, Math.min(1.0, this.selectivity_));
    }

    @Override
    protected float computeEvalCost() {
        if (!this.hasChildCosts()) {
            return -1.0f;
        }
        if (((Expr)this.getChild(0)).getType().isFixedLengthType()) {
            return this.getChildCosts() + 1.0f;
        }
        if (((Expr)this.getChild(0)).getType().isStringType()) {
            return this.getChildCosts() + (float)(BinaryPredicate.getAvgStringLength((Expr)this.getChild(0)) + BinaryPredicate.getAvgStringLength((Expr)this.getChild(1))) * 1.0f;
        }
        return this.getChildCosts() + 5.0f;
    }

    public Expr getSlotBinding(SlotId id) {
        SlotRef slotRef = ((Expr)this.getChild(0)).unwrapSlotRef(false);
        if (slotRef != null && slotRef.getSlotId() == id) {
            return (Expr)this.getChild(1);
        }
        return null;
    }

    public static Pair<SlotId, SlotId> getEqSlots(Expr e) {
        if (!(e instanceof BinaryPredicate)) {
            return null;
        }
        return ((BinaryPredicate)e).getEqSlots();
    }

    @Override
    public Pair<SlotId, SlotId> getEqSlots() {
        if (this.op_ != Operator.EQ) {
            return null;
        }
        SlotRef lhs = ((Expr)this.getChild(0)).unwrapSlotRef(true);
        if (lhs == null) {
            return null;
        }
        SlotRef rhs = ((Expr)this.getChild(1)).unwrapSlotRef(true);
        if (rhs == null) {
            return null;
        }
        return new Pair<SlotId, SlotId>(lhs.getSlotId(), rhs.getSlotId());
    }

    @Override
    public SlotRef getBoundSlot() {
        return ((Expr)this.getChild(0)).unwrapSlotRef(true);
    }

    @Override
    public Expr negate() {
        Operator newOp = null;
        switch (this.op_) {
            case EQ: {
                newOp = Operator.NE;
                break;
            }
            case NE: {
                newOp = Operator.EQ;
                break;
            }
            case LT: {
                newOp = Operator.GE;
                break;
            }
            case LE: {
                newOp = Operator.GT;
                break;
            }
            case GE: {
                newOp = Operator.LT;
                break;
            }
            case GT: {
                newOp = Operator.LE;
                break;
            }
            case DISTINCT_FROM: {
                newOp = Operator.NOT_DISTINCT;
                break;
            }
            case NOT_DISTINCT: {
                newOp = Operator.DISTINCT_FROM;
                break;
            }
            case NULL_MATCHING_EQ: {
                throw new IllegalStateException("Not implemented");
            }
        }
        return new BinaryPredicate(newOp, (Expr)this.getChild(0), (Expr)this.getChild(1));
    }

    public void reverse() {
        Collections.swap(this.children_, 0, 1);
        this.op_ = this.op_.converse();
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && this.op_.equals((Object)((BinaryPredicate)that).op_);
    }

    @Override
    protected int localHash() {
        return Objects.hash(new Object[]{super.localHash(), this.op_});
    }

    @Override
    public Expr clone() {
        return new BinaryPredicate(this);
    }

    public void setBetweenSelectivity(ExprId betweenExprId, double betweenSelectivity) {
        this.betweenExprId_ = betweenExprId;
        this.betweenSelectivity_ = betweenSelectivity;
    }

    public boolean derivedFromBetween() {
        return this.betweenExprId_ != null;
    }

    public ExprId getBetweenExprId() {
        return this.betweenExprId_;
    }

    public double getBetweenSelectivity() {
        return this.betweenSelectivity_;
    }

    public static enum Operator {
        EQ("=", "eq", TComparisonOp.EQ),
        NE("!=", "ne", TComparisonOp.NE),
        LE("<=", "le", TComparisonOp.LE),
        GE(">=", "ge", TComparisonOp.GE),
        LT("<", "lt", TComparisonOp.LT),
        GT(">", "gt", TComparisonOp.GT),
        DISTINCT_FROM("IS DISTINCT FROM", "distinctfrom", TComparisonOp.DISTINCT_FROM),
        NOT_DISTINCT("IS NOT DISTINCT FROM", "notdistinct", TComparisonOp.NOT_DISTINCT),
        NULL_MATCHING_EQ("=", "null_matching_eq", TComparisonOp.EQ);

        private final String description_;
        private final String name_;
        private final TComparisonOp thriftOp_;

        private Operator(String description, String name, TComparisonOp thriftOp) {
            this.description_ = description;
            this.name_ = name;
            this.thriftOp_ = thriftOp;
        }

        public String toString() {
            return this.description_;
        }

        public String getName() {
            return this.name_;
        }

        public TComparisonOp getThriftOp() {
            return this.thriftOp_;
        }

        public boolean isEquivalence() {
            return this == EQ || this == NOT_DISTINCT;
        }

        public boolean isSqlEquivalence() {
            return this == EQ;
        }

        public boolean isSingleRange() {
            return this == EQ || this == LE || this == GE || this == LT || this == GT;
        }

        public Operator converse() {
            switch (this) {
                case EQ: {
                    return EQ;
                }
                case NE: {
                    return NE;
                }
                case LE: {
                    return GE;
                }
                case GE: {
                    return LE;
                }
                case LT: {
                    return GT;
                }
                case GT: {
                    return LT;
                }
                case DISTINCT_FROM: {
                    return DISTINCT_FROM;
                }
                case NOT_DISTINCT: {
                    return NOT_DISTINCT;
                }
                case NULL_MATCHING_EQ: {
                    throw new IllegalStateException("Not implemented");
                }
            }
            throw new IllegalStateException("Invalid operator");
        }
    }
}

