/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;

public class BaseTableRef
extends TableRef {
    public BaseTableRef(TableRef tableRef, Path resolvedPath) {
        super(tableRef);
        Preconditions.checkState((boolean)resolvedPath.isResolved());
        Preconditions.checkState((boolean)resolvedPath.isRootedAtTable());
        this.resolvedPath_ = resolvedPath;
        if (this.hasExplicitAlias()) {
            return;
        }
        this.aliases_ = new String[]{this.getTable().getTableName().toString().toLowerCase(), this.getTable().getName().toLowerCase()};
    }

    private BaseTableRef(BaseTableRef other) {
        super(other);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed_) {
            return;
        }
        analyzer.registerAuthAndAuditEvent(this.resolvedPath_.getRootTable(), this.priv_, this.requireGrantOption_);
        this.analyzeTimeTravel(analyzer);
        this.desc_ = analyzer.registerTableRef(this);
        this.isAnalyzed_ = true;
        Analyzer.checkTableCapability(this.getTable(), Analyzer.OperationType.ANY);
        this.analyzeTableSample(analyzer);
        this.analyzeHints(analyzer);
        this.analyzeJoin(analyzer);
        this.analyzeSkipHeaderLineCount();
    }

    @Override
    protected String tableRefToSql(ToSqlOptions options) {
        String aliasSql = "";
        String alias = this.getExplicitAlias();
        if (alias != null) {
            aliasSql = " " + ToSqlUtils.getIdentSql(alias);
        }
        String timeTravelSql = "";
        if (this.timeTravelSpec_ != null) {
            timeTravelSql = " " + this.timeTravelSpec_.toSql();
        }
        String tableSampleSql = "";
        if (this.sampleParams_ != null) {
            tableSampleSql = " " + this.sampleParams_.toSql(options);
        }
        String tableHintsSql = ToSqlUtils.getPlanHintsSql(options, this.tableHints_);
        return this.getTable().getTableName().toSql() + timeTravelSql + aliasSql + tableSampleSql + tableHintsSql;
    }

    @Override
    protected TableRef clone() {
        return new BaseTableRef(this);
    }

    private void analyzeSkipHeaderLineCount() throws AnalysisException {
        FeTable table = this.getTable();
        if (!(table instanceof FeFsTable)) {
            return;
        }
        FeFsTable fsTable = (FeFsTable)table;
        StringBuilder error = new StringBuilder();
        fsTable.parseSkipHeaderLineCount(error);
        if (error.length() > 0) {
            throw new AnalysisException(error.toString());
        }
    }
}

