/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Strings;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.User;
import org.apache.impala.common.AnalysisException;

public class AuthorizationStmt
extends StatementBase {
    protected User requestingUser_;

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        AuthorizationConfig authzConfig = analyzer.getAuthzConfig();
        if (!authzConfig.isEnabled()) {
            throw new AnalysisException("Authorization is not enabled. To enable authorization restart Impala with the --server_name=<name> flag.");
        }
        if (Strings.isNullOrEmpty((String)analyzer.getUser().getName())) {
            throw new AnalysisException("Cannot execute authorization statement with an empty username.");
        }
        this.requestingUser_ = analyzer.getUser();
    }
}

