/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.Optional;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TypesUtil;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class ArithmeticExpr
extends Expr {
    private final Operator op_;
    protected Optional<Boolean> shouldConvertToCNF_ = Optional.empty();

    public Operator getOp() {
        return this.op_;
    }

    public ArithmeticExpr(Operator op, Expr e1, Expr e2) {
        this.op_ = op;
        Preconditions.checkNotNull((Object)e1);
        this.children_.add(e1);
        Preconditions.checkArgument((op.isUnary() && e2 == null || op.isBinary() && e2 != null ? 1 : 0) != 0);
        if (e2 != null) {
            this.children_.add(e2);
        }
    }

    protected ArithmeticExpr(ArithmeticExpr other) {
        super(other);
        this.op_ = other.op_;
    }

    public static void initBuiltins(Db db) {
        for (Type type : Type.getNumericTypes()) {
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.MULTIPLY.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), type));
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.ADD.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), type));
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.SUBTRACT.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), type));
        }
        db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE));
        db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{Type.DECIMAL, Type.DECIMAL}), Type.DECIMAL));
        for (Type type : Type.getIntegerTypes()) {
            db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.INT_DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), type));
        }
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("op", (Object)this.op_).addValue((Object)super.debugString()).toString();
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        if (this.children_.size() == 1) {
            if (this.op_.getPos() == OperatorPosition.UNARY_PREFIX) {
                return this.op_.toString() + ((Expr)this.getChild(0)).toSql(options);
            }
            assert (this.op_.getPos() == OperatorPosition.UNARY_POSTFIX);
            return ((Expr)this.getChild(0)).toSql(options) + this.op_.toString();
        }
        Preconditions.checkState((this.children_.size() == 2 ? 1 : 0) != 0);
        return ((Expr)this.getChild(0)).toSql(options) + " " + this.op_.toString() + " " + ((Expr)this.getChild(1)).toSql(options);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.FUNCTION_CALL;
    }

    void castChild(int childIdx, Type targetType) throws AnalysisException {
        Type t = ((Expr)this.getChild(childIdx)).getType();
        if (t.matchesType(targetType)) {
            return;
        }
        if (targetType.isDecimal() && !t.isNull()) {
            Preconditions.checkState((boolean)t.isScalarType());
            targetType = ((ScalarType)t).getMinResolutionDecimal();
        }
        this.castChild(targetType, childIdx);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        Iterator iterator = this.children_.iterator();
        while (iterator.hasNext()) {
            Expr child;
            Expr operand = child = (Expr)iterator.next();
            if (operand.type_.isNumericType() || operand.type_.isNull()) continue;
            String errMsg = "Arithmetic operation requires numeric operands: " + this.toSql();
            if (operand instanceof Subquery && !operand.type_.isScalarType()) {
                errMsg = "Subquery must return a single row: " + operand.toSql();
            }
            throw new AnalysisException(errMsg);
        }
        this.convertNumericLiteralsFromDecimal(analyzer);
        Type t0 = ((Expr)this.getChild(0)).getType();
        Type t1 = null;
        if (this.op_.isUnary()) {
            Preconditions.checkState((this.children_.size() == 1 ? 1 : 0) != 0);
        } else if (this.op_.isBinary()) {
            Preconditions.checkState((this.children_.size() == 2 ? 1 : 0) != 0);
            t1 = ((Expr)this.getChild(1)).getType();
        }
        String fnName = this.op_.getName();
        switch (this.op_) {
            case ADD: 
            case SUBTRACT: 
            case DIVIDE: 
            case MULTIPLY: 
            case MOD: {
                this.type_ = TypesUtil.getArithmeticResultType(t0, t1, this.op_, analyzer.getQueryOptions().isDecimal_v2());
                if (!this.type_.isNull()) break;
                this.type_ = Type.DOUBLE;
                break;
            }
            case INT_DIVIDE: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                if (!t0.isNull() & !t0.isIntegerType() || !t1.isNull() && !t1.isIntegerType()) {
                    throw new AnalysisException("Invalid non-integer argument to operation '" + this.op_.toString() + "': " + this.toSql());
                }
                this.type_ = Type.getAssignmentCompatibleType(t0, t1, TypeCompatibility.DEFAULT);
                if (this.type_.isNull()) {
                    this.type_ = Type.INT;
                }
                Preconditions.checkState((boolean)this.type_.isIntegerType());
                break;
            }
            case BITNOT: 
            case FACTORIAL: {
                if (!t0.isNull() && !t0.isIntegerType()) {
                    throw new AnalysisException("'" + this.op_.toString() + "' operation only allowed on integer types: " + this.toSql());
                }
                if (this.op_ == Operator.BITNOT) {
                    if (t0.isNull()) {
                        this.castChild(0, Type.INT);
                    }
                } else {
                    assert (this.op_ == Operator.FACTORIAL);
                    if (t0.isNull()) {
                        this.castChild(0, Type.BIGINT);
                    }
                }
                this.fn_ = this.getBuiltinFunction(analyzer, this.op_.getName(), this.collectChildReturnTypes(), Function.CompareMode.IS_SUPERTYPE_OF);
                Preconditions.checkNotNull((Object)this.fn_);
                this.castForFunctionCall(false, analyzer.getRegularCompatibilityLevel());
                this.type_ = this.fn_.getReturnType();
                return;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)("Unknown arithmetic operation " + this.op_.toString() + " in: " + this.toSql()));
            }
        }
        if (!this.type_.isDecimal() || !t0.isDecimal()) {
            this.castChild(0, this.type_);
        }
        if (!this.type_.isDecimal() || !t1.isDecimal()) {
            this.castChild(1, this.type_);
        }
        t0 = ((Expr)this.getChild(0)).getType();
        t1 = ((Expr)this.getChild(1)).getType();
        this.fn_ = this.getBuiltinFunction(analyzer, fnName, this.collectChildReturnTypes(), Function.CompareMode.IS_IDENTICAL);
        if (this.fn_ == null) {
            Preconditions.checkState((boolean)false, (Object)String.format("No match for '%s' with operand types %s and %s", this.toSql(), t0, t1));
        }
        Preconditions.checkState((boolean)this.type_.matchesType(this.fn_.getReturnType()));
    }

    @Override
    protected float computeEvalCost() {
        return this.hasChildCosts() ? this.getChildCosts() + 1.0f : -1.0f;
    }

    private boolean lookupShouldConvertToCNF() {
        for (int i = 0; i < this.children_.size(); ++i) {
            if (((Expr)this.getChild(i)).shouldConvertToCNF()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldConvertToCNF() {
        if (this.shouldConvertToCNF_.isPresent()) {
            return this.shouldConvertToCNF_.get();
        }
        boolean result = this.lookupShouldConvertToCNF();
        this.shouldConvertToCNF_ = Optional.of(result);
        return result;
    }

    @Override
    public Expr clone() {
        return new ArithmeticExpr(this);
    }

    public static enum Operator {
        MULTIPLY("*", "multiply", OperatorPosition.BINARY_INFIX),
        DIVIDE("/", "divide", OperatorPosition.BINARY_INFIX),
        MOD("%", "mod", OperatorPosition.BINARY_INFIX),
        INT_DIVIDE("DIV", "int_divide", OperatorPosition.BINARY_INFIX),
        ADD("+", "add", OperatorPosition.BINARY_INFIX),
        SUBTRACT("-", "subtract", OperatorPosition.BINARY_INFIX),
        BITAND("&", "bitand", OperatorPosition.BINARY_INFIX),
        BITOR("|", "bitor", OperatorPosition.BINARY_INFIX),
        BITXOR("^", "bitxor", OperatorPosition.BINARY_INFIX),
        BITNOT("~", "bitnot", OperatorPosition.UNARY_PREFIX),
        FACTORIAL("!", "factorial", OperatorPosition.UNARY_POSTFIX);

        private final String description_;
        private final String name_;
        private final OperatorPosition pos_;

        private Operator(String description, String name, OperatorPosition pos) {
            this.description_ = description;
            this.name_ = name;
            this.pos_ = pos;
        }

        public String toString() {
            return this.description_;
        }

        public String getName() {
            return this.name_;
        }

        public OperatorPosition getPos() {
            return this.pos_;
        }

        public boolean isUnary() {
            return this.pos_ == OperatorPosition.UNARY_PREFIX || this.pos_ == OperatorPosition.UNARY_POSTFIX;
        }

        public boolean isBinary() {
            return this.pos_ == OperatorPosition.BINARY_INFIX;
        }
    }

    static enum OperatorPosition {
        BINARY_INFIX,
        UNARY_PREFIX,
        UNARY_POSTFIX;

    }
}

