/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.BetweenPredicate;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.ColumnLineageGraph;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprId;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.IcebergMetadataTableRef;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.IsNotEmptyPredicate;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.SystemTableRef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TimeTravelSpec;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.authorization.PrivilegeRequestBuilder;
import org.apache.impala.authorization.TableMask;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeIncompleteTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeSystemTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.IcebergTimeTravelTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.MaterializedViewHdfsTable;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.VirtualTable;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.catalog.local.LocalKuduTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.IdGenerator;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.rewrite.BetweenToCompoundRule;
import org.apache.impala.rewrite.ConvertToCNFRule;
import org.apache.impala.rewrite.CountDistinctToNdvRule;
import org.apache.impala.rewrite.CountStarToConstRule;
import org.apache.impala.rewrite.DefaultNdvScaleRule;
import org.apache.impala.rewrite.EqualityDisjunctsToInRule;
import org.apache.impala.rewrite.ExprRewriteRule;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.rewrite.ExtractCommonConjunctRule;
import org.apache.impala.rewrite.ExtractCompoundVerticalBarExprRule;
import org.apache.impala.rewrite.FoldConstantsRule;
import org.apache.impala.rewrite.NormalizeBinaryPredicatesRule;
import org.apache.impala.rewrite.NormalizeCountStarRule;
import org.apache.impala.rewrite.NormalizeExprsRule;
import org.apache.impala.rewrite.SimplifyCastExprRule;
import org.apache.impala.rewrite.SimplifyCastStringToTimestamp;
import org.apache.impala.rewrite.SimplifyConditionalsRule;
import org.apache.impala.rewrite.SimplifyDistinctFromRule;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TImpalaQueryOptions;
import org.apache.impala.thrift.TLineageGraph;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.DisjointSet;
import org.apache.impala.util.ExecutorMembershipSnapshot;
import org.apache.impala.util.Graph;
import org.apache.impala.util.IntIterator;
import org.apache.impala.util.KuduUtil;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.impala.util.TSessionStateUtil;
import org.apache.kudu.client.KuduClient;
import org.github.jamm.CannotAccessFieldException;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyzer {
    public static final byte ACCESSTYPE_READ = 2;
    public static final byte ACCESSTYPE_WRITE = 4;
    public static final byte ACCESSTYPE_READWRITE = 8;
    public static final String DB_DOES_NOT_EXIST_ERROR_MSG = "Database does not exist: ";
    public static final String DB_ALREADY_EXISTS_ERROR_MSG = "Database already exists: ";
    public static final String TBL_DOES_NOT_EXIST_ERROR_MSG = "Table does not exist: ";
    public static final String TBL_ALREADY_EXISTS_ERROR_MSG = "Table already exists: ";
    public static final String VIEW_ALREADY_EXISTS_ERROR_MSG = "View already exists: ";
    public static final String FN_DOES_NOT_EXIST_ERROR_MSG = "Function does not exist: ";
    public static final String FN_ALREADY_EXISTS_ERROR_MSG = "Function already exists: ";
    public static final String DATA_SRC_DOES_NOT_EXIST_ERROR_MSG = "Data source does not exist: ";
    public static final String DATA_SRC_ALREADY_EXISTS_ERROR_MSG = "Data source already exists: ";
    private static final String TRANSACTIONAL_TABLE_NOT_SUPPORTED = "%s not supported on transactional (ACID) table: %s";
    private static final String FULL_TRANSACTIONAL_TABLE_NOT_SUPPORTED = "%s not supported on full transactional (ACID) table: %s";
    private static final String BUCKETED_TABLE_NOT_SUPPORTED = "%s is a bucketed table. Only read operations are supported on such tables.";
    private static final String TABLE_NOT_SUPPORTED = "%s not supported. Table %s  access type is: %s";
    private static final Logger LOG = LoggerFactory.getLogger(Analyzer.class);
    private final User user_;
    private boolean isStraightJoin_ = false;
    private boolean useHiveColLabels_ = false;
    private boolean hasLimitOffsetClause_ = false;
    private int callDepth_ = 0;
    private boolean isSubquery_ = false;
    private Pair<Boolean, Long> simpleLimitStatus_ = null;
    private boolean hasWithClause_ = false;
    private String authErrorMsg_;
    private boolean maskPrivChecks_ = false;
    private boolean enablePrivChecks_ = true;
    private TupleId visibleSemiJoinedTupleId_ = null;
    private String mvAuthExceptionMsg_ = null;
    private long totalRecordsNumV1_;
    private long totalRecordsNumV2_;
    private Deque<TupleDescriptor> tupleStack_ = new ArrayDeque<TupleDescriptor>();
    private final GlobalState globalState_;
    private final List<Analyzer> ancestors_;
    private final Map<String, FeView> localViews_ = new HashMap<String, FeView>();
    private final Map<String, TupleDescriptor> aliasMap_ = new HashMap<String, TupleDescriptor>();
    private final Map<TupleId, TableRef> tableRefMap_ = new HashMap<TupleId, TableRef>();
    private final Set<CollectionTableRef> tableRefsFromUnnestExpr_ = new HashSet<CollectionTableRef>();
    private final Set<String> ambiguousAliases_ = new HashSet<String>();
    private final Map<List<String>, SlotDescriptor> slotPathMap_ = new HashMap<List<String>, SlotDescriptor>();
    private boolean hasEmptyResultSet_ = false;
    private boolean hasEmptySpjResultSet_ = false;
    private final SlotRef.Comparator VALUE_TRANSFER_SLOTREF_CMP = new SlotRef.Comparator(){

        @Override
        public boolean matches(SlotRef a, SlotRef b) {
            return Analyzer.this.hasValueTransfer(a.getSlotId(), b.getSlotId());
        }
    };
    private final SlotRef.Comparator MUTUAL_VALUE_TRANSFER_SLOTREF_CMP = new SlotRef.Comparator(){

        @Override
        public boolean matches(SlotRef a, SlotRef b) {
            return Analyzer.this.hasMutualValueTransfer(a.getSlotId(), b.getSlotId());
        }
    };

    public void setIsSubquery() {
        this.isSubquery_ = true;
        this.globalState_.containsSubquery = true;
    }

    public void setSimpleLimitStatus(Pair<Boolean, Long> simpleLimitStatus) {
        this.simpleLimitStatus_ = simpleLimitStatus;
    }

    public Pair<Boolean, Long> getSimpleLimitStatus() {
        return this.simpleLimitStatus_;
    }

    public void setHasTopLevelAcidCollectionTableRef() {
        this.globalState_.hasTopLevelAcidCollectionTableRef = true;
    }

    public boolean hasTopLevelAcidCollectionTableRef() {
        return this.globalState_.hasTopLevelAcidCollectionTableRef;
    }

    public boolean setHasPlanHints() {
        this.globalState_.hasPlanHints = true;
        return true;
    }

    public boolean hasPlanHints() {
        return this.globalState_.hasPlanHints;
    }

    public void setHasWithClause() {
        this.hasWithClause_ = true;
    }

    public boolean hasWithClause() {
        return this.hasWithClause_;
    }

    public void setSetOpNeedsRewrite() {
        this.globalState_.setOperationNeedsRewrite = true;
    }

    public static void ensureTableNotFullAcid(FeTable table, String operationStr) throws AnalysisException {
        if (AcidUtils.isFullAcidTable(table.getMetaStoreTable().getParameters())) {
            throw new AnalysisException(String.format(FULL_TRANSACTIONAL_TABLE_NOT_SUPPORTED, operationStr, table.getFullName()));
        }
    }

    public static void ensureTableNotTransactional(FeTable table, String operationStr) throws AnalysisException {
        if (AcidUtils.isTransactionalTable(table.getMetaStoreTable().getParameters())) {
            throw new AnalysisException(String.format(TRANSACTIONAL_TABLE_NOT_SUPPORTED, operationStr, table.getFullName()));
        }
    }

    public static void ensureTableNotBucketed(FeTable table) throws AnalysisException {
        if (MetaStoreUtil.isBucketedTable(table.getMetaStoreTable())) {
            throw new AnalysisException(String.format(BUCKETED_TABLE_NOT_SUPPORTED, table.getFullName()));
        }
    }

    public static void checkTableCapability(FeTable table, OperationType type) throws AnalysisException {
        switch (type) {
            case WRITE: {
                Analyzer.ensureTableWriteSupported(table);
                break;
            }
            default: {
                Analyzer.ensureTableSupported(table);
            }
        }
    }

    private static void ensureTableWriteSupported(FeTable table) throws AnalysisException {
        Analyzer.ensureTableNotBucketed(table);
        if (MetastoreShim.getMajorVersion() > 2L) {
            byte writeRequires = 12;
            if (KuduTable.isKuduTable(table.getMetaStoreTable())) {
                return;
            }
            if (!MetastoreShim.hasTableCapability(table.getMetaStoreTable(), writeRequires)) {
                throw new AnalysisException(String.format(TABLE_NOT_SUPPORTED, "Write", table.getFullName(), MetastoreShim.getTableAccessType(table.getMetaStoreTable())));
            }
        } else {
            Analyzer.ensureTableNotTransactional(table, "Write");
        }
    }

    private static void ensureTableSupported(FeTable table) throws AnalysisException {
        if (MetastoreShim.getMajorVersion() > 2L) {
            byte capabilities = 14;
            if (!MetastoreShim.hasTableCapability(table.getMetaStoreTable(), capabilities)) {
                throw new AnalysisException(String.format(TABLE_NOT_SUPPORTED, "Operations", table.getFullName(), MetastoreShim.getTableAccessType(table.getMetaStoreTable())));
            }
        } else {
            Analyzer.ensureTableNotTransactional(table, "Operation");
        }
    }

    public boolean containsSubquery() {
        return this.globalState_.containsSubquery;
    }

    public boolean containsSetOperation() {
        return this.globalState_.setOperationNeedsRewrite;
    }

    public int numExecutorsForPlanning() {
        return this.globalState_.numExecutorsForPlanning_ >= 0 ? this.globalState_.numExecutorsForPlanning_ : ExecutorMembershipSnapshot.getCluster().numExecutors();
    }

    public void setNumExecutorsForPlanning(int x) {
        this.globalState_.numExecutorsForPlanning_ = x;
    }

    public int getAvailableCoresPerNode() {
        Preconditions.checkState((this.globalState_.availableCoresPerNode_ > 0 ? 1 : 0) != 0);
        return this.globalState_.availableCoresPerNode_;
    }

    public void setAvailableCoresPerNode(int x) {
        Preconditions.checkArgument((x > 0 ? 1 : 0) != 0);
        this.globalState_.availableCoresPerNode_ = Math.min(128, x);
    }

    public int getMinParallelismPerNode() {
        if (this.getQueryOptions().isCompute_processing_cost()) {
            return this.getQueryOptions().getProcessing_cost_min_threads();
        }
        return 1;
    }

    public int getMaxParallelismPerNode() {
        if (this.getQueryOptions().isCompute_processing_cost()) {
            return Math.max(this.getMinParallelismPerNode(), Math.min(this.getQueryOptions().getMax_fragment_instances_per_node(), this.getAvailableCoresPerNode()));
        }
        if (this.getQueryOptions().getMt_dop() > 0) {
            return this.getQueryOptions().getMt_dop();
        }
        return 1;
    }

    public boolean includeAllCoordinatorsInScheduling() {
        return this.globalState_.includeAllCoordinatorsInScheduling;
    }

    public void setIncludeAllCoordinatorsInScheduling(boolean flag) {
        this.globalState_.includeAllCoordinatorsInScheduling = flag;
    }

    public Analyzer(StmtMetadataLoader.StmtTableCache stmtTableCache, TQueryCtx queryCtx, AuthorizationFactory authzFactory, AuthorizationContext authzCtx) {
        this.ancestors_ = new ArrayList<Analyzer>();
        this.globalState_ = new GlobalState(stmtTableCache, queryCtx, authzFactory, authzCtx);
        this.user_ = new User(TSessionStateUtil.getEffectiveUser(queryCtx.session));
    }

    public Analyzer(Analyzer parentAnalyzer) {
        this(parentAnalyzer, parentAnalyzer.globalState_);
    }

    private Analyzer(Analyzer parentAnalyzer, GlobalState globalState) {
        this.ancestors_ = Lists.newArrayList((Object[])new Analyzer[]{parentAnalyzer});
        this.ancestors_.addAll(parentAnalyzer.ancestors_);
        this.globalState_ = globalState;
        this.user_ = parentAnalyzer.getUser();
        this.useHiveColLabels_ = parentAnalyzer.useHiveColLabels_;
        this.authErrorMsg_ = parentAnalyzer.authErrorMsg_;
        this.maskPrivChecks_ = parentAnalyzer.maskPrivChecks_;
        this.enablePrivChecks_ = parentAnalyzer.enablePrivChecks_;
        this.hasWithClause_ = parentAnalyzer.hasWithClause_;
    }

    public static Analyzer createWithNewGlobalState(Analyzer parentAnalyzer) {
        GlobalState globalState = new GlobalState(parentAnalyzer.globalState_.stmtTableCache, parentAnalyzer.getQueryCtx(), parentAnalyzer.getAuthzFactory(), parentAnalyzer.getAuthzCtx());
        return new Analyzer(parentAnalyzer, globalState);
    }

    public void setVisibleSemiJoinedTuple(TupleId tid) {
        Preconditions.checkState((tid == null || this.globalState_.semiJoinedTupleIds.containsKey(tid) ? 1 : 0) != 0);
        Preconditions.checkState((tid == null || this.visibleSemiJoinedTupleId_ == null ? 1 : 0) != 0);
        this.visibleSemiJoinedTupleId_ = tid;
    }

    public boolean hasAncestors() {
        return !this.ancestors_.isEmpty();
    }

    public Analyzer getParentAnalyzer() {
        return this.hasAncestors() ? this.ancestors_.get(0) : null;
    }

    public Analyzer findAnalyzer(TupleId tid) {
        if (this.tableRefMap_.containsKey(tid)) {
            return this;
        }
        if (this.hasAncestors()) {
            return this.getParentAnalyzer().findAnalyzer(tid);
        }
        return null;
    }

    public List<String> getWarnings() {
        this.globalState_.warningsRetrieved = true;
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Integer> e : this.globalState_.warnings.entrySet()) {
            String error = e.getKey();
            int count = e.getValue();
            Preconditions.checkState((count > 0 ? 1 : 0) != 0);
            if (count == 1) {
                result.add(error);
                continue;
            }
            result.add(error + " (" + count + " warnings like this)");
        }
        return result;
    }

    public void registerLocalView(FeView view) throws AnalysisException {
        Preconditions.checkState((boolean)view.isLocalView());
        if (view.getColLabels() != null) {
            List<String> viewLabels = view.getColLabels();
            List<String> queryStmtLabels = view.getQueryStmt().getColLabels();
            if (viewLabels.size() > queryStmtLabels.size()) {
                throw new AnalysisException("WITH-clause view '" + view.getName() + "' returns " + queryStmtLabels.size() + " columns, but " + viewLabels.size() + " labels were specified. The number of column labels must be smaller or equal to the number of returned columns.");
            }
        }
        if (this.localViews_.put(view.getName().toLowerCase(), view) != null) {
            throw new AnalysisException(String.format("Duplicate table alias: '%s'", view.getName()));
        }
    }

    public TableRef getRegisteredTableRef(String uniqueAlias) {
        if (uniqueAlias == null) {
            return null;
        }
        TupleDescriptor tupleDesc = this.aliasMap_.get(uniqueAlias);
        if (tupleDesc == null) {
            return null;
        }
        return this.tableRefMap_.get(tupleDesc.getId());
    }

    public TupleDescriptor registerTableRef(TableRef ref) throws AnalysisException {
        TupleDescriptor tupleDesc;
        String uniqueAlias = ref.getUniqueAlias();
        if (this.aliasMap_.containsKey(uniqueAlias)) {
            throw new AnalysisException("Duplicate table alias: '" + uniqueAlias + "'");
        }
        String unqualifiedAlias = null;
        String[] aliases = ref.getAliases();
        if (aliases.length > 1 && (tupleDesc = this.aliasMap_.get(unqualifiedAlias = aliases[1])) != null) {
            if (tupleDesc.hasExplicitAlias()) {
                throw new AnalysisException("Duplicate table alias: '" + unqualifiedAlias + "'");
            }
            this.ambiguousAliases_.add(unqualifiedAlias);
        }
        TupleDescriptor result = ref.createTupleDescriptor(this);
        result.setAliases(aliases, ref.hasExplicitAlias());
        for (String alias : aliases) {
            this.aliasMap_.put(alias, result);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Register aliases {} to tuple {}", (Object)aliases, (Object)result.debugString());
        }
        this.tableRefMap_.put(result.getId(), ref);
        return result;
    }

    public void addCollectionTableRef(String alias, CollectionTableRef ref, TupleDescriptor desc) {
        this.aliasMap_.put(alias, desc);
        this.tableRefMap_.put(desc.getId(), ref);
    }

    public void addAlias(String alias, TupleDescriptor desc) {
        this.aliasMap_.put(alias, desc);
    }

    public TableRef resolveTableRef(TableRef tableRef) throws AnalysisException {
        if (tableRef.isResolved()) {
            return tableRef;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resolving TableRef {}", (Object)ToSqlUtils.getPathSql(tableRef.getPath()));
        }
        if (tableRef.getPath().size() == 1) {
            String viewAlias = tableRef.getPath().get(0).toLowerCase();
            Analyzer analyzer = this;
            do {
                FeView localView;
                if ((localView = analyzer.localViews_.get(viewAlias)) == null) continue;
                return new InlineViewRef(localView, tableRef);
            } while ((analyzer = analyzer.ancestors_.isEmpty() ? null : analyzer.ancestors_.get(0)) != null);
        }
        List<String> rawPath = tableRef.getPath();
        Path resolvedPath = null;
        try {
            resolvedPath = this.resolvePathWithMasking(rawPath, Path.PathType.TABLE_REF, tableRef.timeTravelSpec_);
        }
        catch (AnalysisException e) {
            this.registerPrivReqOnRawPath(tableRef, rawPath);
            throw e;
        }
        catch (TableLoadingException e) {
            throw new AnalysisException(String.format("Failed to load metadata for table: '%s'", Joiner.on((String)".").join(rawPath)), e);
        }
        Preconditions.checkNotNull((Object)resolvedPath);
        if (resolvedPath.destTable() != null) {
            FeTable table = resolvedPath.destTable();
            if (table instanceof FeView) {
                return new InlineViewRef((FeView)table, tableRef);
            }
            if (table instanceof IcebergMetadataTable) {
                return new IcebergMetadataTableRef(tableRef, resolvedPath);
            }
            if (table instanceof FeSystemTable) {
                return new SystemTableRef(tableRef, resolvedPath);
            }
            Preconditions.checkState((table instanceof FeFsTable || table instanceof FeKuduTable || table instanceof FeHBaseTable || table instanceof FeDataSourceTable ? 1 : 0) != 0);
            return new BaseTableRef(tableRef, resolvedPath);
        }
        return new CollectionTableRef(tableRef, resolvedPath, false);
    }

    private void registerPrivReqOnRawPath(TableRef tableRef, List<String> tableRawPath) {
        if (tableRawPath.size() > 1) {
            this.registerPrivReq((PrivilegeRequestBuilder builder) -> {
                builder.onTableUnknownOwner((String)tableRawPath.get(0), (String)tableRawPath.get(1)).allOf(tableRef.getPrivilege());
                if (tableRef.requireGrantOption()) {
                    builder.grantOption();
                }
                return builder.build();
            });
        } else {
            this.registerPrivReq((PrivilegeRequestBuilder builder) -> {
                builder.onTableUnknownOwner(this.getDefaultDb(), (String)tableRawPath.get(0)).allOf(tableRef.getPrivilege());
                if (tableRef.requireGrantOption()) {
                    builder.grantOption();
                }
                return builder.build();
            });
        }
    }

    public TableRef resolveTableMask(TableRef resolvedTableRef) throws AnalysisException {
        String tblName;
        String dbName;
        Preconditions.checkState((boolean)resolvedTableRef.isResolved(), (Object)"Table should be resolved");
        if (!this.getAuthzFactory().getAuthorizationConfig().isEnabled() || !this.getAuthzFactory().supportsTableMasking()) {
            return resolvedTableRef;
        }
        AuthorizationChecker authChecker = this.getAuthzFactory().newAuthorizationChecker(this.getCatalog().getAuthPolicy());
        if (resolvedTableRef instanceof InlineViewRef) {
            FeView view = ((InlineViewRef)resolvedTableRef).getView();
            dbName = view.getDb().getName();
            tblName = view.getName();
        } else {
            if (resolvedTableRef instanceof CollectionTableRef && resolvedTableRef.isRelative()) {
                return resolvedTableRef;
            }
            dbName = resolvedTableRef.getTable().getDb().getName();
            tblName = resolvedTableRef.getTable().getName();
        }
        List<Column> columns = resolvedTableRef.getSelectedColumnsInHiveOrder();
        TableMask tableMask = new TableMask(authChecker, dbName, tblName, columns, this.user_);
        try {
            if (resolvedTableRef instanceof CollectionTableRef) {
                if (tableMask.needsRowFiltering()) {
                    throw new AnalysisException(String.format("Using non-relative collection column %s of table %s.%s is not supported since there are row-filtering policies on this table (IMPALA-10484). Rewrite query to use relative reference.", String.join((CharSequence)".", resolvedTableRef.getResolvedPath().getRawPath()), dbName, tblName));
                }
            } else if (!(resolvedTableRef instanceof InlineViewRef) && resolvedTableRef.getTable() instanceof MaterializedViewHdfsTable && ((MaterializedViewHdfsTable)resolvedTableRef.getTable()).isReferencesMaskedTables(authChecker, this.getCatalog(), this.getUser())) {
                this.mvAuthExceptionMsg_ = String.format("Materialized view %s.%s references tables with column masking or row filtering policies.", dbName, tblName);
            } else if (tableMask.needsMaskingOrFiltering()) {
                return InlineViewRef.createTableMaskView(resolvedTableRef, tableMask, this.getAuthzCtx());
            }
            return resolvedTableRef;
        }
        catch (InternalException e) {
            String msg = "Error resolving table mask on " + dbName + "." + tblName;
            LOG.error(msg, (Throwable)e);
            throw new AnalysisException(msg, e);
        }
    }

    public boolean encounteredMVAuthException() {
        return this.mvAuthExceptionMsg_ != null;
    }

    public String getMVAuthExceptionMsg() {
        return this.mvAuthExceptionMsg_;
    }

    public void setTotalRecordsNumV1(long totalRecordsNumV1) {
        this.totalRecordsNumV1_ = totalRecordsNumV1;
    }

    public long getTotalRecordsNumV1() {
        return this.totalRecordsNumV1_;
    }

    public void setTotalRecordsNumV2(long totalRecordsNumV2) {
        this.totalRecordsNumV2_ = totalRecordsNumV2;
    }

    public long getTotalRecordsNumV2() {
        return this.totalRecordsNumV2_;
    }

    public boolean canRewriteCountStarForV1() {
        return this.totalRecordsNumV1_ > 0L;
    }

    public boolean canRewriteCountStartForV2() {
        return this.totalRecordsNumV2_ > 0L;
    }

    public void registerFullOuterJoinedConjunct(Expr e) {
        Preconditions.checkState((!this.globalState_.fullOuterJoinedConjuncts.containsKey(e.getId()) ? 1 : 0) != 0);
        ArrayList<TupleId> tids = new ArrayList<TupleId>();
        e.getIds(tids, null);
        for (TupleId tid : tids) {
            if (!this.globalState_.fullOuterJoinedTupleIds.containsKey(tid)) continue;
            TableRef currentOuterJoin = this.globalState_.fullOuterJoinedTupleIds.get(tid);
            this.globalState_.fullOuterJoinedConjuncts.put(e.getId(), currentOuterJoin);
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("registerFullOuterJoinedConjunct: " + this.globalState_.fullOuterJoinedConjuncts.toString());
        }
    }

    public void registerFullOuterJoinedTids(List<TupleId> tids, TableRef rhsRef) {
        for (TupleId tid : tids) {
            this.globalState_.fullOuterJoinedTupleIds.put(tid, rhsRef);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("registerFullOuterJoinedTids: " + this.globalState_.fullOuterJoinedTupleIds.toString());
        }
    }

    public void registerOuterJoinedTids(List<TupleId> tids, TableRef rhsRef) {
        for (TupleId tid : tids) {
            this.globalState_.outerJoinedTupleIds.put(tid, rhsRef);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("registerOuterJoinedTids: " + this.globalState_.outerJoinedTupleIds.toString());
        }
    }

    public void registerSemiJoinedTid(TupleId tid, TableRef rhsRef) {
        this.globalState_.semiJoinedTupleIds.put(tid, rhsRef);
    }

    public void addZippingUnnestTupleId(CollectionTableRef tblRef) {
        Expr collExpr = tblRef.getCollectionExpr();
        this.addZippingUnnestTupleId(collExpr);
    }

    public void addZippingUnnestTupleId(Expr collExpr) {
        if (collExpr == null) {
            return;
        }
        if (!(collExpr instanceof SlotRef)) {
            return;
        }
        SlotRef slotCollExpr = (SlotRef)collExpr;
        SlotDescriptor collSlotDesc = slotCollExpr.getDesc();
        Preconditions.checkNotNull((Object)collSlotDesc);
        TupleDescriptor collTupleDesc = collSlotDesc.getItemTupleDesc();
        Preconditions.checkNotNull((Object)collTupleDesc);
        this.globalState_.zippingUnnestTupleIds.add(collTupleDesc.getId());
    }

    public void addZippingUnnestTupleId(TupleId tid) {
        this.globalState_.zippingUnnestTupleIds.add(tid);
    }

    public Set<TupleId> getZippingUnnestTupleIds() {
        return this.globalState_.zippingUnnestTupleIds;
    }

    public void increaseZippingUnnestCount() {
        ++this.globalState_.numZippingUnnests;
    }

    public int getNumZippingUnnests() {
        return this.globalState_.numZippingUnnests;
    }

    public TupleDescriptor getDescriptor(String tableAlias) throws AnalysisException {
        String lookupAlias = tableAlias.toLowerCase();
        if (this.ambiguousAliases_.contains(lookupAlias)) {
            throw new AnalysisException(String.format("Unqualified table alias is ambiguous: '%s'", tableAlias));
        }
        return this.aliasMap_.get(lookupAlias);
    }

    public TupleDescriptor getTupleDesc(TupleId id) {
        return this.globalState_.descTbl.getTupleDesc(id);
    }

    public SlotDescriptor getSlotDesc(SlotId id) {
        return this.globalState_.descTbl.getSlotDesc(id);
    }

    public List<SlotDescriptor> getSlotDescs(List<SlotId> ids) {
        ArrayList<SlotDescriptor> result = new ArrayList<SlotDescriptor>(ids.size());
        for (SlotId id : ids) {
            result.add(this.getSlotDesc(id));
        }
        return result;
    }

    public int getNumTableRefs() {
        return this.tableRefMap_.size();
    }

    public TableRef getTableRef(TupleId tid) {
        return this.tableRefMap_.get(tid);
    }

    public Map<TupleId, TableRef> getTableRefs() {
        return this.tableRefMap_;
    }

    public ExprRewriter getConstantFolder() {
        return this.globalState_.constantFolder_;
    }

    public ExprRewriter getExprRewriter() {
        return this.globalState_.exprRewriter_;
    }

    public Set<CollectionTableRef> getTableRefsFromUnnestExpr() {
        return this.tableRefsFromUnnestExpr_;
    }

    public void addTableRefFromUnnestExpr(CollectionTableRef ref) {
        this.tableRefsFromUnnestExpr_.add(ref);
    }

    public SlotDescriptor getSlotDescriptor(List<String> qualifiedColumnName) {
        return this.slotPathMap_.get(qualifiedColumnName);
    }

    public boolean isRootAnalyzer() {
        return this.ancestors_.isEmpty();
    }

    public boolean hasEmptyResultSet() {
        return this.hasEmptyResultSet_;
    }

    public void setHasEmptyResultSet() {
        this.hasEmptyResultSet_ = true;
    }

    public boolean hasEmptySpjResultSet() {
        return this.hasEmptySpjResultSet_;
    }

    public Path resolvePathWithMasking(List<String> rawPath, Path.PathType pathType) throws AnalysisException, TableLoadingException {
        return this.resolvePathWithMasking(rawPath, pathType, null);
    }

    public Path resolvePathWithMasking(List<String> rawPath, Path.PathType pathType, TimeTravelSpec timeTravelSpec) throws AnalysisException, TableLoadingException {
        Path resolvedPath = this.resolvePath(rawPath, pathType, timeTravelSpec);
        if (pathType == Path.PathType.TABLE_REF) {
            if (resolvedPath.destTable() != null || !resolvedPath.isRootedAtTuple()) {
                return resolvedPath;
            }
        } else if (pathType == Path.PathType.SLOT_REF) {
            if (!resolvedPath.getMatchedTypes().get(0).isStructType()) {
                return resolvedPath;
            }
        } else if (pathType == Path.PathType.STAR) {
            if (resolvedPath.getMatchedTypes().isEmpty()) {
                return resolvedPath;
            }
            Preconditions.checkState((boolean)resolvedPath.destType().isStructType());
        }
        TupleId rootTupleId = resolvedPath.getRootDesc().getId();
        Analyzer parentAnalyzer = this.findAnalyzer(rootTupleId);
        TableRef rootTblRef = parentAnalyzer.getTableRef(rootTupleId);
        Preconditions.checkNotNull((Object)rootTblRef);
        if (!rootTblRef.isTableMaskingView()) {
            return resolvedPath;
        }
        InlineViewRef tableMaskingView = (InlineViewRef)rootTblRef;
        Preconditions.checkState((boolean)(tableMaskingView.getUnMaskedTableRef() instanceof BaseTableRef));
        Path maskedPath = tableMaskingView.inlineViewAnalyzer_.resolvePath(rawPath, pathType, timeTravelSpec);
        maskedPath.setPathBeforeMasking(resolvedPath);
        return maskedPath;
    }

    public Path resolvePath(List<String> rawPath, Path.PathType pathType) throws AnalysisException, TableLoadingException {
        return this.resolvePath(rawPath, pathType, null);
    }

    public Path resolvePath(List<String> rawPath, Path.PathType pathType, TimeTravelSpec timeTravelSpec) throws AnalysisException, TableLoadingException {
        boolean resolveInAncestors = false;
        if (pathType == Path.PathType.TABLE_REF || pathType == Path.PathType.ANY) {
            resolveInAncestors = true;
        } else if (pathType == Path.PathType.SLOT_REF) {
            resolveInAncestors = this.isSubquery_;
        }
        ArrayList lcRawPath = Lists.newArrayListWithCapacity((int)rawPath.size());
        for (String s : rawPath) {
            lcRawPath.add(s.toLowerCase());
        }
        return this.resolvePath(lcRawPath, pathType, resolveInAncestors, timeTravelSpec);
    }

    private Path resolvePath(List<String> rawPath, Path.PathType pathType, boolean resolveInAncestors, TimeTravelSpec timeTravelSpec) throws AnalysisException, TableLoadingException {
        Path result;
        List<Path> candidates = this.getTupleDescPaths(rawPath);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Candidates for {} {}: {}", new Object[]{pathType, ToSqlUtils.getPathSql(rawPath), candidates});
        }
        LinkedList errors = Lists.newLinkedList();
        if (pathType == Path.PathType.SLOT_REF || pathType == Path.PathType.STAR) {
            for (TableRef tblRef : this.tableRefMap_.values()) {
                if (tblRef.isHidden()) continue;
                candidates.add(new Path(tblRef.getDesc(), rawPath));
            }
        } else {
            Preconditions.checkState((pathType == Path.PathType.TABLE_REF || pathType == Path.PathType.ANY ? 1 : 0) != 0);
            result = this.resolvePaths(rawPath, candidates, pathType, errors);
            if (result != null) {
                return result;
            }
            candidates.clear();
            List<TableName> candidateTbls = Path.getCandidateTables(rawPath, this.getDefaultDb());
            for (int tblNameIdx = 0; tblNameIdx < candidateTbls.size(); ++tblNameIdx) {
                TableName tblName = candidateTbls.get(tblNameIdx);
                FeTable tbl = null;
                try {
                    tbl = this.getTable(tblName, false);
                }
                catch (AnalysisException analysisException) {
                    // empty catch block
                }
                if (tbl == null) continue;
                if (timeTravelSpec != null) {
                    if (!(tbl instanceof FeIcebergTable)) {
                        throw new AnalysisException(String.format("FOR %s AS OF clause is only supported for Iceberg tables. %s is not an Iceberg table.", timeTravelSpec.getKind() == TimeTravelSpec.Kind.TIME_AS_OF ? "SYSTEM_TIME" : "SYSTEM_VERSION", tbl.getFullName()));
                    }
                    timeTravelSpec.analyze(this);
                    FeIcebergTable rootTable = (FeIcebergTable)tbl;
                    tbl = new IcebergTimeTravelTable(rootTable, timeTravelSpec);
                }
                int offset = tblNameIdx + (tbl instanceof IcebergMetadataTable ? 2 : 1);
                candidates.add(new Path(tbl, rawPath.subList(offset, rawPath.size())));
            }
            LOG.trace("Replace candidates with {}", candidates);
        }
        result = this.resolvePaths(rawPath, candidates, pathType, errors);
        if (result == null && resolveInAncestors && this.hasAncestors()) {
            LOG.trace("Resolve in ancestors");
            result = this.getParentAnalyzer().resolvePath(rawPath, pathType, true, timeTravelSpec);
        }
        if (result == null) {
            Preconditions.checkState((!errors.isEmpty() ? 1 : 0) != 0);
            throw new AnalysisException((String)errors.getFirst());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resolved {} {} to {}", new Object[]{pathType, ToSqlUtils.getPathSql(rawPath), result.debugString()});
        }
        return result;
    }

    public List<Path> getTupleDescPaths(List<String> rawPath) throws AnalysisException {
        ArrayList<Path> result = new ArrayList<Path>();
        TupleDescriptor rootDesc = this.getDescriptor(rawPath.get(0));
        if (rootDesc != null && !rootDesc.isHidden()) {
            result.add(new Path(rootDesc, rawPath.subList(1, rawPath.size())));
        }
        if (rawPath.size() > 1 && (rootDesc = this.getDescriptor(rawPath.get(0) + "." + rawPath.get(1))) != null && !rootDesc.isHidden()) {
            result.add(new Path(rootDesc, rawPath.subList(2, rawPath.size())));
        }
        return result;
    }

    private Path resolvePaths(List<String> rawPath, List<Path> paths, Path.PathType pathType, LinkedList<String> errors) {
        String pathTypeStr = null;
        String pathStr = Joiner.on((String)".").join(rawPath);
        if (pathType == Path.PathType.SLOT_REF) {
            pathTypeStr = "Column/field reference";
        } else if (pathType == Path.PathType.TABLE_REF) {
            pathTypeStr = "Table reference";
        } else if (pathType == Path.PathType.ANY) {
            pathTypeStr = "Path";
        } else {
            Preconditions.checkState((pathType == Path.PathType.STAR ? 1 : 0) != 0);
            pathTypeStr = "Star expression";
            pathStr = pathStr + ".*";
        }
        ArrayList<Path> legalPaths = new ArrayList<Path>();
        block5: for (Path p : paths) {
            if (!p.resolve()) {
                LOG.trace("Can't resolve path {}", (Object)p);
                continue;
            }
            if (p.isRootedAtTuple() && !this.isVisible(p.getRootDesc().getId())) {
                errors.addLast(String.format("Illegal %s '%s' of semi-/anti-joined table '%s'", pathTypeStr.toLowerCase(), pathStr, p.getRootDesc().getAlias()));
                continue;
            }
            switch (pathType) {
                case TABLE_REF: {
                    if (p.destType().isCollectionType()) break;
                    errors.addFirst(String.format("Illegal table reference to non-collection type: '%s'\nPath resolved to type: %s", pathStr, p.destType().toSql()));
                    continue block5;
                }
                case SLOT_REF: {
                    if (p.hasNonDestCollection()) {
                        errors.addFirst(String.format("Illegal column/field reference '%s' with intermediate collection '%s' of type '%s'", pathStr, p.getFirstCollectionName(), p.getFirstCollectionType().toSql()));
                        continue block5;
                    }
                    if (!p.getMatchedTypes().isEmpty()) break;
                    continue block5;
                }
                case STAR: {
                    if (p.hasNonDestCollection()) {
                        errors.addFirst(String.format("Illegal star expression '%s' with intermediate collection '%s' of type '%s'", pathStr, p.getFirstCollectionName(), p.getFirstCollectionType().toSql()));
                        continue block5;
                    }
                    if (p.destType().isStructType()) break;
                    errors.addFirst(String.format("Cannot expand star in '%s' because path '%s' resolved to type '%s'.\nStar expansion is only valid for paths to a struct type.", pathStr, Joiner.on((String)".").join(rawPath), p.destType().toSql()));
                    continue block5;
                }
            }
            legalPaths.add(p);
        }
        if (legalPaths.size() > 1) {
            errors.addFirst(String.format("%s is ambiguous: '%s'", pathTypeStr, pathStr));
            return null;
        }
        if (legalPaths.isEmpty()) {
            if (errors.isEmpty()) {
                errors.addFirst(String.format("Could not resolve %s: '%s'", pathTypeStr.toLowerCase(), pathStr));
            }
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Legal candidate: {}", legalPaths.get(0));
        }
        return (Path)legalPaths.get(0);
    }

    public SlotDescriptor registerSlotRef(Path slotPath) throws AnalysisException {
        return this.registerSlotRef(slotPath, true);
    }

    public SlotDescriptor registerSlotRef(Path slotPath, boolean duplicateIfCollections) throws AnalysisException {
        Preconditions.checkState((boolean)slotPath.isRootedAtTuple());
        try (TupleStackGuard guard = this.tupleStack_.isEmpty() ? new TupleStackGuard(slotPath.getRootDesc()) : null;){
            if (slotPath.destType().isCollectionType() && duplicateIfCollections) {
                SlotDescriptor res = this.createAndRegisterRawSlotDesc(slotPath, false);
                this.globalState_.duplicateCollectionSlots.add(res.getId());
                SlotDescriptor slotDescriptor = res;
                return slotDescriptor;
            }
            List<String> key = slotPath.getFullyQualifiedRawPath();
            Preconditions.checkState((boolean)key.stream().allMatch(s -> s.equals(s.toLowerCase())), (Object)("Slot paths should be lower case: " + key));
            SlotDescriptor existingSlotDesc = this.slotPathMap_.get(key);
            if (existingSlotDesc != null) {
                SlotDescriptor slotDescriptor = existingSlotDesc;
                return slotDescriptor;
            }
            SlotDescriptor existingInTuple = this.findPathInCurrentTuple(slotPath);
            if (existingInTuple != null) {
                SlotDescriptor slotDescriptor = existingInTuple;
                return slotDescriptor;
            }
            SlotDescriptor slotDescriptor = this.createAndRegisterSlotDesc(slotPath);
            return slotDescriptor;
        }
    }

    private SlotDescriptor findPathInCurrentTuple(Path slotPath) {
        Preconditions.checkNotNull((Object)slotPath);
        TupleDescriptor currentTupleDesc = this.tupleStack_.peek();
        Preconditions.checkNotNull((Object)currentTupleDesc);
        List<String> slotPathFQR = slotPath.getFullyQualifiedRawPath();
        Preconditions.checkNotNull(slotPathFQR);
        for (SlotDescriptor slotDesc : currentTupleDesc.getSlots()) {
            List<String> tupleSlotFQR = slotDesc.getPath().getFullyQualifiedRawPath();
            if (!slotPathFQR.equals(tupleSlotFQR) || this.globalState_.duplicateCollectionSlots.contains(slotDesc.getId())) continue;
            return slotDesc;
        }
        return null;
    }

    private SlotDescriptor createAndRegisterSlotDesc(Path slotPath) throws AnalysisException {
        if (slotPath.destType().isCollectionType()) {
            SlotDescriptor result = this.registerCollectionSlotRef(slotPath);
            this.registerSlotDesc(slotPath, result, true);
            return result;
        }
        SlotDescriptor result = this.createAndRegisterRawSlotDesc(slotPath, true);
        if (slotPath.destType().isStructType()) {
            this.createStructTuplesAndSlotDescs(result);
        }
        return result;
    }

    private SlotDescriptor createAndRegisterRawSlotDesc(Path slotPath, boolean insertIntoSlotPathMap) {
        SlotDescriptor result = this.addSlotDescriptorAtCurrentLevel();
        this.registerSlotDesc(slotPath, result, insertIntoSlotPathMap);
        return result;
    }

    private void registerSlotDesc(Path slotPath, SlotDescriptor desc, boolean insertIntoSlotPathMap) {
        Preconditions.checkState((boolean)slotPath.isRootedAtTuple());
        desc.setPath(slotPath);
        if (insertIntoSlotPathMap) {
            this.slotPathMap_.put(slotPath.getFullyQualifiedRawPath(), desc);
        }
        this.registerColumnPrivReq(desc);
    }

    public void createStructTuplesAndSlotDescs(SlotDescriptor desc) throws AnalysisException {
        Preconditions.checkState((boolean)desc.getType().isStructType());
        TupleDescriptor structTuple = this.getDescTbl().createTupleDescriptor("struct_tuple");
        Path slotPath = desc.getPath();
        if (slotPath != null) {
            structTuple.setPath(slotPath);
        }
        StructType type = (StructType)desc.getType();
        structTuple.setType(type);
        structTuple.setParentSlotDesc(desc);
        desc.setItemTupleDesc(structTuple);
        try (TupleStackGuard guard = new TupleStackGuard(structTuple);){
            for (StructField structField : type.getFields()) {
                if (slotPath == null) {
                    this.createStructTuplesAndSlotDescsWithoutPath(slotPath, structField);
                    continue;
                }
                Path childRelPath = Path.createRelPath(slotPath, structField.getName());
                childRelPath.resolve();
                SlotDescriptor slotDescriptor = this.createAndRegisterSlotDesc(childRelPath);
            }
        }
    }

    private void createStructTuplesAndSlotDescsWithoutPath(Path slotPath, StructField structField) throws AnalysisException {
        Preconditions.checkState((slotPath == null ? 1 : 0) != 0);
        Preconditions.checkState((!structField.getType().isCollectionType() ? 1 : 0) != 0);
        SlotDescriptor childDesc = this.addSlotDescriptorAtCurrentLevel();
        childDesc.setType(structField.getType());
        if (childDesc.getType().isStructType()) {
            this.createStructTuplesAndSlotDescs(childDesc);
        }
    }

    private SlotDescriptor registerCollectionSlotRef(Path slotPath) throws AnalysisException {
        Preconditions.checkState((boolean)slotPath.isResolved());
        Preconditions.checkState((boolean)slotPath.destType().isCollectionType());
        List<String> rawPath = slotPath.getRawPath();
        ArrayList<String> collectionTableRawPath = new ArrayList<String>();
        TupleDescriptor rootDesc = slotPath.getRootDesc();
        Preconditions.checkNotNull((Object)rootDesc);
        if (rootDesc.hasExplicitAlias()) {
            collectionTableRawPath.add(rootDesc.getAlias());
        } else {
            collectionTableRawPath.addAll(Arrays.asList(rootDesc.getAlias().split("\\.")));
        }
        collectionTableRawPath.addAll(rawPath);
        TableRef tblRef = new TableRef(collectionTableRawPath, null);
        CollectionTableRef collTblRef = new CollectionTableRef(tblRef, slotPath, true);
        collTblRef.analyze(this);
        Preconditions.checkState((boolean)(collTblRef.getCollectionExpr() instanceof SlotRef));
        SlotDescriptor desc = ((SlotRef)collTblRef.getCollectionExpr()).getDesc();
        desc.setShouldMaterializeRecursively(true);
        try (TupleStackGuard guard = new TupleStackGuard(desc.getItemTupleDesc());){
            if (slotPath.destType().isArrayType()) {
                List<String> rawPathToItem = Arrays.asList("item");
                this.resolveAndRegisterDescendantPath(collTblRef, rawPathToItem);
            } else {
                Preconditions.checkState((boolean)slotPath.destType().isMapType());
                List<String> rawPathToKey = Arrays.asList("key");
                this.resolveAndRegisterDescendantPath(collTblRef, rawPathToKey);
                List<String> rawPathToValue = Arrays.asList("value");
                this.resolveAndRegisterDescendantPath(collTblRef, rawPathToValue);
            }
        }
        return desc;
    }

    private void resolveAndRegisterDescendantPath(CollectionTableRef collTblRef, List<String> rawPath) throws AnalysisException {
        Path resolvedPath = new Path(collTblRef.getDesc(), rawPath);
        boolean isResolved = resolvedPath.resolve();
        Preconditions.checkState((boolean)isResolved);
        this.registerSlotRef(resolvedPath, false);
    }

    private void registerColumnPrivReq(SlotDescriptor slotDesc) {
        Column column;
        Preconditions.checkNotNull((Object)slotDesc.getPath());
        TupleDescriptor tupleDesc = slotDesc.getParent();
        if (tupleDesc.isMaterialized() && tupleDesc.getTable() != null && (column = tupleDesc.getTable().getColumn(slotDesc.getPath().getRawPath().get(0))) != null) {
            this.registerPrivReq((PrivilegeRequestBuilder builder) -> builder.allOf(Privilege.SELECT).onColumn(tupleDesc.getTableName().getDb(), tupleDesc.getTableName().getTbl(), column.getName(), tupleDesc.getTable().getOwnerUser()).build());
        }
    }

    public void registerColumnForMasking(SlotDescriptor slotDesc) {
        TableRef tblRef;
        Preconditions.checkNotNull((Object)slotDesc.getPath());
        TupleDescriptor tupleDesc = slotDesc.getParent();
        Column column = slotDesc.isVirtualColumn() ? VirtualColumn.getVirtualColumn(slotDesc.getVirtualColumnType()) : new Column(String.join((CharSequence)".", slotDesc.getPath().getRawPath()), slotDesc.getType(), -1);
        Analyzer analyzer = this;
        do {
            tblRef = analyzer.tableRefMap_.get(tupleDesc.getId());
            analyzer = analyzer.getParentAnalyzer();
        } while (tblRef == null && analyzer != null);
        if (tblRef == null) {
            return;
        }
        Preconditions.checkNotNull((Object)tblRef, (String)"Failed to find TableRef of tuple {}", (Object)tupleDesc);
        tblRef.registerColumn(column);
    }

    public SlotDescriptor addSlotDescriptor(TupleDescriptor tupleDesc) {
        SlotDescriptor result = this.globalState_.descTbl.addSlotDescriptor(tupleDesc);
        this.globalState_.blockBySlot.put(result.getId(), this);
        return result;
    }

    private SlotDescriptor addSlotDescriptorAtCurrentLevel() {
        TupleDescriptor tupleDesc = this.tupleStack_.peek();
        Preconditions.checkNotNull((Object)tupleDesc);
        return this.addSlotDescriptor(tupleDesc);
    }

    public SlotDescriptor copySlotDescriptor(SlotDescriptor srcSlotDesc, TupleDescriptor tupleDesc) {
        SlotDescriptor result = this.globalState_.descTbl.addSlotDescriptor(tupleDesc);
        this.globalState_.blockBySlot.put(result.getId(), this);
        result.setSourceExprs(srcSlotDesc.getSourceExprs());
        result.setLabel(srcSlotDesc.getLabel());
        result.setStats(srcSlotDesc.getStats());
        result.setType(srcSlotDesc.getType());
        result.setItemTupleDesc(srcSlotDesc.getItemTupleDesc());
        return result;
    }

    public void registerConjuncts(List<Expr> l) throws AnalysisException {
        for (Expr e : l) {
            this.registerConjuncts(e, true);
        }
    }

    public void registerOnClauseConjuncts(List<Expr> conjuncts, TableRef rhsRef) throws AnalysisException {
        Preconditions.checkNotNull((Object)rhsRef);
        Preconditions.checkNotNull(conjuncts);
        List<ExprId> ojConjuncts = null;
        if (rhsRef.getJoinOp().isOuterJoin() && (ojConjuncts = this.globalState_.conjunctsByOjClause.get(rhsRef.getId())) == null) {
            ojConjuncts = new ArrayList<ExprId>();
            this.globalState_.conjunctsByOjClause.put(rhsRef.getId(), ojConjuncts);
        }
        boolean foundConstantFalse = false;
        for (Expr conjunct : conjuncts) {
            conjunct.setIsOnClauseConjunct(true);
            this.registerConjunct(conjunct);
            if (rhsRef.getJoinOp().isOuterJoin()) {
                this.globalState_.ojClauseByConjunct.put(conjunct.getId(), rhsRef);
                ojConjuncts.add(conjunct.getId());
            }
            if (rhsRef.getJoinOp().isSemiJoin()) {
                this.globalState_.sjClauseByConjunct.put(conjunct.getId(), rhsRef);
            }
            if (rhsRef.getJoinOp().isInnerJoin()) {
                this.globalState_.ijClauseByConjunct.put(conjunct.getId(), rhsRef);
            }
            if (!this.markConstantConjunct(conjunct, false)) continue;
            foundConstantFalse = true;
        }
        if (foundConstantFalse) {
            this.markConjunctsAssigned(conjuncts);
        }
    }

    public void registerConjuncts(Expr e, boolean fromHavingClause) throws AnalysisException {
        boolean foundConstantFalse = false;
        for (Expr conjunct : e.getConjuncts()) {
            this.registerConjunct(conjunct);
            foundConstantFalse = this.markConstantConjunct(conjunct, fromHavingClause);
            if (!foundConstantFalse) continue;
            break;
        }
        if (foundConstantFalse) {
            this.markConjunctsAssigned(e.getConjuncts());
        }
    }

    private boolean markConstantConjunct(Expr conjunct, boolean fromHavingClause) throws AnalysisException {
        if (!conjunct.isConstant() || this.isOjConjunct(conjunct)) {
            return false;
        }
        this.markConjunctAssigned(conjunct);
        if (!fromHavingClause && !this.hasEmptySpjResultSet_ || fromHavingClause && !this.hasEmptyResultSet_) {
            try {
                if (conjunct instanceof BetweenPredicate) {
                    ExprRewriter rewriter = new ExprRewriter(BetweenToCompoundRule.INSTANCE);
                    conjunct = rewriter.rewrite(conjunct, this);
                    conjunct.analyze(this);
                }
                if (!FeSupport.EvalPredicate(conjunct, this.globalState_.queryCtx)) {
                    if (fromHavingClause) {
                        this.hasEmptyResultSet_ = true;
                    } else {
                        this.hasEmptySpjResultSet_ = true;
                    }
                    return true;
                }
            }
            catch (InternalException ex) {
                throw new AnalysisException("Error evaluating \"" + conjunct.toSql() + "\"", ex);
            }
        }
        return false;
    }

    private void registerConjunct(Expr e) {
        e.setId(this.globalState_.conjunctIdGenerator.getNextId());
        this.globalState_.conjuncts.put(e.getId(), e);
        if (!e.isAuxExpr()) {
            this.globalState_.conjunctsFromQuery.put(e.getId(), e);
        }
        ArrayList<TupleId> tupleIds = new ArrayList<TupleId>();
        ArrayList<SlotId> slotIds = new ArrayList<SlotId>();
        e.getIds(tupleIds, slotIds);
        this.registerFullOuterJoinedConjunct(e);
        if (tupleIds.size() == 1 && !e.isAuxExpr()) {
            this.globalState_.singleTidConjuncts.add(e.getId());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("register tuple/slotConjunct: " + Integer.toString(e.getId().asInt()) + " " + e.toSql() + " " + e.debugString());
        }
        if (!(e instanceof BinaryPredicate)) {
            return;
        }
        BinaryPredicate binaryPred = (BinaryPredicate)e;
        if (binaryPred.getOp() != BinaryPredicate.Operator.EQ && binaryPred.getOp() != BinaryPredicate.Operator.NULL_MATCHING_EQ && binaryPred.getOp() != BinaryPredicate.Operator.NOT_DISTINCT) {
            return;
        }
        if (tupleIds.size() < 2) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            tupleIds = new ArrayList();
            ((Expr)binaryPred.getChild(i)).getIds(tupleIds, null);
            if (tupleIds.size() != 1) continue;
            if (!this.globalState_.eqJoinConjuncts.containsKey(tupleIds.get(0))) {
                ArrayList<ExprId> conjunctIds = new ArrayList<ExprId>();
                conjunctIds.add(e.getId());
                this.globalState_.eqJoinConjuncts.put((TupleId)tupleIds.get(0), (List<ExprId>)conjunctIds);
            } else {
                this.globalState_.eqJoinConjuncts.get(tupleIds.get(0)).add(e.getId());
            }
            binaryPred.setIsEqJoinConjunct(true);
            LOG.trace("register eqJoinConjunct: " + Integer.toString(e.getId().asInt()));
        }
    }

    public void createAuxEqPredicate(Expr lhs, Expr rhs) {
        if (Expr.IS_NULL_LITERAL.apply((Object)lhs) || Expr.IS_NULL_LITERAL.apply((Object)rhs) || lhs.getType().isNull() || rhs.getType().isNull()) {
            return;
        }
        BinaryPredicate p = new BinaryPredicate(BinaryPredicate.Operator.EQ, lhs, rhs);
        p.setIsAuxExpr();
        if (LOG.isTraceEnabled()) {
            LOG.trace("register auxiliary eq predicate: " + p.toSql() + " " + p.debugString());
        }
        this.registerConjunct(p);
    }

    public BinaryPredicate createInferredEqPred(SlotId lhsSlotId, SlotId rhsSlotId) {
        BinaryPredicate pred = new BinaryPredicate(BinaryPredicate.Operator.EQ, new SlotRef(this.globalState_.descTbl.getSlotDesc(lhsSlotId)), new SlotRef(this.globalState_.descTbl.getSlotDesc(rhsSlotId)));
        pred.setIsInferred();
        pred.analyzeNoThrow(this);
        return pred;
    }

    public List<Expr> getUnassignedConjuncts(List<TupleId> tupleIds, boolean inclOjConjuncts) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr e : this.globalState_.conjunctsFromQuery.values()) {
            if (!e.isBoundByTupleIds(tupleIds) || this.globalState_.assignedConjuncts.contains(e.getId()) || (!inclOjConjuncts || e.isConstant()) && this.globalState_.ojClauseByConjunct.containsKey(e.getId())) continue;
            result.add(e);
        }
        return result;
    }

    public TableRef getOjRef(Expr e) {
        return this.globalState_.ojClauseByConjunct.get(e.getId());
    }

    public boolean isOjConjunct(Expr e) {
        return this.globalState_.ojClauseByConjunct.containsKey(e.getId());
    }

    public boolean isIjConjunct(Expr e) {
        return this.globalState_.ijClauseByConjunct.containsKey(e.getId());
    }

    public boolean isSjConjunct(Expr e) {
        return this.globalState_.sjClauseByConjunct.containsKey(e.getId());
    }

    public TableRef getFullOuterJoinRef(Expr e) {
        return this.globalState_.fullOuterJoinedConjuncts.get(e.getId());
    }

    public boolean isFullOuterJoined(Expr e) {
        return this.globalState_.fullOuterJoinedConjuncts.containsKey(e.getId());
    }

    public final List<Expr> getUnassignedConjuncts(PlanNode node) {
        CopyOnWriteArrayList tupleIds = Lists.newCopyOnWriteArrayList(node.getTblRefIds());
        if (node instanceof JoinNode) {
            for (TupleId tid : node.getTblRefIds()) {
                TupleDescriptor tuple = this.getTupleDesc(tid);
                Preconditions.checkNotNull((Object)tuple);
                BaseTableRef maskedTable = tuple.getMaskedTable();
                if (maskedTable == null || !maskedTable.exposeNestedColumnsByTableMaskView()) continue;
                tupleIds.add(maskedTable.getId());
            }
        }
        return this.getUnassignedConjuncts(tupleIds);
    }

    public List<Expr> getUnassignedConjuncts(List<TupleId> tupleIds) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr e : this.getUnassignedConjuncts(tupleIds, true)) {
            if (!this.canEvalPredicate(tupleIds, e)) continue;
            result.add(e);
        }
        return result;
    }

    public String conjunctAssignmentsDebugString() {
        StringBuilder res = new StringBuilder();
        for (Expr _e : this.globalState_.conjuncts.values()) {
            String state = this.globalState_.assignedConjuncts.contains(_e.getId()) ? "assigned" : "unassigned";
            res.append("\n\t" + state + " " + _e.debugString());
        }
        return res.toString();
    }

    public boolean evalAfterJoin(Expr e) {
        ArrayList<TupleId> tids = new ArrayList<TupleId>();
        e.getIds(tids, null);
        if (tids.isEmpty()) {
            return false;
        }
        return tids.size() > 1 || this.isOjConjunct(e) || this.isFullOuterJoined(e) || this.isOuterJoined((TupleId)tids.get(0)) && (!e.isOnClauseConjunct() || this.isIjConjunct(e)) || this.isAntiJoinedConjunct(e) && !this.isSemiJoined((TupleId)tids.get(0));
    }

    public List<Expr> getUnassignedOjConjuncts(TableRef ref) {
        Preconditions.checkState((boolean)ref.getJoinOp().isOuterJoin());
        ArrayList<Expr> result = new ArrayList<Expr>();
        List<ExprId> candidates = this.globalState_.conjunctsByOjClause.get(ref.getId());
        if (candidates == null) {
            return result;
        }
        for (ExprId conjunctId : candidates) {
            if (this.globalState_.assignedConjuncts.contains(conjunctId)) continue;
            Expr e = this.globalState_.conjuncts.get(conjunctId);
            Preconditions.checkNotNull((Object)e);
            result.add(e);
        }
        return result;
    }

    public TableRef getLastOjClause(TupleId id) {
        return this.globalState_.outerJoinedTupleIds.get(id);
    }

    public SlotDescriptor getColumnSlot(TupleDescriptor tupleDesc, Column col) {
        for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
            if (slotDesc.getColumn() != col) continue;
            return slotDesc;
        }
        return null;
    }

    public DescriptorTable getDescTbl() {
        return this.globalState_.descTbl;
    }

    public FeCatalog getCatalog() {
        return ((GlobalState)this.globalState_).stmtTableCache.catalog;
    }

    public StmtMetadataLoader.StmtTableCache getStmtTableCache() {
        return this.globalState_.stmtTableCache;
    }

    public Set<String> getAliases() {
        return this.aliasMap_.keySet();
    }

    public void removeAlias(String alias) {
        this.aliasMap_.remove(alias);
    }

    public List<Expr> getEqJoinConjuncts(List<TupleId> lhsTblRefIds, List<TupleId> rhsTblRefIds) {
        ArrayList<ExprId> conjunctIds = new ArrayList<ExprId>();
        for (TupleId rhsId : rhsTblRefIds) {
            List<ExprId> cids = this.globalState_.eqJoinConjuncts.get(rhsId);
            if (cids == null) continue;
            for (ExprId eid : cids) {
                if (conjunctIds.contains(eid)) continue;
                conjunctIds.add(eid);
            }
        }
        List<ExprId> ojClauseConjuncts = null;
        if (rhsTblRefIds.size() == 1) {
            ojClauseConjuncts = this.globalState_.conjunctsByOjClause.get(rhsTblRefIds.get(0));
        }
        ArrayList nodeTblRefIds = Lists.newArrayList(lhsTblRefIds);
        nodeTblRefIds.addAll(rhsTblRefIds);
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (ExprId conjunctId : conjunctIds) {
            Expr e = this.globalState_.conjuncts.get(conjunctId);
            Preconditions.checkState((e != null ? 1 : 0) != 0);
            if (!this.canEvalFullOuterJoinedConjunct(e, nodeTblRefIds) || !this.canEvalAntiJoinedConjunct(e, nodeTblRefIds) || !this.canEvalOuterJoinedConjunct(e, nodeTblRefIds) || ojClauseConjuncts != null && !ojClauseConjuncts.contains(conjunctId)) continue;
            result.add(e);
        }
        return result;
    }

    public boolean canEvalFullOuterJoinedConjunct(Expr e, List<TupleId> tids) {
        TableRef fullOjRef = this.getFullOuterJoinRef(e);
        if (fullOjRef == null) {
            return true;
        }
        TableRef ojRef = this.getOjRef(e);
        TableRef targetRef = ojRef != null && ojRef != fullOjRef ? ojRef : fullOjRef;
        return tids.containsAll(targetRef.getAllTableRefIds());
    }

    public boolean canEvalOuterJoinedConjunct(Expr e, List<TupleId> tids) {
        TableRef outerJoin = this.getOjRef(e);
        if (outerJoin == null) {
            return true;
        }
        return tids.containsAll(outerJoin.getAllTableRefIds());
    }

    public boolean canEvalPredicate(List<TupleId> tupleIds, Expr e) {
        if (!e.isBoundByTupleIds(tupleIds)) {
            return false;
        }
        ArrayList<TupleId> tids = new ArrayList<TupleId>();
        e.getIds(tids, null);
        if (tids.isEmpty()) {
            return true;
        }
        if (e.isOnClauseConjunct()) {
            return this.canEvalOnClauseConjunct(tupleIds, e);
        }
        return this.isLastOjMaterializedByTupleIds(tupleIds, e);
    }

    public boolean isLastOjMaterializedByTupleIds(List<TupleId> tupleIds, Expr e) {
        ArrayList<TupleId> tids = new ArrayList<TupleId>();
        e.getIds(tids, null);
        for (TupleId tid : tids) {
            TableRef rhsRef = this.getLastOjClause(tid);
            if (rhsRef == null || tupleIds.containsAll(rhsRef.getAllTableRefIds())) continue;
            return false;
        }
        return true;
    }

    public boolean canEvalOnClauseConjunct(List<TupleId> tupleIds, Expr e) {
        Preconditions.checkState((boolean)e.isOnClauseConjunct());
        if (this.isAntiJoinedConjunct(e)) {
            return this.canEvalAntiJoinedConjunct(e, tupleIds);
        }
        ArrayList<TupleId> exprTids = new ArrayList<TupleId>();
        e.getIds(exprTids, null);
        if (exprTids.isEmpty()) {
            return true;
        }
        if (this.isIjConjunct(e) || this.isSjConjunct(e)) {
            if (!this.containsOuterJoinedTid(exprTids)) {
                return true;
            }
            TableRef onClauseTableRef = null;
            onClauseTableRef = this.isIjConjunct(e) ? this.globalState_.ijClauseByConjunct.get(e.getId()) : this.globalState_.sjClauseByConjunct.get(e.getId());
            Preconditions.checkNotNull((Object)onClauseTableRef);
            return tupleIds.containsAll(onClauseTableRef.getAllTableRefIds());
        }
        if (this.isFullOuterJoined(e)) {
            return this.canEvalFullOuterJoinedConjunct(e, tupleIds);
        }
        if (this.isOjConjunct(e)) {
            if (exprTids.size() > 1) {
                return false;
            }
            TupleId tid = (TupleId)exprTids.get(0);
            return this.globalState_.ojClauseByConjunct.get(e.getId()) == this.getLastOjClause(tid);
        }
        Preconditions.checkState((boolean)false);
        return false;
    }

    public boolean canEvalAntiJoinedConjunct(Expr e, List<TupleId> nodeTupleIds) {
        TableRef antiJoinRef = this.getAntiJoinRef(e);
        if (antiJoinRef == null) {
            return true;
        }
        ArrayList<TupleId> tids = new ArrayList<TupleId>();
        e.getIds(tids, null);
        if (tids.size() > 1) {
            return nodeTupleIds.containsAll(antiJoinRef.getAllTableRefIds()) && antiJoinRef.getAllTableRefIds().containsAll(nodeTupleIds);
        }
        return this.globalState_.semiJoinedTupleIds.containsKey(tids.get(0));
    }

    public List<Expr> getBoundPredicates(TupleId destTid, Set<SlotId> ignoreSlots, boolean markAssigned) {
        HashMap<ExprId, List> betweenPredicates = new HashMap<ExprId, List>();
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (ExprId srcConjunctId : this.globalState_.singleTidConjuncts) {
            TableRef tblRef;
            boolean hasOuterJoinedTuple;
            List<List<SlotId>> allDestSids;
            TupleId srcTid;
            ArrayList<SlotId> srcSids;
            Expr srcConjunct;
            block20: {
                srcConjunct = this.globalState_.conjuncts.get(srcConjunctId);
                if (srcConjunct instanceof SlotRef) continue;
                Preconditions.checkNotNull((Object)srcConjunct);
                ArrayList<TupleId> srcTids = new ArrayList<TupleId>();
                srcSids = new ArrayList<SlotId>();
                srcConjunct.getIds(srcTids, srcSids);
                Preconditions.checkState((srcTids.size() == 1 ? 1 : 0) != 0);
                srcTid = (TupleId)srcTids.get(0);
                allDestSids = this.getValueTransferDestSlotIds(srcTid, srcSids, destTid, ignoreSlots);
                if (allDestSids.isEmpty()) continue;
                hasOuterJoinedTuple = this.hasOuterJoinedValueTransferTarget(srcSids);
                try {
                    if (hasOuterJoinedTuple && this.isTrueWithNullSlots(srcConjunct)) {
                    }
                    break block20;
                }
                catch (InternalException e) {
                    LOG.warn("Skipping propagation of conjunct because backend evaluation failed: " + srcConjunct.toSql(), (Throwable)e);
                }
                continue;
            }
            if (this.globalState_.ojClauseByConjunct.containsKey(srcConjunct.getId()) && (!this.globalState_.outerJoinedTupleIds.containsKey(destTid) || this.globalState_.ojClauseByConjunct.get(srcConjunct.getId()) != this.globalState_.outerJoinedTupleIds.get(destTid) || (tblRef = this.globalState_.ojClauseByConjunct.get(srcConjunct.getId())).getJoinOp().isFullOuterJoin()) || this.isAntiJoinedConjunct(srcConjunct)) continue;
            for (List<SlotId> destSids : allDestSids) {
                Expr p;
                Preconditions.checkState((destSids.size() == srcSids.size() ? 1 : 0) != 0);
                if (srcSids.containsAll(destSids)) {
                    p = srcConjunct;
                } else {
                    block21: {
                        ExprSubstitutionMap smap = new ExprSubstitutionMap();
                        ExprSubstitutionMap ojSmap = new ExprSubstitutionMap();
                        for (int i = 0; i < srcSids.size(); ++i) {
                            if (this.globalState_.ojNullableSlotsInEquiPreds.contains(destSids.get(i))) {
                                ojSmap.put(new SlotRef(this.globalState_.descTbl.getSlotDesc((SlotId)srcSids.get(i))), new SlotRef(this.globalState_.descTbl.getSlotDesc(destSids.get(i))));
                                continue;
                            }
                            smap.put(new SlotRef(this.globalState_.descTbl.getSlotDesc((SlotId)srcSids.get(i))), new SlotRef(this.globalState_.descTbl.getSlotDesc(destSids.get(i))));
                        }
                        try {
                            p = srcConjunct.trySubstitute(smap, this, false);
                            if (hasOuterJoinedTuple && this.isNullableConjunct(p, Arrays.asList(destTid))) continue;
                            if (ojSmap.size() == 0) break block21;
                            p = p.trySubstitute(ojSmap, this, false);
                        }
                        catch (ImpalaException exc) {
                            continue;
                        }
                    }
                    p.setId(null);
                    if (p instanceof BinaryPredicate) {
                        ((BinaryPredicate)p).setIsInferred();
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("new pred: " + p.toSql() + " " + p.debugString());
                    }
                }
                if (markAssigned) {
                    boolean evalAfterJoin;
                    boolean reverseValueTransfer = true;
                    for (int i = 0; i < srcSids.size(); ++i) {
                        if (this.hasValueTransfer(destSids.get(i), (SlotId)srcSids.get(i))) continue;
                        reverseValueTransfer = false;
                        break;
                    }
                    boolean bl = evalAfterJoin = hasOuterJoinedTuple && !srcConjunct.isOnClauseConjunct_ || this.evalAfterJoin(srcConjunct) && this.globalState_.ojClauseByConjunct.get(srcConjunct.getId()) != this.globalState_.outerJoinedTupleIds.get(srcTid) || this.evalAfterJoin(p) && this.globalState_.ojClauseByConjunct.get(p.getId()) != this.globalState_.outerJoinedTupleIds.get(destTid);
                    if (reverseValueTransfer && !evalAfterJoin) {
                        this.markConjunctAssigned(srcConjunct);
                        if (p != srcConjunct) {
                            this.markConjunctAssigned(p);
                        }
                    }
                }
                if (p instanceof BinaryPredicate && ((BinaryPredicate)p).derivedFromBetween()) {
                    BinaryPredicate b = (BinaryPredicate)p;
                    betweenPredicates.computeIfAbsent(b.getBetweenExprId(), k -> new ArrayList());
                    ((List)betweenPredicates.get(b.getBetweenExprId())).add(b);
                    continue;
                }
                if (result.contains(p)) continue;
                result.add(p);
            }
        }
        if (!betweenPredicates.isEmpty()) {
            ArrayList<Expr> prioritizedExprs = new ArrayList<Expr>();
            for (List predicates : betweenPredicates.values()) {
                prioritizedExprs.addAll(predicates);
            }
            prioritizedExprs.addAll(result);
            Expr.removeDuplicates(prioritizedExprs);
            result = prioritizedExprs;
        }
        return result;
    }

    public List<Expr> getBoundPredicates(TupleId destTid) {
        return this.getBoundPredicates(destTid, new HashSet<SlotId>(), true);
    }

    public boolean hasOuterJoinedValueTransferTarget(List<SlotId> sids) {
        for (SlotId srcSid : sids) {
            for (SlotId dstSid : this.getValueTransferTargets(srcSid)) {
                if (!this.isOuterJoined(this.getTupleId(dstSid))) continue;
                return true;
            }
        }
        return false;
    }

    public void createEquivConjuncts(List<TupleId> lhsTids, List<TupleId> rhsTids, List<BinaryPredicate> conjuncts) {
        Preconditions.checkState((boolean)Collections.disjoint(lhsTids, rhsTids));
        Map<Integer, List<SlotId>> lhsEquivClasses = this.getEquivClassesOnTuples(lhsTids);
        Map<Integer, List<SlotId>> rhsEquivClasses = this.getEquivClassesOnTuples(rhsTids);
        DisjointSet<SlotId> partialEquivSlots = new DisjointSet<SlotId>();
        for (List<SlotId> partialEquivClass : lhsEquivClasses.values()) {
            partialEquivSlots.bulkUnion(partialEquivClass);
        }
        for (List<SlotId> partialEquivClass : rhsEquivClasses.values()) {
            partialEquivSlots.bulkUnion(partialEquivClass);
        }
        HashSet<Object> outerJoinedSlots = new HashSet<Object>();
        Iterator<BinaryPredicate> conjunctIter = conjuncts.iterator();
        while (conjunctIter.hasNext()) {
            int secondEqClassId;
            int firstEqClassId;
            Expr conjunct = conjunctIter.next();
            Pair<SlotId, SlotId> eqSlots = BinaryPredicate.getEqSlots(conjunct);
            if (eqSlots == null || (firstEqClassId = this.getEquivClassId((SlotId)eqSlots.first)) != (secondEqClassId = this.getEquivClassId((SlotId)eqSlots.second))) continue;
            boolean filtersOuterJoinNulls = false;
            if (this.isOuterJoined((SlotId)eqSlots.first) && lhsTids.contains(this.getTupleId((SlotId)eqSlots.first)) && !outerJoinedSlots.contains(eqSlots.first)) {
                outerJoinedSlots.add(eqSlots.first);
                filtersOuterJoinNulls = true;
            }
            if (this.isOuterJoined((SlotId)eqSlots.second) && lhsTids.contains(this.getTupleId((SlotId)eqSlots.second)) && !outerJoinedSlots.contains(eqSlots.second)) {
                outerJoinedSlots.add(eqSlots.second);
                filtersOuterJoinNulls = true;
            }
            if (partialEquivSlots.union((SlotId)eqSlots.first, (SlotId)eqSlots.second) || filtersOuterJoinNulls) continue;
            conjunctIter.remove();
        }
        for (Map.Entry<Integer, List<SlotId>> rhsEquivClass : rhsEquivClasses.entrySet()) {
            List<SlotId> lhsSlots = lhsEquivClasses.get(rhsEquivClass.getKey());
            if (lhsSlots == null) continue;
            List<SlotId> rhsSlots = rhsEquivClass.getValue();
            Preconditions.checkState((!lhsSlots.isEmpty() && !rhsSlots.isEmpty() ? 1 : 0) != 0);
            if (!partialEquivSlots.union(lhsSlots.get(0), rhsSlots.get(0)) || this.isFullOuterJoined(lhsSlots.get(0)) || this.isFullOuterJoined(rhsSlots.get(0))) continue;
            conjuncts.add(this.createInferredEqPred(lhsSlots.get(0), rhsSlots.get(0)));
        }
    }

    public <T extends Expr> void createEquivConjuncts(TupleId tid, List<T> conjuncts, Set<SlotId> ignoreSlots) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("createEquivConjuncts: tid=%s, conjuncts=%s, ignoreSlots=%s", tid.toString(), Expr.debugString(conjuncts), ignoreSlots), (Throwable)new Exception("call trace"));
        }
        DisjointSet<SlotId> partialEquivSlots = new DisjointSet<SlotId>();
        partialEquivSlots.bulkUnion(ignoreSlots);
        partialEquivSlots.checkConsistency();
        Iterator<T> conjunctIter = conjuncts.iterator();
        while (conjunctIter.hasNext()) {
            int secondEqClassId;
            int n;
            Expr conjunct = (Expr)conjunctIter.next();
            Pair<SlotId, SlotId> eqSlots = BinaryPredicate.getEqSlots(conjunct);
            if (eqSlots == null || (n = this.getEquivClassId((SlotId)eqSlots.first)) != (secondEqClassId = this.getEquivClassId((SlotId)eqSlots.second)) || partialEquivSlots.union((SlotId)eqSlots.first, (SlotId)eqSlots.second)) continue;
            conjunctIter.remove();
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Removed redundant conjunct: " + conjunct.debugString());
        }
        if (this.globalState_.assignedConjunctsByTupleId.containsKey(tid)) {
            List<BinaryPredicate> inferredConjuncts = this.globalState_.assignedConjunctsByTupleId.get(tid);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Previously assigned predicates: " + Expr.debugString(inferredConjuncts));
            }
            for (BinaryPredicate binaryPredicate : inferredConjuncts) {
                Pair<SlotId, SlotId> slots = binaryPredicate.getEqSlots();
                if (slots == null) continue;
                partialEquivSlots.union((SlotId)slots.first, (SlotId)slots.second);
            }
        }
        Map<Integer, List<SlotId>> targetEquivClasses = this.getEquivClassesOnTuples(Lists.newArrayList((Object[])new TupleId[]{tid}));
        block2: for (Map.Entry entry : targetEquivClasses.entrySet()) {
            List slotIds = (List)entry.getValue();
            boolean done = false;
            for (int i = 1; i < slotIds.size(); ++i) {
                SlotId rhs = (SlotId)slotIds.get(i);
                for (int j = 0; j < i; ++j) {
                    SlotId lhs = (SlotId)slotIds.get(j);
                    if (!partialEquivSlots.union(lhs, rhs)) continue;
                    BinaryPredicate pred = this.createInferredEqPred(lhs, rhs);
                    conjuncts.add(pred);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Created inferred predicate: " + ((Expr)pred).debugString());
                    }
                    if (partialEquivSlots.get(lhs).size() != slotIds.size()) continue;
                    done = true;
                    break;
                }
                if (done) continue block2;
            }
        }
    }

    public <T extends Expr> void createEquivConjuncts(TupleId tid, List<T> conjuncts) {
        this.createEquivConjuncts(tid, conjuncts, new HashSet<SlotId>());
    }

    private Map<Integer, List<SlotId>> getEquivClassesOnTuples(List<TupleId> tids) {
        HashMap<Integer, List<SlotId>> result = new HashMap<Integer, List<SlotId>>();
        Graph.SccCondensedGraph g = this.globalState_.valueTransferGraph;
        for (TupleId tid : tids) {
            for (SlotDescriptor slotDesc : this.getTupleDesc(tid).getSlots()) {
                int sccId;
                if (slotDesc.getId().asInt() >= g.numVertices() || g.sccMembersBySccId(sccId = g.sccId(slotDesc.getId().asInt())).length <= 1) continue;
                ArrayList<SlotId> slotIds = (ArrayList<SlotId>)result.get(sccId);
                if (slotIds == null) {
                    slotIds = new ArrayList<SlotId>();
                    result.put(sccId, slotIds);
                }
                slotIds.add(slotDesc.getId());
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace(String.format("slot(%s) -> scc(%d)", slotDesc.getId(), sccId));
            }
        }
        return result;
    }

    private List<List<SlotId>> getValueTransferDestSlotIds(TupleId srcTid, List<SlotId> srcSids, TupleId destTid, Set<SlotId> ignoreSlots) {
        ArrayList<List<SlotId>> allDestSids = new ArrayList<List<SlotId>>();
        TupleDescriptor destTupleDesc = this.getTupleDesc(destTid);
        if (srcSids.size() == 1) {
            SlotId srcSid = srcSids.get(0);
            for (SlotDescriptor destSlot : destTupleDesc.getSlotsRecursively()) {
                if (ignoreSlots.contains(destSlot.getId()) || !this.hasValueTransfer(srcSid, destSlot.getId())) continue;
                allDestSids.add(Lists.newArrayList((Object[])new SlotId[]{destSlot.getId()}));
            }
        } else if (srcTid.equals(destTid)) {
            allDestSids.add(srcSids);
        } else {
            ArrayList<SlotId> destSids = new ArrayList<SlotId>();
            block1: for (SlotId srcSid : srcSids) {
                for (SlotDescriptor destSlot : destTupleDesc.getSlotsRecursively()) {
                    if (ignoreSlots.contains(destSlot.getId()) || !this.hasValueTransfer(srcSid, destSlot.getId()) || destSids.contains(destSlot.getId())) continue;
                    destSids.add(destSlot.getId());
                    continue block1;
                }
            }
            if (destSids.size() == srcSids.size()) {
                allDestSids.add(destSids);
            }
        }
        return allDestSids;
    }

    public boolean isTrueWithNullSlots(Expr p) throws InternalException {
        Expr nullTuplePred = this.substituteNullSlots(p);
        if (this.globalState_.nullSlotsCache == null) {
            return FeSupport.EvalPredicate(nullTuplePred, this.getQueryCtx());
        }
        try {
            return (Boolean)this.globalState_.nullSlotsCache.get((Object)nullTuplePred, () -> FeSupport.EvalPredicate(nullTuplePred, this.getQueryCtx()));
        }
        catch (ExecutionException e) {
            Preconditions.checkState((boolean)(e.getCause() instanceof InternalException), (String)"Internal error using null slots cache: %s\nDisable null slots cache with the %s query option.", (Object)e, (Object)TImpalaQueryOptions.USE_NULL_SLOTS_CACHE.name());
            throw (InternalException)e.getCause();
        }
    }

    public void logCacheStats() {
        if (!LOG.isDebugEnabled() || this.globalState_.nullSlotsCache == null) {
            return;
        }
        Histogram exprSize = new Histogram((Reservoir)new UniformReservoir());
        MemoryMeter meter = MemoryMeter.builder().build();
        for (Expr expr : this.globalState_.nullSlotsCache.asMap().keySet()) {
            try {
                exprSize.update(meter.measureDeep((Object)expr));
            }
            catch (CannotAccessFieldException e) {
                LOG.warn("Unable to weigh cache entry, additional add-opens needed", (Throwable)e);
            }
        }
        Snapshot snap = exprSize.getSnapshot();
        LOG.debug("null slots cache size: {}, median entry: {}, 99th percentile entry: {}, hit rate: {}", new Object[]{this.globalState_.nullSlotsCache.size(), snap.getMedian(), snap.get99thPercentile(), this.globalState_.nullSlotsCache.stats().hitRate()});
    }

    public LiteralExpr evalWithNullSlots(Expr p) throws AnalysisException {
        Expr nullTuplePred = this.substituteNullSlots(p);
        if (!nullTuplePred.isConstant()) {
            return null;
        }
        return LiteralExpr.createBounded(nullTuplePred, this.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
    }

    private Expr substituteNullSlots(Expr p) {
        ArrayList slotRefs = new ArrayList();
        p.collect(Predicates.instanceOf(SlotRef.class), slotRefs);
        ExprSubstitutionMap nullSmap = new ExprSubstitutionMap();
        for (SlotRef slotRef : slotRefs) {
            nullSmap.put(slotRef.clone(), NullLiteral.create(slotRef.getType()));
        }
        return p.substitute(nullSmap, this, false);
    }

    public TupleId getTupleId(SlotId slotId) {
        return this.globalState_.descTbl.getSlotDesc(slotId).getParent().getId();
    }

    public void registerValueTransfer(SlotId id1, SlotId id2) {
        this.globalState_.registeredValueTransfers.add(new Pair<SlotId, SlotId>(id1, id2));
    }

    public boolean isOuterJoined(TupleId tid) {
        return this.globalState_.outerJoinedTupleIds.containsKey(tid);
    }

    public boolean isOuterJoined(SlotId sid) {
        return this.isOuterJoined(this.getTupleId(sid));
    }

    public boolean isSemiJoined(TupleId tid) {
        return this.globalState_.semiJoinedTupleIds.containsKey(tid);
    }

    public boolean isAntiJoinedConjunct(Expr e) {
        return this.getAntiJoinRef(e) != null;
    }

    public TableRef getAntiJoinRef(Expr e) {
        TableRef tblRef = this.globalState_.sjClauseByConjunct.get(e.getId());
        if (tblRef == null) {
            return null;
        }
        return tblRef.getJoinOp().isAntiJoin() ? tblRef : null;
    }

    public boolean isFullOuterJoined(TupleId tid) {
        return this.globalState_.fullOuterJoinedTupleIds.containsKey(tid);
    }

    public boolean isFullOuterJoined(SlotId sid) {
        return this.isFullOuterJoined(this.getTupleId(sid));
    }

    public boolean isVisible(TupleId tid) {
        return tid == this.visibleSemiJoinedTupleId_ || !this.isSemiJoined(tid);
    }

    public boolean containsOuterJoinedTid(List<TupleId> tids) {
        for (TupleId tid : tids) {
            if (!this.isOuterJoined(tid)) continue;
            return true;
        }
        return false;
    }

    public void computeValueTransferGraph() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("All slots: " + SlotDescriptor.debugString(this.globalState_.descTbl.getSlotDescs()));
        }
        Graph.WritableGraph directValueTransferGraph = new Graph.WritableGraph(this.globalState_.descTbl.getMaxSlotId().asInt() + 1);
        this.constructValueTransfersFromEqPredicates(directValueTransferGraph);
        for (Pair p : this.globalState_.registeredValueTransfers) {
            directValueTransferGraph.addEdge(((SlotId)p.first).asInt(), ((SlotId)p.second).asInt());
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("value transfer: from " + ((SlotId)p.first).toString() + " to " + ((SlotId)p.second).toString());
        }
        this.globalState_.valueTransferGraph = Graph.SccCondensedGraph.condensedReflexiveTransitiveClosure(directValueTransferGraph);
        if (RuntimeEnv.INSTANCE.isTestEnv() && this.getQueryOptions().num_nodes == 1) {
            Graph.RandomAccessibleGraph reference = directValueTransferGraph.toRandomAccessible().reflexiveTransitiveClosure();
            if (!this.globalState_.valueTransferGraph.validate(reference)) {
                String tc = reference.print();
                String condensedTc = this.globalState_.valueTransferGraph.print();
                throw new IllegalStateException("Condensed transitive closure doesn't equal to uncondensed transitive closure. Uncondensed Graph:\n" + tc + "\nCondensed Graph:\n" + condensedTc);
            }
        }
    }

    private void constructValueTransfersFromEqPredicates(Graph.WritableGraph g) {
        for (ExprId id : this.globalState_.conjuncts.keySet()) {
            SlotId outerSlot;
            SlotId innerSlot;
            Expr e = this.globalState_.conjuncts.get(id);
            Pair<SlotId, SlotId> slotIds = BinaryPredicate.getEqSlots(e);
            if (slotIds == null) continue;
            TableRef sjTblRef = this.globalState_.sjClauseByConjunct.get(id);
            Preconditions.checkState((sjTblRef == null || sjTblRef.getJoinOp().isSemiJoin() ? 1 : 0) != 0);
            boolean isAntiJoin = sjTblRef != null && sjTblRef.getJoinOp().isAntiJoin();
            TableRef ojTblRef = this.globalState_.ojClauseByConjunct.get(id);
            Preconditions.checkState((ojTblRef == null || ojTblRef.getJoinOp().isOuterJoin() ? 1 : 0) != 0);
            if (ojTblRef == null && !isAntiJoin) {
                Analyzer firstBlock = this.globalState_.blockBySlot.get(slotIds.first);
                Analyzer secondBlock = this.globalState_.blockBySlot.get(slotIds.second);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Considering value transfer between " + ((SlotId)slotIds.first).toString() + " and " + ((SlotId)slotIds.second).toString());
                }
                if (!secondBlock.hasLimitOffsetClause_ || !secondBlock.ancestors_.contains(firstBlock)) {
                    g.addEdge(((SlotId)slotIds.first).asInt(), ((SlotId)slotIds.second).asInt());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("value transfer: from " + ((SlotId)slotIds.first).toString() + " to " + ((SlotId)slotIds.second).toString());
                    }
                }
                if (firstBlock.hasLimitOffsetClause_ && firstBlock.ancestors_.contains(secondBlock)) continue;
                g.addEdge(((SlotId)slotIds.second).asInt(), ((SlotId)slotIds.first).asInt());
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("value transfer: from " + ((SlotId)slotIds.second).toString() + " to " + ((SlotId)slotIds.first).toString());
                continue;
            }
            TableRef tblRef = ojTblRef != null ? ojTblRef : sjTblRef;
            Preconditions.checkNotNull((Object)tblRef);
            if (tblRef.getJoinOp() == JoinOperator.FULL_OUTER_JOIN) continue;
            if (tblRef.getId() == this.getTupleId((SlotId)slotIds.first)) {
                innerSlot = (SlotId)slotIds.first;
                outerSlot = (SlotId)slotIds.second;
            } else {
                if (tblRef.getId() != this.getTupleId((SlotId)slotIds.second)) continue;
                innerSlot = (SlotId)slotIds.second;
                outerSlot = (SlotId)slotIds.first;
            }
            if (tblRef.getJoinOp() == JoinOperator.LEFT_OUTER_JOIN || tblRef.getJoinOp() == JoinOperator.LEFT_ANTI_JOIN || tblRef.getJoinOp() == JoinOperator.NULL_AWARE_LEFT_ANTI_JOIN) {
                g.addEdge(outerSlot.asInt(), innerSlot.asInt());
            } else if (tblRef.getJoinOp() == JoinOperator.RIGHT_OUTER_JOIN || tblRef.getJoinOp() == JoinOperator.RIGHT_ANTI_JOIN) {
                g.addEdge(innerSlot.asInt(), outerSlot.asInt());
            }
            if (tblRef.getJoinOp() != JoinOperator.LEFT_OUTER_JOIN && tblRef.getJoinOp() != JoinOperator.RIGHT_OUTER_JOIN) continue;
            this.globalState_.ojNullableSlotsInEquiPreds.add(innerSlot);
        }
    }

    public List<SlotId> getEquivClass(SlotId sid) {
        Graph.SccCondensedGraph g = this.globalState_.valueTransferGraph;
        if (sid.asInt() >= g.numVertices()) {
            return Collections.singletonList(sid);
        }
        ArrayList<SlotId> result = new ArrayList<SlotId>();
        for (int dst : g.sccMembersByVid(sid.asInt())) {
            result.add(new SlotId(dst));
        }
        return result;
    }

    public List<SlotId> getValueTransferTargets(SlotId srcSid) {
        Graph.SccCondensedGraph g = this.globalState_.valueTransferGraph;
        if (srcSid.asInt() >= g.numVertices()) {
            return Collections.singletonList(srcSid);
        }
        ArrayList<SlotId> result = new ArrayList<SlotId>();
        IntIterator dstIt = g.dstIter(srcSid.asInt());
        while (dstIt.hasNext()) {
            result.add(new SlotId(dstIt.peek()));
            dstIt.next();
        }
        Collections.sort(result);
        return result;
    }

    private int getEquivClassId(SlotId sid) {
        Graph.SccCondensedGraph g = this.globalState_.valueTransferGraph;
        return sid.asInt() >= g.numVertices() ? sid.asInt() : g.sccId(sid.asInt());
    }

    public boolean exprsHaveValueTransfer(Expr e1, Expr e2, boolean mutual) {
        return e1.matches(e2, mutual ? this.MUTUAL_VALUE_TRANSFER_SLOTREF_CMP : this.VALUE_TRANSFER_SLOTREF_CMP);
    }

    public boolean setsHaveValueTransfer(List<Expr> l1, List<Expr> l2, boolean mutual) {
        l1 = Expr.removeDuplicates(l1, this.MUTUAL_VALUE_TRANSFER_SLOTREF_CMP);
        l2 = Expr.removeDuplicates(l2, this.MUTUAL_VALUE_TRANSFER_SLOTREF_CMP);
        if (l1.size() != l2.size()) {
            return false;
        }
        for (Expr e2 : l2) {
            boolean foundInL1 = false;
            for (Expr e1 : l1) {
                if (!e1.matches(e2, mutual ? this.MUTUAL_VALUE_TRANSFER_SLOTREF_CMP : this.VALUE_TRANSFER_SLOTREF_CMP)) continue;
                foundInL1 = true;
                break;
            }
            if (foundInL1) continue;
            return false;
        }
        return true;
    }

    public void exprIntersect(List<Expr> l1, List<Expr> l2, List<Expr> i1, List<Expr> i2) {
        i1.clear();
        i2.clear();
        block0: for (Expr e1 : l1) {
            for (Expr e2 : l2) {
                if (!e1.matches(e2, this.MUTUAL_VALUE_TRANSFER_SLOTREF_CMP)) continue;
                i1.add(e1);
                i2.add(e2);
                continue block0;
            }
        }
    }

    public void markConjunctsAssigned(List<Expr> conjuncts) {
        if (conjuncts == null || conjuncts.isEmpty()) {
            return;
        }
        for (Expr p : conjuncts) {
            this.markConjunctAssigned(p);
        }
    }

    public void markConjunctAssigned(Expr conjunct) {
        this.globalState_.assignedConjuncts.add(conjunct.getId());
        if (Predicate.isEquivalencePredicate(conjunct)) {
            BinaryPredicate binaryPred = (BinaryPredicate)conjunct;
            ArrayList<TupleId> tupleIds = new ArrayList<TupleId>();
            ArrayList<SlotId> slotIds = new ArrayList<SlotId>();
            binaryPred.getIds(tupleIds, slotIds);
            if (tupleIds.size() == 1 && slotIds.size() == 2 && binaryPred.getEqSlots() != null) {
                TupleId tupleId = (TupleId)tupleIds.get(0);
                if (!this.globalState_.assignedConjunctsByTupleId.containsKey(tupleId)) {
                    this.globalState_.assignedConjunctsByTupleId.put(tupleId, new ArrayList());
                }
                this.globalState_.assignedConjunctsByTupleId.get(tupleId).add(binaryPred);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Assigned " + conjunct.debugString());
        }
    }

    public Set<ExprId> getAssignedConjuncts() {
        return Sets.newHashSet(this.globalState_.assignedConjuncts);
    }

    public void setAssignedConjuncts(Set<ExprId> assigned) {
        this.globalState_.assignedConjuncts = Sets.newHashSet(assigned);
    }

    public Set<TupleDescriptor> materializeSlots(List<Expr> exprs) {
        ArrayList<SlotId> slotIds = new ArrayList<SlotId>();
        for (Expr e : exprs) {
            Preconditions.checkState((boolean)e.isAnalyzed());
            e.getIds(null, slotIds);
        }
        return this.globalState_.descTbl.markSlotsMaterialized(slotIds);
    }

    public Set<TupleDescriptor> materializeSlots(Expr e) {
        ArrayList<SlotId> slotIds = new ArrayList<SlotId>();
        Preconditions.checkState((boolean)e.isAnalyzed());
        e.getIds(null, slotIds);
        return this.globalState_.descTbl.markSlotsMaterialized(slotIds);
    }

    public Type getCompatibleType(Type lastCompatibleType, Expr lastCompatibleExpr, Expr expr) throws AnalysisException {
        return Analyzer.getCompatibleType(lastCompatibleType, lastCompatibleExpr, expr, this.getRegularCompatibilityLevel());
    }

    public static Type getCompatibleType(Type leftType, Expr leftExpr, Type rightType, Expr rightExpr, TypeCompatibility compatibility) throws AnalysisException {
        Type compatibleType = Type.getAssignmentCompatibleType(leftType, rightType, compatibility);
        Analyzer.checkCompatibility(leftType, leftExpr, rightType, rightExpr, compatibleType, compatibility);
        return compatibleType;
    }

    public static Type getCompatibleType(Type lastCompatibleType, Expr lastCompatibleExpr, Expr expr, TypeCompatibility compatibility) throws AnalysisException {
        Type newCompatibleType = lastCompatibleType == null ? expr.getType() : Type.getAssignmentCompatibleType(lastCompatibleType, expr.getType(), compatibility);
        Analyzer.checkCompatibility(lastCompatibleType, lastCompatibleExpr, expr.getType(), expr, newCompatibleType, compatibility);
        return newCompatibleType;
    }

    private static void checkCompatibility(Type leftType, Expr leftExpr, Type rightType, Expr rightExpr, Type compatibleType, TypeCompatibility compatibility) throws AnalysisException {
        if (compatibility.isUnsafe()) {
            Optional<Expr> nonConstExpr = leftExpr.getFirstNonConstSourceExpr();
            if (!nonConstExpr.isPresent()) {
                nonConstExpr = rightExpr.getFirstNonConstSourceExpr();
            }
            if (nonConstExpr.isPresent()) {
                throw new AnalysisException(String.format("Unsafe implicit cast is prohibited for non-const expression: %s", nonConstExpr.get().toSql()));
            }
        }
        if (!compatibleType.isValid()) {
            throw new AnalysisException(String.format("Incompatible return types '%s' and '%s' of exprs '%s' and '%s'.", leftType.toSql(), rightType.toSql(), leftExpr.toSql(), rightExpr.toSql()));
        }
    }

    public void castAllToCompatibleType(List<Expr> exprs) throws AnalysisException {
        int i;
        ArrayList<Expr> sortedExprs = new ArrayList<Expr>(exprs);
        Collections.sort(sortedExprs, new Comparator<Expr>(){

            @Override
            public int compare(Expr expr1, Expr expr2) {
                if (expr1.getType().isDecimal() && expr2.getType().isDecimal() || !expr1.getType().isDecimal() && !expr2.getType().isDecimal()) {
                    return 0;
                }
                return expr1.getType().isDecimal() ? 1 : -1;
            }
        });
        Expr lastCompatibleExpr = (Expr)sortedExprs.get(0);
        Type compatibleType = null;
        for (i = 0; i < sortedExprs.size(); ++i) {
            ((Expr)sortedExprs.get(i)).analyze(this);
            compatibleType = this.getCompatibleType(compatibleType, lastCompatibleExpr, (Expr)sortedExprs.get(i));
        }
        for (i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i).getType().equals(compatibleType)) continue;
            Expr castExpr = exprs.get(i).castTo(compatibleType);
            exprs.set(i, castExpr);
        }
    }

    public List<Expr> castToSetOpCompatibleTypes(List<List<Expr>> exprLists, boolean avoidLossyCharPadding) throws AnalysisException {
        if (exprLists == null || exprLists.size() == 0) {
            return null;
        }
        if (exprLists.size() == 1) {
            return exprLists.get(0);
        }
        TypeCompatibility regularCompatibility = this.getRegularCompatibilityLevel();
        TypeCompatibility permissiveCompatibility = this.getPermissiveCompatibilityLevel();
        List<Expr> firstList = exprLists.get(0);
        ArrayList<Expr> widestExprs = new ArrayList<Expr>(firstList.size());
        for (int i = 0; i < firstList.size(); ++i) {
            int j;
            TypeCompatibility compatibilityLevel = regularCompatibility;
            Type compatibleType = firstList.get(i).getType();
            if (firstList.get(i) instanceof SlotRef && compatibleType.containsStruct()) {
                throw new AnalysisException(String.format("Set operations don't support STRUCT types or types containing STRUCT types. %s in %s.", compatibleType.toSql(), firstList.get(i).toSql()));
            }
            widestExprs.add(firstList.get(i));
            for (j = 1; j < exprLists.size(); ++j) {
                Preconditions.checkState((exprLists.get(j).size() == firstList.size() ? 1 : 0) != 0);
                Type preType = compatibleType;
                Expr expr = exprLists.get(j).get(i);
                try {
                    compatibleType = Analyzer.getCompatibleType(compatibleType, (Expr)widestExprs.get(i), expr, compatibilityLevel);
                }
                catch (AnalysisException e) {
                    compatibilityLevel = permissiveCompatibility;
                    if (permissiveCompatibility.isUnsafe()) {
                        compatibleType = Analyzer.getCompatibleType(compatibleType, (Expr)widestExprs.get(i), expr, compatibilityLevel);
                    }
                    throw e;
                }
                if (preType == compatibleType) continue;
                if (avoidLossyCharPadding && Analyzer.differentLenCharTypes(preType, compatibleType)) {
                    Preconditions.checkState((!compatibilityLevel.isUnsafe() ? 1 : 0) != 0);
                    Preconditions.checkState((boolean)compatibleType.isChar());
                    int length = ((ScalarType)compatibleType).getLength();
                    compatibleType = ScalarType.createVarcharType(length);
                    expr = expr.castTo(compatibleType, compatibilityLevel);
                }
                widestExprs.set(i, expr);
            }
            for (j = 0; j < exprLists.size(); ++j) {
                Expr expr = exprLists.get(j).get(i);
                Type commonType = Analyzer.getCompatibleType(expr.getType(), expr, compatibleType, (Expr)widestExprs.get(i), compatibilityLevel);
                Preconditions.checkState((boolean)commonType.equals(compatibleType));
                if (expr.getType().equals(compatibleType)) continue;
                Expr castExpr = expr.castTo(compatibleType, compatibilityLevel);
                exprLists.get(j).set(i, castExpr);
            }
        }
        return widestExprs;
    }

    public String getDefaultDb() {
        return this.globalState_.queryCtx.session.database;
    }

    public String getFallbackDbForFunctions() {
        return this.getQueryCtx().getClient_request().getQuery_options().getFallback_db_for_functions();
    }

    public User getUser() {
        return this.user_;
    }

    public String getUserShortName() throws AnalysisException {
        try {
            return this.getUser().getShortName();
        }
        catch (InternalException e) {
            throw new AnalysisException("Could not get the shortened name for user: " + this.getUser().getName(), e);
        }
    }

    public TQueryCtx getQueryCtx() {
        return this.globalState_.queryCtx;
    }

    public TQueryOptions getQueryOptions() {
        return this.globalState_.queryCtx.client_request.getQuery_options();
    }

    public boolean isDecimalV2() {
        return this.getQueryOptions().isDecimal_v2();
    }

    public TypeCompatibility getRegularCompatibilityLevel(TypeCompatibility compatibility) {
        TQueryOptions queryOptions = this.getQueryOptions();
        if (queryOptions.isDecimal_v2()) {
            return TypeCompatibility.applyStrictDecimal(compatibility);
        }
        return compatibility;
    }

    public TypeCompatibility getRegularCompatibilityLevel() {
        return this.getRegularCompatibilityLevel(TypeCompatibility.DEFAULT);
    }

    public TypeCompatibility getPermissiveCompatibilityLevel() {
        TQueryOptions queryOptions = this.getQueryOptions();
        if (queryOptions.isAllow_unsafe_casts()) {
            return TypeCompatibility.UNSAFE;
        }
        return this.getRegularCompatibilityLevel(TypeCompatibility.DEFAULT);
    }

    public AuthorizationFactory getAuthzFactory() {
        return this.globalState_.authzFactory;
    }

    public AuthorizationConfig getAuthzConfig() {
        return this.getAuthzFactory().getAuthorizationConfig();
    }

    public AuthorizationContext getAuthzCtx() {
        return this.globalState_.authzCtx;
    }

    public boolean isAuthzEnabled() {
        return this.getAuthzConfig().isEnabled();
    }

    public ListMap<TNetworkAddress> getHostIndex() {
        return this.globalState_.hostIndex;
    }

    public ColumnLineageGraph getColumnLineageGraph() {
        return this.globalState_.lineageGraph;
    }

    public TLineageGraph getThriftSerializedLineageGraph() {
        Preconditions.checkNotNull((Object)this.globalState_.lineageGraph);
        return this.globalState_.lineageGraph.toThrift();
    }

    public ImmutableList<PrivilegeRequest> getPrivilegeReqs() {
        return ImmutableList.copyOf((Collection)this.globalState_.privilegeReqs);
    }

    public ImmutableList<Pair<PrivilegeRequest, String>> getMaskedPrivilegeReqs() {
        return ImmutableList.copyOf((Collection)this.globalState_.maskedPrivilegeReqs);
    }

    public Set<TAccessEvent> getAccessEvents() {
        return this.globalState_.accessEvents;
    }

    public void addAccessEvent(TAccessEvent event) {
        event.name = event.name.toLowerCase();
        this.globalState_.accessEvents.add(event);
    }

    public FeTable getTable(TableName tblName, boolean mustExist) throws AnalysisException, TableLoadingException {
        if (IcebergMetadataTable.isIcebergMetadataTable(tblName.toPath(), this)) {
            return this.getMetadataVirtualTable(tblName.toPath());
        }
        FeTable table = ((GlobalState)this.globalState_).stmtTableCache.tables.get(tblName);
        if (table == null) {
            if (!mustExist) {
                return null;
            }
            if (!((GlobalState)this.globalState_).stmtTableCache.dbs.contains(tblName.getDb())) {
                throw new AnalysisException(DB_DOES_NOT_EXIST_ERROR_MSG + tblName.getDb());
            }
            throw new AnalysisException(TBL_DOES_NOT_EXIST_ERROR_MSG + tblName.toString());
        }
        Preconditions.checkState((boolean)table.isLoaded(), (String)"table: %s should be loaded", (Object)tblName);
        if (table instanceof FeIncompleteTable) {
            ImpalaException cause = ((FeIncompleteTable)table).getCause();
            if (cause instanceof TableLoadingException) {
                throw (TableLoadingException)cause;
            }
            throw new TableLoadingException("Missing metadata for table: " + tblName, cause);
        }
        return table;
    }

    public FeTable getTable(String dbName, String tableName, boolean mustExist) throws AnalysisException, TableLoadingException {
        TableName tblName = new TableName(dbName, tableName);
        return this.getTable(tblName, mustExist);
    }

    public void addVirtualTable(VirtualTable virtTable) {
        TableName tblName = virtTable.getTableName();
        ((GlobalState)this.globalState_).stmtTableCache.tables.put(tblName, virtTable);
    }

    public FeTable getMetadataVirtualTable(List<String> tblRefPath) throws AnalysisException {
        Preconditions.checkArgument((boolean)IcebergMetadataTable.canBeIcebergMetadataTable(tblRefPath));
        try {
            TableName catalogTableName = new TableName(tblRefPath.get(0), tblRefPath.get(1));
            TableName virtualTableName = new TableName(tblRefPath.get(0), tblRefPath.get(1), tblRefPath.get(2));
            FeTable catalogTable = this.getStmtTableCache().tables.get(virtualTableName);
            if (catalogTable instanceof IcebergMetadataTable || catalogTable == null) {
                return catalogTable;
            }
            Preconditions.checkState((boolean)(catalogTable instanceof FeIcebergTable));
            FeIcebergTable catalogIceTable = (FeIcebergTable)catalogTable;
            IcebergMetadataTable virtualTable = new IcebergMetadataTable(catalogIceTable, tblRefPath.get(2));
            this.getStmtTableCache().tables.put(catalogTableName, catalogTable);
            this.getStmtTableCache().tables.put(virtualTableName, virtualTable);
            return virtualTable;
        }
        catch (ImpalaRuntimeException e) {
            throw new AnalysisException("Could not create metadata table for table reference: " + StringUtils.join(tblRefPath, (String)"."), e);
        }
    }

    public org.apache.kudu.client.KuduTable getKuduTable(FeKuduTable feKuduTable) throws AnalysisException {
        String tableName = feKuduTable.getFullName();
        org.apache.kudu.client.KuduTable kuduTable = this.globalState_.kuduTables.get(tableName);
        if (kuduTable == null && feKuduTable instanceof LocalKuduTable && ((LocalKuduTable)feKuduTable).getKuduTable() != null) {
            kuduTable = ((LocalKuduTable)feKuduTable).getKuduTable();
            this.globalState_.kuduTables.put(tableName, kuduTable);
        }
        if (kuduTable == null) {
            try {
                KuduClient client = KuduUtil.getKuduClient(feKuduTable.getKuduMasterHosts());
                kuduTable = client.openTable(feKuduTable.getKuduTableName());
                this.globalState_.kuduTables.put(tableName, kuduTable);
            }
            catch (Exception ex) {
                throw new AnalysisException("Unable to open the Kudu table: " + tableName, ex);
            }
        }
        return kuduTable;
    }

    public FeTable getTableNoThrow(String dbName, String tableName) {
        FeDb db = this.getCatalog().getDb(dbName);
        if (db == null) {
            return null;
        }
        return db.getTableIfCached(tableName);
    }

    public boolean tableExists(TableName tblName) {
        Preconditions.checkNotNull((Object)tblName);
        TableName fqTableName = this.getFqTableName(tblName);
        return ((GlobalState)this.globalState_).stmtTableCache.tables.containsKey(fqTableName);
    }

    public boolean dbExists(String dbName) {
        Preconditions.checkNotNull((Object)dbName);
        return this.getCatalog().getDb(dbName) != null;
    }

    public FeTable getTable(TableName tableName, boolean addAccessEvent, boolean addColumnPrivilege, Privilege ... privilege) throws AnalysisException, TableLoadingException {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)privilege);
        TableName fqTableName = this.getFqTableName(tableName);
        FeTable table = this.getTableNoThrow(fqTableName.getDb(), fqTableName.getTbl());
        String tableOwner = table == null ? null : table.getOwnerUser();
        for (Privilege priv : privilege) {
            if (priv == Privilege.ANY || addColumnPrivilege) {
                this.registerPrivReq((PrivilegeRequestBuilder builder) -> builder.allOf(priv).onAnyColumn(fqTableName.getDb(), fqTableName.getTbl(), tableOwner).build());
                continue;
            }
            this.registerPrivReq((PrivilegeRequestBuilder builder) -> builder.allOf(priv).onTable(fqTableName.getDb(), fqTableName.getTbl(), tableOwner).build());
        }
        table = this.getTable(fqTableName.getDb(), fqTableName.getTbl(), true);
        Preconditions.checkNotNull((Object)table);
        if (addAccessEvent) {
            TCatalogObjectType objectType = TCatalogObjectType.TABLE;
            if (table instanceof FeView) {
                objectType = TCatalogObjectType.VIEW;
            }
            for (Privilege priv : privilege) {
                this.addAccessEvent(new TAccessEvent(fqTableName.toString(), objectType, priv.toString()));
            }
        }
        return table;
    }

    public FeTable getTable(TableName tableName, Privilege ... privilege) throws AnalysisException {
        try {
            return this.getTable(tableName, true, false, privilege);
        }
        catch (TableLoadingException e) {
            throw new AnalysisException(e);
        }
    }

    public FeTable getTable(TableName tableName, boolean addColumnPrivilege, Privilege ... privilege) throws AnalysisException {
        try {
            return this.getTable(tableName, true, addColumnPrivilege, privilege);
        }
        catch (TableLoadingException e) {
            throw new AnalysisException(e);
        }
    }

    public FeDb getDb(String dbName, Privilege privilege) throws AnalysisException {
        return this.getDb(dbName, privilege, true);
    }

    public FeDb getDb(String dbName, Privilege privilege, boolean throwIfDoesNotExist) throws AnalysisException {
        return this.getDb(dbName, privilege, throwIfDoesNotExist, false);
    }

    public FeDb getDb(String dbName, Privilege privilege, boolean throwIfDoesNotExist, boolean requireGrantOption) throws AnalysisException {
        FeDb db = this.getDb(dbName, false);
        this.registerPrivReq((PrivilegeRequestBuilder builder) -> {
            if (requireGrantOption) {
                builder.grantOption();
            }
            if (privilege == Privilege.ANY) {
                String dbOwner = db == null ? null : db.getOwnerUser();
                return builder.any().onAnyColumn(dbName, dbOwner).build();
            }
            if (db == null) {
                return builder.allOf(privilege).onDb(dbName, null).build();
            }
            return builder.allOf(privilege).onDb(db).build();
        });
        FeDb retDb = this.getDb(dbName, throwIfDoesNotExist);
        this.addAccessEvent(new TAccessEvent(dbName, TCatalogObjectType.DATABASE, privilege.toString()));
        return retDb;
    }

    public FeDb getDb(String dbName, boolean throwIfDoesNotExist) throws AnalysisException {
        FeDb db = this.getCatalog().getDb(dbName);
        if (db == null && throwIfDoesNotExist) {
            throw new AnalysisException(DB_DOES_NOT_EXIST_ERROR_MSG + dbName);
        }
        return db;
    }

    public boolean dbContainsTable(String dbName, String tableName, Privilege privilege) throws AnalysisException {
        try {
            FeTable table;
            FeDb db = this.getCatalog().getDb(dbName);
            FeTable feTable = table = db == null ? null : db.getTable(tableName);
            if (table != null) {
                this.registerPrivReq((PrivilegeRequestBuilder builder) -> builder.allOf(privilege).onTable(table).build());
            } else if (privilege == Privilege.CREATE) {
                String dbOwnerUser = db == null ? null : db.getOwnerUser();
                this.registerPrivReq((PrivilegeRequestBuilder builder) -> builder.allOf(privilege).onTable(dbName, tableName, dbOwnerUser).build());
            } else {
                Preconditions.checkState((table == null && privilege != Privilege.CREATE ? 1 : 0) != 0);
                this.registerPrivReq((PrivilegeRequestBuilder builder) -> builder.allOf(privilege).onTableUnknownOwner(dbName, tableName).build());
            }
            if (db == null) {
                throw new DatabaseNotFoundException("Database not found: " + dbName);
            }
            return table != null;
        }
        catch (DatabaseNotFoundException e) {
            throw new AnalysisException(DB_DOES_NOT_EXIST_ERROR_MSG + dbName);
        }
    }

    public String getTargetDbName(TableName tableName) {
        return tableName.isFullyQualified() ? tableName.getDb() : this.getDefaultDb();
    }

    public String getTargetDbName(FunctionName functionName) {
        return functionName.isFullyQualified() ? functionName.getDb() : this.getDefaultDb();
    }

    public TableName getFqTableName(TableName tableName) {
        if (tableName.isFullyQualified()) {
            return tableName;
        }
        return new TableName(this.getDefaultDb(), tableName.getTbl());
    }

    public void setMaskPrivChecks(String errMsg) {
        this.maskPrivChecks_ = true;
        this.authErrorMsg_ = errMsg;
    }

    public void setEnablePrivChecks(boolean value) {
        this.enablePrivChecks_ = value;
    }

    public void setIsStraightJoin() {
        this.isStraightJoin_ = true;
    }

    public boolean isStraightJoin() {
        return this.isStraightJoin_;
    }

    public void setIsExplain() {
        this.globalState_.isExplain = true;
    }

    public boolean isExplain() {
        return this.globalState_.isExplain;
    }

    public void setUseHiveColLabels(boolean useHiveColLabels) {
        this.useHiveColLabels_ = useHiveColLabels;
    }

    public boolean useHiveColLabels() {
        return this.useHiveColLabels_;
    }

    public void setHasLimitOffsetClause(boolean hasLimitOffset) {
        this.hasLimitOffsetClause_ = hasLimitOffset;
    }

    public List<Expr> getConjuncts() {
        return new ArrayList<Expr>(this.globalState_.conjuncts.values());
    }

    public int incrementCallDepth() {
        return ++this.callDepth_;
    }

    public int decrementCallDepth() {
        return --this.callDepth_;
    }

    public int getCallDepth() {
        return this.callDepth_;
    }

    public int incrementNumStmtExprs() {
        return this.globalState_.numStmtExprs_++;
    }

    public int getNumStmtExprs() {
        return this.globalState_.numStmtExprs_;
    }

    public void checkStmtExprLimit() throws AnalysisException {
        int statementExpressionLimit = this.getQueryOptions().getStatement_expression_limit();
        if (this.getNumStmtExprs() > statementExpressionLimit) {
            String errorStr = String.format("Exceeded the statement expression limit (%d)\nStatement has %d expressions.", statementExpressionLimit, this.getNumStmtExprs());
            throw new AnalysisException(errorStr);
        }
    }

    public boolean hasMutualValueTransfer(SlotId a, SlotId b) {
        return this.hasValueTransfer(a, b) && this.hasValueTransfer(b, a);
    }

    public boolean hasValueTransfer(SlotId a, SlotId b) {
        Graph.SccCondensedGraph g = this.globalState_.valueTransferGraph;
        return a.equals(b) || a.asInt() < g.numVertices() && b.asInt() < g.numVertices() && g.hasEdge(a.asInt(), b.asInt());
    }

    public Map<String, FeView> getLocalViews() {
        return this.localViews_;
    }

    public void addWarning(String msg) {
        if (this.checkWarningsRetrieved(msg)) {
            return;
        }
        if (msg == null) {
            return;
        }
        Integer count = this.globalState_.warnings.get(msg);
        if (count == null) {
            count = 0;
        }
        this.globalState_.warnings.put(msg, count + 1);
    }

    private boolean checkWarningsRetrieved(String msg) {
        if (this.globalState_.warningsRetrieved) {
            Preconditions.checkState((boolean)this.globalState_.warnings.containsKey(msg));
            return true;
        }
        return false;
    }

    public void registerPrivReq(PrivilegeRequest privReq) {
        if (!this.enablePrivChecks_) {
            return;
        }
        if (this.maskPrivChecks_) {
            this.globalState_.maskedPrivilegeReqs.add(Pair.create(privReq, this.authErrorMsg_));
        } else {
            this.globalState_.privilegeReqs.add(privReq);
        }
    }

    public void registerPrivReq(Function<PrivilegeRequestBuilder, PrivilegeRequest> function) {
        this.registerPrivReq(function.apply(new PrivilegeRequestBuilder(this.getAuthzFactory().getAuthorizableFactory())));
    }

    public void registerAuthAndAuditEvent(FeTable table, Privilege priv) {
        this.registerAuthAndAuditEvent(table, priv, false);
    }

    public void registerAuthAndAuditEvent(FeTable table, Privilege priv, boolean requireGrantOption) {
        if (table instanceof FeView) {
            FeView view = (FeView)table;
            Preconditions.checkState((!view.isLocalView() ? 1 : 0) != 0);
            this.addAccessEvent(new TAccessEvent(table.getFullName(), TCatalogObjectType.VIEW, priv.toString()));
        } else {
            this.addAccessEvent(new TAccessEvent(table.getFullName(), TCatalogObjectType.TABLE, priv.toString()));
        }
        this.registerPrivReq((PrivilegeRequestBuilder builder) -> {
            builder.onTable(table).allOf(priv);
            if (requireGrantOption) {
                builder.grantOption();
            }
            return builder.build();
        });
    }

    public String getServerName() {
        return this.isAuthzEnabled() ? this.getAuthzConfig().getServerName().intern() : null;
    }

    private List<Expr> getTableConjuncts(TupleId id) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Map.Entry<ExprId, Expr> conjunct : this.globalState_.conjuncts.entrySet()) {
            Expr expr = conjunct.getValue();
            if (expr == null || expr.isOnClauseConjunct() || expr.isAuxExpr()) continue;
            ArrayList<TupleId> tids = new ArrayList<TupleId>();
            expr.getIds(tids, null);
            if (!tids.contains(id)) continue;
            result.add(expr);
        }
        return result;
    }

    private Set<Set<TupleId>> collectTupleIdForDisjunctiveConjuncts(Expr e) {
        HashSet<Set<TupleId>> set = new HashSet<Set<TupleId>>();
        if (Expr.IS_OR_PREDICATE.apply((Object)e)) {
            set.addAll(this.collectTupleIdForDisjunctiveConjuncts((Expr)e.getChild(0)));
            set.addAll(this.collectTupleIdForDisjunctiveConjuncts((Expr)e.getChild(1)));
        } else {
            ArrayList<TupleId> tids = new ArrayList<TupleId>();
            e.getIds(tids, null);
            set.add(new HashSet<TupleId>(tids));
        }
        return set;
    }

    private boolean isNullableConjunct(Expr e, List<TupleId> tupleIds) {
        ArrayList orConjuncts = new ArrayList();
        e.collectAll(Expr.IS_OR_PREDICATE, orConjuncts);
        for (Expr expr : orConjuncts) {
            Set<Set<TupleId>> childrenTis = this.collectTupleIdForDisjunctiveConjuncts(expr);
            for (Set<TupleId> tids : childrenTis) {
                tids.retainAll(tupleIds);
                if (!tids.isEmpty()) continue;
                return true;
            }
        }
        if (e.contains(Predicates.or((com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{Expr.IS_DISTINCT_FROM_OR_NOT_DISTINCT_PREDICATE, Expr.IS_NONDETERMINISTIC_BUILTIN_FN_PREDICATE, Expr.IS_UDF_PREDICATE, Expr.IS_IS_NULL_PREDICATE}))) {
            return true;
        }
        ArrayList maybeNullableExprs = new ArrayList();
        e.collectAll(Predicates.or(Expr.IS_CONDITIONAL_BUILTIN_FN_PREDICATE, Expr.IS_CASE_EXPR_PREDICATE), maybeNullableExprs);
        if (!maybeNullableExprs.isEmpty()) {
            if (!Expr.IS_BINARY_PREDICATE.apply((Object)e)) {
                return true;
            }
            for (Expr operand : e.getChildren()) {
                if (operand instanceof ArithmeticExpr) {
                    for (Expr expr : operand.getChildren()) {
                        if (!this.noConditionalBuiltinFnOrCaseExpr(expr, tupleIds)) continue;
                        return false;
                    }
                    continue;
                }
                if (!this.noConditionalBuiltinFnOrCaseExpr(operand, tupleIds)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean noConditionalBuiltinFnOrCaseExpr(Expr e, List<TupleId> tupleIds) {
        ArrayList nullableExprs = new ArrayList();
        e.collectAll(Predicates.or(Expr.IS_CONDITIONAL_BUILTIN_FN_PREDICATE, Expr.IS_CASE_EXPR_PREDICATE), nullableExprs);
        if (!nullableExprs.isEmpty()) {
            return false;
        }
        ArrayList<TupleId> tids = new ArrayList<TupleId>();
        e.getIds(tids, null);
        return TupleId.intersect(tupleIds, new HashSet<TupleId>(tids));
    }

    private boolean hasNullRejectingConjucts(List<TupleId> tupleIds) {
        for (TupleId id : tupleIds) {
            List<Expr> conjuncts = this.getTableConjuncts(id);
            for (Expr e : conjuncts) {
                if (this.isNullableConjunct(e, tupleIds)) continue;
                try {
                    if (this.isTrueWithNullSlots(e)) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Tuple " + id + " has null rejecting conjunct: " + e.debugString());
                    }
                    return true;
                }
                catch (InternalException ex) {
                    LOG.warn("Skipping to check whether the conjunct is null-rejecting becausebackend evaluation failed: " + e.toSql(), (Throwable)ex);
                }
            }
        }
        return false;
    }

    private void removeOuterJoinedTupleIds(List<TupleId> ids) {
        for (TupleId id : ids) {
            this.globalState_.outerJoinedTupleIds.remove(id);
        }
    }

    private void ojToIjOnClauseConjucts(TableRef tblRef) {
        List<ExprId> ojConjuncts = this.globalState_.conjunctsByOjClause.get(tblRef.getId());
        for (ExprId eid : ojConjuncts) {
            this.globalState_.ojClauseByConjunct.remove(eid);
            this.globalState_.ijClauseByConjunct.put(eid, tblRef);
        }
        this.globalState_.conjunctsByOjClause.remove(tblRef.getId());
    }

    private void removeFullOuterJoinedTupleIdsAndConjuncts(List<TupleId> ids) {
        for (TupleId id : ids) {
            TableRef ref = this.globalState_.fullOuterJoinedTupleIds.get(id);
            Iterator<Map.Entry<ExprId, TableRef>> it = this.globalState_.fullOuterJoinedConjuncts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ExprId, TableRef> entry = it.next();
                if (entry.getValue() != ref) continue;
                it.remove();
            }
            this.globalState_.fullOuterJoinedTupleIds.remove(id);
        }
    }

    private void reRegisterIsNotEmptyPredicates(TableRef tblRef) {
        Preconditions.checkState((boolean)tblRef.getJoinOp().isInnerJoin());
        if (this.hasWithClause()) {
            return;
        }
        if (!(tblRef instanceof CollectionTableRef)) {
            return;
        }
        CollectionTableRef ref = (CollectionTableRef)tblRef;
        if (!ref.isRelative() || ref.isCorrelated()) {
            return;
        }
        if (this.isOuterJoined(ref.getResolvedPath().getRootDesc().getId())) {
            return;
        }
        try {
            IsNotEmptyPredicate isNotEmptyPred = new IsNotEmptyPredicate(ref.getCollectionExpr().clone());
            isNotEmptyPred.analyze(this);
            this.registerOnClauseConjuncts(Lists.newArrayList((Object[])new Expr[]{isNotEmptyPred}), ref);
        }
        catch (AnalysisException ex) {
            LOG.warn("Re-register the !empty() predicates failed.", (Throwable)ex);
        }
    }

    public boolean hasOuterJoined(List<TableRef> tableRefs) {
        for (TableRef tblRef : tableRefs) {
            if (!tblRef.getJoinOp().isOuterJoin()) continue;
            return true;
        }
        return false;
    }

    private void getNullRejectingOjTidsFromIjOnClause(TableRef tblRef, Set<TupleId> nullRejectingTids) {
        ArrayList<Expr> onConjuncts = new ArrayList<Expr>();
        for (Map.Entry<ExprId, TableRef> entry : this.globalState_.ijClauseByConjunct.entrySet()) {
            Expr e;
            if (entry.getValue() != tblRef || !(e = this.globalState_.conjuncts.get(entry.getKey())).isOnClauseConjunct()) continue;
            onConjuncts.add(e);
        }
        List<TupleId> tids = tblRef.getLeftTblRef().getAllTableRefIds();
        for (Expr e : onConjuncts) {
            if (this.isNullableConjunct(e, tids)) continue;
            try {
                if (this.isTrueWithNullSlots(e)) continue;
                ArrayList<TupleId> ids = new ArrayList<TupleId>();
                e.getIds(ids, null);
                for (TupleId id : ids) {
                    if (!this.isOuterJoined(id)) continue;
                    nullRejectingTids.add(id);
                }
            }
            catch (InternalException ex) {
                LOG.warn("Skipping the conjunct of on clause because backend evaluation failed: " + e.toSql(), (Throwable)ex);
            }
        }
    }

    private boolean simplifyOuterJoinsByIjOnClause(List<TableRef> tableRefs, TableRef ijTableRef) {
        HashSet<TupleId> nullRejectingTidSet = new HashSet<TupleId>();
        this.getNullRejectingOjTidsFromIjOnClause(ijTableRef, nullRejectingTidSet);
        if (!nullRejectingTidSet.isEmpty()) {
            return this.simplifyOuterJoins(tableRefs, nullRejectingTidSet);
        }
        return false;
    }

    public boolean simplifyOuterJoins(List<TableRef> tableRefs, Set<TupleId> nullRejectingTids) {
        boolean isSimplified = false;
        ArrayList<TableRef> processedTblRefs = new ArrayList<TableRef>();
        for (TableRef tableRef : tableRefs) {
            switch (tableRef.getJoinOp()) {
                case INNER_JOIN: {
                    if (tableRef.getLeftTblRef() == null) break;
                    boolean ret = this.simplifyOuterJoinsByIjOnClause(processedTblRefs, tableRef);
                    isSimplified = isSimplified ? true : ret;
                    break;
                }
                case LEFT_OUTER_JOIN: {
                    TupleId id = tableRef.getId();
                    if (!nullRejectingTids.contains(id) && !this.hasNullRejectingConjucts(id.asList())) break;
                    tableRef.setJoinOp(JoinOperator.INNER_JOIN);
                    this.removeOuterJoinedTupleIds(id.asList());
                    this.ojToIjOnClauseConjucts(tableRef);
                    this.reRegisterIsNotEmptyPredicates(tableRef);
                    this.simplifyOuterJoinsByIjOnClause(processedTblRefs, tableRef);
                    isSimplified = true;
                    break;
                }
                case RIGHT_OUTER_JOIN: {
                    List<TupleId> ids = tableRef.getLeftTblRef().getAllTableRefIds();
                    boolean hasNullRejectingTid = this.gatherNullRejectingTids(ids, nullRejectingTids);
                    if (!hasNullRejectingTid && !TupleId.intersect(ids, nullRejectingTids) && !this.hasNullRejectingConjucts(ids)) break;
                    tableRef.setJoinOp(JoinOperator.INNER_JOIN);
                    this.removeOuterJoinedTupleIds(new ArrayList<TupleId>(nullRejectingTids));
                    this.ojToIjOnClauseConjucts(tableRef);
                    this.reRegisterIsNotEmptyPredicates(tableRef);
                    this.simplifyOuterJoinsByIjOnClause(processedTblRefs, tableRef);
                    isSimplified = true;
                    break;
                }
                case FULL_OUTER_JOIN: {
                    List<TupleId> ids = tableRef.getLeftTblRef().getAllTableRefIds();
                    boolean hasNullRejectingTid = this.gatherNullRejectingTids(ids, nullRejectingTids);
                    if (hasNullRejectingTid || TupleId.intersect(ids, nullRejectingTids) || this.hasNullRejectingConjucts(ids)) {
                        this.removeFullOuterJoinedTupleIdsAndConjuncts(ids);
                        this.removeFullOuterJoinedTupleIdsAndConjuncts(tableRef.getId().asList());
                        if (nullRejectingTids.contains(tableRef.getId()) || this.hasNullRejectingConjucts(tableRef.getId().asList())) {
                            tableRef.setJoinOp(JoinOperator.INNER_JOIN);
                            nullRejectingTids.add(tableRef.getId());
                            this.removeOuterJoinedTupleIds(new ArrayList<TupleId>(nullRejectingTids));
                            this.ojToIjOnClauseConjucts(tableRef);
                            this.reRegisterIsNotEmptyPredicates(tableRef);
                            this.simplifyOuterJoinsByIjOnClause(processedTblRefs, tableRef);
                        } else {
                            tableRef.setJoinOp(JoinOperator.LEFT_OUTER_JOIN);
                            this.removeOuterJoinedTupleIds(new ArrayList<TupleId>(nullRejectingTids));
                        }
                        isSimplified = true;
                        break;
                    }
                    if (!nullRejectingTids.contains(tableRef.getId()) && !this.hasNullRejectingConjucts(tableRef.getId().asList())) break;
                    tableRef.setJoinOp(JoinOperator.RIGHT_OUTER_JOIN);
                    this.removeOuterJoinedTupleIds(tableRef.getId().asList());
                    isSimplified = true;
                    break;
                }
            }
            processedTblRefs.add(tableRef);
        }
        return isSimplified;
    }

    private boolean gatherNullRejectingTids(List<TupleId> tupleIds, Set<TupleId> nullRejectingTids) {
        boolean hasNullRejectingTid = false;
        block2: for (TupleId id : tupleIds) {
            List<Expr> conjuncts = this.getTableConjuncts(id);
            for (Expr e : conjuncts) {
                if (this.isNullableConjunct(e, tupleIds)) continue;
                try {
                    if (this.isTrueWithNullSlots(e)) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Tuple " + id + " has null rejecting conjunct: " + e.debugString());
                    }
                    nullRejectingTids.add(id);
                    hasNullRejectingTid = true;
                    continue block2;
                }
                catch (InternalException ex) {
                    LOG.warn("Fail to verify " + e.toSql() + " being null-rejecting because of the backend evaluation failure", (Throwable)ex);
                }
            }
        }
        return hasNullRejectingTid;
    }

    private static boolean differentLenCharTypes(Type t1, Type t2) {
        if (!t1.isChar() || !t2.isChar()) {
            return false;
        }
        ScalarType t1Scalar = (ScalarType)t1;
        ScalarType t2Scalar = (ScalarType)t2;
        return t1Scalar.getLength() != t2Scalar.getLength();
    }

    private static class GlobalState {
        public final TQueryCtx queryCtx;
        public final AuthorizationFactory authzFactory;
        public final AuthorizationContext authzCtx;
        public final DescriptorTable descTbl = new DescriptorTable();
        public final IdGenerator<ExprId> conjunctIdGenerator = ExprId.createGenerator();
        public final ColumnLineageGraph lineageGraph;
        public boolean isExplain;
        public boolean hasPlanHints = false;
        public boolean containsSubquery = false;
        public boolean setOperationNeedsRewrite = false;
        public boolean hasTopLevelAcidCollectionTableRef = false;
        public boolean includeAllCoordinatorsInScheduling = false;
        public final Map<ExprId, Expr> conjuncts = new LinkedHashMap<ExprId, Expr>();
        public final Map<ExprId, Expr> conjunctsFromQuery = new LinkedHashMap<ExprId, Expr>();
        public final Map<TupleId, List<BinaryPredicate>> assignedConjunctsByTupleId = new HashMap<TupleId, List<BinaryPredicate>>();
        public final List<ExprId> singleTidConjuncts = new ArrayList<ExprId>();
        public final Map<TupleId, List<ExprId>> eqJoinConjuncts = new HashMap<TupleId, List<ExprId>>();
        public Set<ExprId> assignedConjuncts = Collections.newSetFromMap(new IdentityHashMap());
        public final Map<TupleId, TableRef> outerJoinedTupleIds = new HashMap<TupleId, TableRef>();
        public final Map<ExprId, TableRef> fullOuterJoinedConjuncts = new HashMap<ExprId, TableRef>();
        public final Map<TupleId, TableRef> fullOuterJoinedTupleIds = new HashMap<TupleId, TableRef>();
        public final Map<TupleId, TableRef> semiJoinedTupleIds = new HashMap<TupleId, TableRef>();
        public final Map<TupleId, List<ExprId>> conjunctsByOjClause = new HashMap<TupleId, List<ExprId>>();
        public final Map<ExprId, TableRef> ojClauseByConjunct = new HashMap<ExprId, TableRef>();
        public final Map<ExprId, TableRef> sjClauseByConjunct = new HashMap<ExprId, TableRef>();
        public final Map<ExprId, TableRef> ijClauseByConjunct = new HashMap<ExprId, TableRef>();
        public final Map<SlotId, Analyzer> blockBySlot = new HashMap<SlotId, Analyzer>();
        private final Set<PrivilegeRequest> privilegeReqs = new LinkedHashSet<PrivilegeRequest>();
        private final List<Pair<PrivilegeRequest, String>> maskedPrivilegeReqs = new ArrayList<Pair<PrivilegeRequest, String>>();
        public Set<TAccessEvent> accessEvents = new HashSet<TAccessEvent>();
        public final Map<String, Integer> warnings = new LinkedHashMap<String, Integer>();
        public boolean warningsRetrieved = false;
        private Graph.SccCondensedGraph valueTransferGraph;
        private final List<Pair<SlotId, SlotId>> registeredValueTransfers = new ArrayList<Pair<SlotId, SlotId>>();
        private final ListMap<TNetworkAddress> hostIndex = new ListMap();
        private final StmtMetadataLoader.StmtTableCache stmtTableCache;
        private final ExprRewriter constantFolder_ = new ExprRewriter(FoldConstantsRule.INSTANCE);
        private final ExprRewriter exprRewriter_;
        private final Cache<Expr, Boolean> nullSlotsCache;
        private int numStmtExprs_ = 0;
        private int numExecutorsForPlanning_ = -1;
        private int availableCoresPerNode_ = -1;
        public final Map<String, org.apache.kudu.client.KuduTable> kuduTables = new HashMap<String, org.apache.kudu.client.KuduTable>();
        public Set<SlotId> ojNullableSlotsInEquiPreds = new HashSet<SlotId>();
        public Set<TupleId> zippingUnnestTupleIds = new HashSet<TupleId>();
        public int numZippingUnnests = 0;
        public Set<SlotId> duplicateCollectionSlots = new HashSet<SlotId>();

        public GlobalState(StmtMetadataLoader.StmtTableCache stmtTableCache, TQueryCtx queryCtx, AuthorizationFactory authzFactory, AuthorizationContext authzCtx) {
            this.stmtTableCache = stmtTableCache;
            this.queryCtx = queryCtx;
            this.authzCtx = authzCtx;
            this.authzFactory = authzFactory;
            this.lineageGraph = new ColumnLineageGraph();
            ArrayList<ExprRewriteRule> rules = new ArrayList<ExprRewriteRule>();
            rules.add(BetweenToCompoundRule.INSTANCE);
            rules.add(NormalizeBinaryPredicatesRule.INSTANCE);
            rules.add(ExtractCompoundVerticalBarExprRule.INSTANCE);
            if (queryCtx.getClient_request().getQuery_options().enable_expr_rewrites) {
                rules.add(FoldConstantsRule.INSTANCE);
                rules.add(NormalizeExprsRule.INSTANCE);
                rules.add(ExtractCommonConjunctRule.INSTANCE);
                if (queryCtx.getClient_request().getQuery_options().isEnable_cnf_rewrites()) {
                    rules.add(new ConvertToCNFRule(queryCtx.getClient_request().getQuery_options().getMax_cnf_exprs(), true));
                }
                rules.add(SimplifyConditionalsRule.INSTANCE);
                rules.add(EqualityDisjunctsToInRule.INSTANCE);
                rules.add(NormalizeCountStarRule.INSTANCE);
                rules.add(SimplifyDistinctFromRule.INSTANCE);
                rules.add(SimplifyCastStringToTimestamp.INSTANCE);
                rules.add(CountDistinctToNdvRule.INSTANCE);
                rules.add(DefaultNdvScaleRule.INSTANCE);
                rules.add(SimplifyCastExprRule.INSTANCE);
            }
            rules.add(CountStarToConstRule.INSTANCE);
            this.exprRewriter_ = new ExprRewriter(rules);
            this.nullSlotsCache = queryCtx.getClient_request().getQuery_options().use_null_slots_cache ? CacheBuilder.newBuilder().concurrencyLevel(1).recordStats().build() : null;
        }
    }

    public static enum OperationType {
        READ,
        WRITE,
        ANY;

    }

    private class TupleStackGuard
    implements AutoCloseable {
        private final TupleDescriptor tupleDesc_;
        private boolean isClosed_ = false;
        private final int stackLen_;

        public TupleStackGuard(TupleDescriptor tupleDesc) {
            Preconditions.checkNotNull((Object)Analyzer.this.tupleStack_);
            Preconditions.checkNotNull((Object)tupleDesc);
            this.tupleDesc_ = tupleDesc;
            this.stackLen_ = Analyzer.this.tupleStack_.size();
            Analyzer.this.tupleStack_.push(this.tupleDesc_);
        }

        @Override
        public void close() {
            if (!this.isClosed_) {
                Preconditions.checkState((Analyzer.this.tupleStack_.peek() == this.tupleDesc_ ? 1 : 0) != 0);
                Analyzer.this.tupleStack_.pop();
                Preconditions.checkState((Analyzer.this.tupleStack_.size() == this.stackLen_ ? 1 : 0) != 0);
                this.isClosed_ = true;
            }
        }
    }
}

