/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.AggregateInfoBase;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.catalog.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticInfo
extends AggregateInfoBase {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticInfo.class);
    private final List<AnalyticExpr> analyticExprs_;
    private final List<Expr> commonPartitionExprs_;
    private final ExprSubstitutionMap analyticTupleSmap_;

    private AnalyticInfo(List<AnalyticExpr> analyticExprs) {
        super(new ArrayList<Expr>(), new ArrayList<FunctionCallExpr>());
        this.analyticExprs_ = Expr.cloneList(analyticExprs);
        for (Expr expr : analyticExprs) {
            this.aggregateExprs_.add(((AnalyticExpr)expr).getFnCall());
        }
        this.analyticTupleSmap_ = new ExprSubstitutionMap();
        this.commonPartitionExprs_ = this.computeCommonPartitionExprs();
    }

    private AnalyticInfo(AnalyticInfo other) {
        super(other);
        this.analyticExprs_ = other.analyticExprs_ != null ? Expr.cloneList(other.analyticExprs_) : null;
        this.analyticTupleSmap_ = other.analyticTupleSmap_.clone();
        this.commonPartitionExprs_ = Expr.cloneList(other.commonPartitionExprs_);
    }

    public List<AnalyticExpr> getAnalyticExprs() {
        return this.analyticExprs_;
    }

    public ExprSubstitutionMap getSmap() {
        return this.analyticTupleSmap_;
    }

    public List<Expr> getCommonPartitionExprs() {
        return this.commonPartitionExprs_;
    }

    public static AnalyticInfo create(List<AnalyticExpr> analyticExprs, Analyzer analyzer) {
        Preconditions.checkState((analyticExprs != null && !analyticExprs.isEmpty() ? 1 : 0) != 0);
        Expr.removeDuplicates(analyticExprs);
        AnalyticInfo result = new AnalyticInfo(analyticExprs);
        result.createTupleDescs(analyzer);
        result.outputTupleDesc_.setIsMaterialized(false);
        result.intermediateTupleDesc_.setIsMaterialized(false);
        Preconditions.checkState((analyticExprs.size() == result.outputTupleDesc_.getSlots().size() ? 1 : 0) != 0);
        for (int i = 0; i < analyticExprs.size(); ++i) {
            result.analyticTupleSmap_.put(result.analyticExprs_.get(i), new SlotRef(result.outputTupleDesc_.getSlots().get(i)));
            result.outputTupleDesc_.getSlots().get(i).setSourceExpr(result.analyticExprs_.get(i));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("analytictuple=" + result.outputTupleDesc_.debugString());
            LOG.trace("analytictuplesmap=" + result.analyticTupleSmap_.debugString());
            LOG.trace("analytic info:\n" + result.debugString());
        }
        return result;
    }

    private List<Expr> computeCommonPartitionExprs() {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr expr : this.analyticExprs_) {
            Preconditions.checkState((boolean)expr.isAnalyzed());
            List<Expr> partitionExprs = ((AnalyticExpr)expr).getPartitionExprs();
            if (partitionExprs == null || partitionExprs.size() == 0) {
                result.clear();
                break;
            }
            if (result.isEmpty()) {
                result.addAll(partitionExprs);
                continue;
            }
            result.retainAll(partitionExprs);
            if (!result.isEmpty()) continue;
            break;
        }
        return result;
    }

    @Override
    public void materializeRequiredSlots(Analyzer analyzer, ExprSubstitutionMap smap) {
        this.materializedSlots_.clear();
        ArrayList<AnalyticExpr> exprs = new ArrayList<AnalyticExpr>();
        for (int i = 0; i < this.analyticExprs_.size(); ++i) {
            SlotDescriptor outputSlotDesc = this.outputTupleDesc_.getSlots().get(i);
            if (!outputSlotDesc.isMaterialized()) continue;
            this.intermediateTupleDesc_.getSlots().get(i).setIsMaterialized(true);
            exprs.add(this.analyticExprs_.get(i));
            this.materializedSlots_.add(i);
        }
        List<Expr> resolvedExprs = Expr.substituteList(exprs, smap, analyzer, false);
        analyzer.materializeSlots(resolvedExprs);
    }

    public void checkConsistency() {
        List<SlotDescriptor> slots = this.intermediateTupleDesc_.getSlots();
        int numMaterializedSlots = 0;
        for (SlotDescriptor slotDesc : slots) {
            if (!slotDesc.isMaterialized()) continue;
            ++numMaterializedSlots;
        }
        Preconditions.checkState((numMaterializedSlots == this.materializedSlots_.size() ? 1 : 0) != 0);
        int slotIdx = 0;
        for (int i = 0; i < this.analyticExprs_.size(); ++i) {
            Expr analyticExpr = this.analyticExprs_.get(i);
            Type slotType = slots.get(slotIdx).getType();
            Preconditions.checkState((boolean)analyticExpr.getType().equals(slotType), (Object)String.format("Analytic expr %s returns type %s but its analytic tuple slot has type %s", analyticExpr.toSql(), analyticExpr.getType().toString(), slotType.toString()));
            ++slotIdx;
        }
    }

    @Override
    public String debugString() {
        StringBuilder out = new StringBuilder(super.debugString());
        out.append(MoreObjects.toStringHelper((Object)this).add("analytic_exprs", (Object)Expr.debugString(this.analyticExprs_)).add("smap", (Object)this.analyticTupleSmap_.debugString()).toString());
        return out.toString();
    }

    @Override
    protected String tupleDebugName() {
        return "analytic-tuple";
    }

    public AnalyticInfo clone() {
        return new AnalyticInfo(this);
    }
}

