/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.MaterializedViewHdfsTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TAlterTableUnSetTblPropertiesParams;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTablePropertyType;
import org.apache.impala.util.MetaStoreUtil;

public class AlterViewUnSetTblProperties
extends AlterTableStmt {
    private final List<String> tblPropertyKeys_;
    private final boolean ifExists_;

    public AlterViewUnSetTblProperties(TableName tableName, boolean ifExist, List<String> tblPropertyKeys) {
        super(tableName);
        Preconditions.checkNotNull(tblPropertyKeys);
        this.tblPropertyKeys_ = tblPropertyKeys;
        this.ifExists_ = ifExist;
    }

    @Override
    public String getOperation() {
        return "UNSET TBLPROPERTIES";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = new TAlterTableParams();
        params.setTable_name(new TTableName(this.getDb(), this.getTbl()));
        params.setAlter_type(TAlterTableType.UNSET_VIEW_PROPERTIES);
        TAlterTableUnSetTblPropertiesParams tblUnsetPropertyParams = new TAlterTableUnSetTblPropertiesParams();
        tblUnsetPropertyParams.setTarget(TTablePropertyType.TBL_PROPERTY);
        tblUnsetPropertyParams.setProperty_keys(this.tblPropertyKeys_);
        tblUnsetPropertyParams.setIf_exists(this.ifExists_);
        params.setUnset_tbl_properties_params(tblUnsetPropertyParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        for (String property : this.tblPropertyKeys_) {
            MetaStoreUtil.checkShortProperty("Property key", property, 256);
        }
        this.table_ = analyzer.getTable(this.tableName_, Privilege.ALTER);
        Preconditions.checkNotNull((Object)this.table_);
        if (this.table_ instanceof MaterializedViewHdfsTable) {
            throw new AnalysisException(String.format("ALTER VIEW not allowed on a materialized view: %s", this.tableName_));
        }
        if (!(this.table_ instanceof FeView)) {
            throw new AnalysisException(String.format("ALTER VIEW not allowed on a table: %s", this.tableName_));
        }
        if (this.tblPropertyKeys_.contains("storage_handler")) {
            throw new AnalysisException(String.format("Changing the '%s' view property is not supported to protect against metadata corruption.", "storage_handler"));
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER VIEW ");
        if (this.tableName_.getDb() != null) {
            sb.append(this.tableName_.getDb() + ".");
        }
        sb.append(this.tableName_.getTbl());
        sb.append(" UNSET TBLPROPERTIES ('" + Joiner.on((String)"', '").join(this.tblPropertyKeys_) + "')");
        return sb.toString();
    }
}

