/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.impala.analysis.AlterTableSetStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.MaterializedViewHdfsTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetTblPropertiesParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTablePropertyType;
import org.apache.impala.util.MetaStoreUtil;

public class AlterViewSetTblProperties
extends AlterTableSetStmt {
    private final Map<String, String> tblProperties_;

    public AlterViewSetTblProperties(TableName tableName, Map<String, String> tblProperties) {
        super(tableName, null);
        Preconditions.checkNotNull(tblProperties);
        this.tblProperties_ = tblProperties;
        CreateTableStmt.unescapeProperties(this.tblProperties_);
    }

    @Override
    public String getOperation() {
        return "SET TBLPROPERTIES";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = new TAlterTableParams();
        params.setTable_name(new TTableName(this.getDb(), this.getTbl()));
        params.setAlter_type(TAlterTableType.SET_VIEW_PROPERTIES);
        TAlterTableSetTblPropertiesParams tblPropertyParams = new TAlterTableSetTblPropertiesParams();
        tblPropertyParams.setTarget(TTablePropertyType.TBL_PROPERTY);
        tblPropertyParams.setProperties(this.tblProperties_);
        params.setSet_tbl_properties_params(tblPropertyParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        MetaStoreUtil.checkShortPropertyMap("Property", this.tblProperties_);
        this.table_ = analyzer.getTable(this.tableName_, Privilege.ALTER);
        Preconditions.checkNotNull((Object)this.table_);
        if (this.table_ instanceof MaterializedViewHdfsTable) {
            throw new AnalysisException(String.format("ALTER VIEW not allowed on a materialized view: %s", this.tableName_));
        }
        if (!(this.table_ instanceof FeView)) {
            throw new AnalysisException(String.format("ALTER VIEW not allowed on a table: %s", this.tableName_));
        }
        if (this.tblProperties_.containsKey("storage_handler")) {
            throw new AnalysisException(String.format("Changing the '%s' view property is not supported to protect against metadata corruption.", "storage_handler"));
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER VIEW ");
        if (this.tableName_.getDb() != null) {
            sb.append(this.tableName_.getDb() + ".");
        }
        sb.append(this.tableName_.getTbl());
        sb.append(" SET TBLPROPERTIES " + ToSqlUtils.propertyMapToSql(this.tblProperties_));
        return sb.toString();
    }
}

