/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.AlterTableAddColsStmt;
import org.apache.impala.analysis.AlterTableAlterColStmt;
import org.apache.impala.analysis.AlterTableDropColStmt;
import org.apache.impala.analysis.AlterTableSetColumnStats;
import org.apache.impala.analysis.AlterTableSetTblProperties;
import org.apache.impala.analysis.AlterTableUnSetTblProperties;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TTableName;

public abstract class AlterTableStmt
extends StatementBase {
    protected TableName tableName_;
    protected FeTable table_;

    protected AlterTableStmt(TableName tableName) {
        Preconditions.checkState((tableName != null && !tableName.isEmpty() ? 1 : 0) != 0);
        this.tableName_ = tableName;
        this.table_ = null;
    }

    public abstract String getOperation();

    public String getTbl() {
        return this.tableName_.getTbl();
    }

    public String getDb() {
        return this.getTargetTable().getDb().getName();
    }

    protected FeTable getTargetTable() {
        Preconditions.checkNotNull((Object)this.table_);
        return this.table_;
    }

    public TAlterTableParams toThrift() {
        TAlterTableParams params = new TAlterTableParams();
        params.setTable_name(new TTableName(this.getDb(), this.getTbl()));
        return params;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        TableRef tableRef = new TableRef(this.tableName_.toPath(), null, Privilege.ALTER);
        tableRef = analyzer.resolveTableRef(tableRef);
        Preconditions.checkNotNull((Object)tableRef);
        tableRef.analyze(analyzer);
        if (tableRef instanceof InlineViewRef) {
            throw new AnalysisException(String.format("ALTER TABLE not allowed on a view: %s", this.tableName_));
        }
        if (tableRef instanceof CollectionTableRef) {
            throw new AnalysisException(String.format("ALTER TABLE not allowed on a nested collection: %s", this.tableName_));
        }
        Preconditions.checkState((boolean)(tableRef instanceof BaseTableRef));
        this.table_ = tableRef.getTable();
        Analyzer.checkTableCapability(this.table_, Analyzer.OperationType.WRITE);
        this.checkTransactionalTable();
        if (!(!(this.table_ instanceof FeDataSourceTable) || this instanceof AlterTableSetColumnStats || this instanceof AlterTableAddColsStmt || this instanceof AlterTableAlterColStmt || this instanceof AlterTableDropColStmt || this instanceof AlterTableSetTblProperties || this instanceof AlterTableUnSetTblProperties)) {
            boolean storedByJdbc = ((FeDataSourceTable)this.table_).isJdbcDataSourceTable();
            throw new AnalysisException(String.format("ALTER TABLE %s not allowed on a table %s: %s", this.getOperation(), storedByJdbc ? "STORED BY JDBC" : "PRODUCED BY DATA SOURCE", this.tableName_));
        }
    }

    protected void checkTransactionalTable() throws AnalysisException {
        Analyzer.ensureTableNotTransactional(this.table_, "ALTER TABLE");
    }
}

