/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.TableDef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetTblPropertiesParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.thrift.TTablePropertyType;

public class AlterTableSortByStmt
extends AlterTableStmt {
    public static final String TBL_PROP_SORT_COLUMNS = "sort.columns";
    public static final String TBL_PROP_SORT_ORDER = "sort.order";
    private final List<String> columns_;
    private final TSortingOrder sortingOrder_;

    public AlterTableSortByStmt(TableName tableName, List<String> columns, TSortingOrder sortingOrder) {
        super(tableName);
        Preconditions.checkNotNull(columns);
        this.columns_ = columns;
        this.sortingOrder_ = sortingOrder;
    }

    @Override
    public String getOperation() {
        return "SORT BY";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.SET_TBL_PROPERTIES);
        TAlterTableSetTblPropertiesParams tblPropertyParams = new TAlterTableSetTblPropertiesParams();
        tblPropertyParams.setTarget(TTablePropertyType.TBL_PROPERTY);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(TBL_PROP_SORT_COLUMNS, Joiner.on((String)",").join(this.columns_));
        properties.put(TBL_PROP_SORT_ORDER, this.sortingOrder_.toString());
        tblPropertyParams.setProperties(properties);
        params.setSet_tbl_properties_params(tblPropertyParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable targetTable = this.getTargetTable();
        if (targetTable instanceof FeHBaseTable) {
            throw new AnalysisException(String.format("ALTER TABLE SORT BY not supported on HBase tables.", new Object[0]));
        }
        if (targetTable instanceof FeKuduTable) {
            throw new AnalysisException(String.format("ALTER TABLE SORT BY not supported on Kudu tables.", new Object[0]));
        }
        TableDef.analyzeSortColumns(this.columns_, targetTable, this.sortingOrder_);
    }

    @Override
    protected void checkTransactionalTable() throws AnalysisException {
    }
}

