/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;

public abstract class AlterTableSetStmt
extends AlterTableStmt {
    protected final PartitionSet partitionSet_;

    protected AlterTableSetStmt(TableName tableName, PartitionSet partitionSet) {
        super(tableName);
        this.partitionSet_ = partitionSet;
        if (this.partitionSet_ != null) {
            this.partitionSet_.setTableName(tableName);
        }
    }

    PartitionSet getPartitionSet() {
        return this.partitionSet_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable t = this.getTargetTable();
        if (t instanceof FeHBaseTable) {
            throw new AnalysisException("ALTER TABLE SET not currently supported on HBase tables.");
        }
        if (this.partitionSet_ == null) {
            return;
        }
        this.partitionSet_.setPartitionShouldExist();
        this.partitionSet_.setPrivilegeRequirement(Privilege.ALTER);
        this.partitionSet_.analyze(analyzer);
    }
}

