/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.AlterTableSetStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.HdfsCachingOp;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetCachedParams;
import org.apache.impala.thrift.TAlterTableType;

public class AlterTableSetCachedStmt
extends AlterTableSetStmt {
    private final HdfsCachingOp cacheOp_;

    public AlterTableSetCachedStmt(TableName tableName, PartitionSet partitionSet, HdfsCachingOp cacheOp) {
        super(tableName, partitionSet);
        Preconditions.checkNotNull((Object)cacheOp);
        this.cacheOp_ = cacheOp;
    }

    @Override
    public String getOperation() {
        return this.cacheOp_.shouldCache() ? "SET CACHED" : "SET UNCACHED";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.SET_CACHED);
        TAlterTableSetCachedParams cachingParams = new TAlterTableSetCachedParams();
        if (this.getPartitionSet() != null) {
            cachingParams.setPartition_set(this.getPartitionSet().toThrift());
        }
        cachingParams.setCache_op(this.cacheOp_.toThrift());
        params.setSet_cached_params(cachingParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.cacheOp_.analyze(analyzer);
        FeTable table = this.getTargetTable();
        Preconditions.checkNotNull((Object)table);
        if (!(table instanceof FeFsTable)) {
            throw new AnalysisException("ALTER TABLE SET [CACHED|UNCACHED] must target an HDFS table: " + table.getFullName());
        }
        if (this.cacheOp_.shouldCache()) {
            boolean isCacheable = true;
            PartitionSet partitionSet = this.getPartitionSet();
            FeFsTable hdfsTable = (FeFsTable)table;
            StringBuilder nameSb = new StringBuilder();
            if (partitionSet != null) {
                List<? extends FeFsPartition> parts = partitionSet.getPartitions();
                nameSb.append("Partition(s) (");
                for (FeFsPartition feFsPartition : parts) {
                    boolean bl = isCacheable = isCacheable && feFsPartition.isCacheable();
                    if (feFsPartition.isCacheable()) continue;
                    nameSb.append(feFsPartition.getPartitionName());
                }
                nameSb.append(")");
            } else {
                isCacheable = hdfsTable.isCacheable();
                nameSb.append("Table ").append(table.getFullName());
            }
            if (!isCacheable) {
                throw new AnalysisException(nameSb.toString() + " cannot be cached. Please check if the table or partitions are on a filesystem which supports caching.");
            }
        }
    }
}

