/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableReplaceColsParams;
import org.apache.impala.thrift.TAlterTableType;

public class AlterTableReplaceColsStmt
extends AlterTableStmt {
    private final List<ColumnDef> columnDefs_;

    public AlterTableReplaceColsStmt(TableName tableName, List<ColumnDef> columnDefs) {
        super(tableName);
        Preconditions.checkState((columnDefs != null && columnDefs.size() > 0 ? 1 : 0) != 0);
        this.columnDefs_ = Lists.newArrayList(columnDefs);
    }

    @Override
    public String getOperation() {
        return "REPLACE COLUMNS";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable t = this.getTargetTable();
        if (t instanceof FeHBaseTable) {
            throw new AnalysisException("ALTER TABLE REPLACE COLUMNS not currently supported on HBase tables.");
        }
        boolean isKuduTable = t instanceof FeKuduTable;
        if (isKuduTable) {
            throw new AnalysisException("ALTER TABLE REPLACE COLUMNS is not supported on Kudu tables.");
        }
        if (t instanceof FeIcebergTable) {
            throw new AnalysisException("ALTER TABLE REPLACE COLUMNS is not supported on Iceberg tables.");
        }
        HashSet<String> existingPartitionKeys = new HashSet<String>();
        for (FieldSchema fs : t.getMetaStoreTable().getPartitionKeys()) {
            existingPartitionKeys.add(fs.getName().toLowerCase());
        }
        HashSet<String> colNames = new HashSet<String>();
        for (ColumnDef c : this.columnDefs_) {
            c.analyze(analyzer);
            String colName = c.getColName().toLowerCase();
            if (existingPartitionKeys.contains(colName)) {
                throw new AnalysisException("Column name conflicts with existing partition column: " + colName);
            }
            if (colNames.add(colName)) continue;
            throw new AnalysisException("Duplicate column name: " + colName);
        }
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.REPLACE_COLUMNS);
        TAlterTableReplaceColsParams colParams = new TAlterTableReplaceColsParams();
        for (ColumnDef col : this.columnDefs_) {
            colParams.addToColumns(col.toThrift());
        }
        params.setReplace_cols_params(colParams);
        return params;
    }
}

