/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;

public class AlterTableRecoverPartitionsStmt
extends AlterTableStmt {
    public AlterTableRecoverPartitionsStmt(TableName tableName) {
        super(tableName);
    }

    @Override
    public String getOperation() {
        return "RECOVER PARTITIONS";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.RECOVER_PARTITIONS);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        if (!(this.table_ instanceof FeFsTable)) {
            throw new AnalysisException("ALTER TABLE RECOVER PARTITIONS must target an HDFS table: " + this.tableName_);
        }
        if (this.table_ instanceof FeIcebergTable) {
            throw new AnalysisException("ALTER TABLE RECOVER PARTITIONS is not supported on Iceberg tables: " + this.table_.getFullName());
        }
        if (this.table_.getMetaStoreTable().getPartitionKeysSize() == 0) {
            throw new AnalysisException("Table is not partitioned: " + this.tableName_);
        }
    }
}

