/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeView;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TAlterTableOrViewRenameParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TTableName;

public class AlterTableOrViewRenameStmt
extends AlterTableStmt {
    protected final TableName newTableName_;
    protected String newDbName_;
    protected final boolean renameTable_;

    public AlterTableOrViewRenameStmt(TableName oldTableName, TableName newTableName, boolean renameTable) {
        super(oldTableName);
        Preconditions.checkState((newTableName != null && !newTableName.isEmpty() ? 1 : 0) != 0);
        this.newTableName_ = newTableName;
        this.renameTable_ = renameTable;
    }

    public String getNewTbl() {
        return this.newTableName_.getTbl();
    }

    public String getNewDb() {
        Preconditions.checkNotNull((Object)this.newDbName_);
        return this.newDbName_;
    }

    @Override
    public String getOperation() {
        return "RENAME";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(this.renameTable_ ? TAlterTableType.RENAME_TABLE : TAlterTableType.RENAME_VIEW);
        TAlterTableOrViewRenameParams renameParams = new TAlterTableOrViewRenameParams(new TTableName(this.getNewDb(), this.getNewTbl()));
        params.setRename_params(renameParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        analyzer.getFqTableName(this.newTableName_).analyze();
        this.table_ = analyzer.getTable(this.tableName_, Privilege.ALL);
        if (this.table_ instanceof FeView && this.renameTable_) {
            throw new AnalysisException(String.format("ALTER TABLE not allowed on a view: %s", this.table_.getFullName()));
        }
        if (!(this.table_ instanceof FeView) && !this.renameTable_) {
            throw new AnalysisException(String.format("ALTER VIEW not allowed on a table: %s", this.table_.getFullName()));
        }
        this.newDbName_ = analyzer.getTargetDbName(this.newTableName_);
        if (analyzer.dbContainsTable(this.newDbName_, this.newTableName_.getTbl(), Privilege.CREATE)) {
            throw new AnalysisException("Table already exists: " + String.format("%s.%s", this.newDbName_, this.getNewTbl()));
        }
        analyzer.addAccessEvent(new TAccessEvent(this.newDbName_ + "." + this.newTableName_.getTbl(), this.table_.getCatalogObjectType(), Privilege.CREATE.toString()));
    }
}

