/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.analysis.AlterTableExecuteExpireSnapshotsStmt;
import org.apache.impala.analysis.AlterTableExecuteRollbackStmt;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.TableName;
import org.apache.impala.common.AnalysisException;

public class AlterTableExecuteStmt
extends AlterTableStmt {
    protected FunctionCallExpr fnCallExpr_;
    protected Expr fnParamValue_;
    protected long olderThanMillis_ = -1L;

    protected AlterTableExecuteStmt(TableName tableName, Expr fnCallExpr) {
        super(tableName);
        this.fnCallExpr_ = (FunctionCallExpr)fnCallExpr;
    }

    @Override
    public String getOperation() {
        return "EXECUTE";
    }

    public static AlterTableStmt createExecuteStmt(TableName tableName, Expr expr) throws AnalysisException {
        String functionName;
        FunctionCallExpr fnCallExpr = (FunctionCallExpr)expr;
        String functionNameOrig = fnCallExpr.getFnName().toString();
        switch (functionName = functionNameOrig.toUpperCase()) {
            case "EXPIRE_SNAPSHOTS": {
                return new AlterTableExecuteExpireSnapshotsStmt(tableName, fnCallExpr);
            }
            case "ROLLBACK": {
                return new AlterTableExecuteRollbackStmt(tableName, fnCallExpr);
            }
        }
        throw new AnalysisException(String.format("'%s' is not supported by ALTER TABLE <table> EXECUTE. Supported operations are: EXPIRE_SNAPSHOTS(<expression>), ROLLBACK(<expression>).", functionNameOrig));
    }

    protected void analyzeFunctionCallExpr(Analyzer ignoredAnalyzer, String usage) throws AnalysisException {
        String fnName = this.fnCallExpr_.getFnName().toString();
        Preconditions.checkState((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)fnName, (CharSequence[])new CharSequence[]{"EXPIRE_SNAPSHOTS", "ROLLBACK"}));
        if (this.fnCallExpr_.getParams().size() != 1) {
            throw new AnalysisException(usage + " must have one parameter: " + this.toSql());
        }
        this.fnParamValue_ = this.fnCallExpr_.getParams().exprs().get(0);
    }
}

