/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.AlterTableExecuteStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TAlterTableExecuteParams;
import org.apache.impala.thrift.TAlterTableExecuteRollbackParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TRollbackType;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableExecuteRollbackStmt
extends AlterTableExecuteStmt {
    public static final String USAGE = "EXECUTE ROLLBACK(<expression>):";
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableExecuteRollbackStmt.class);
    private long snapshotVersion_;
    private TRollbackType kind_;

    public AlterTableExecuteRollbackStmt(TableName tableName, FunctionCallExpr fnCallExpr) {
        super(tableName, fnCallExpr);
    }

    @Override
    public String getOperation() {
        return "EXECUTE ROLLBACK";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable table = this.getTargetTable();
        if (!(table instanceof FeIcebergTable)) {
            throw new AnalysisException("ALTER TABLE EXECUTE ROLLBACK is only supported for Iceberg tables: " + table.getTableName());
        }
        this.analyzeFunctionCallExpr(analyzer, USAGE);
        this.analyzeParameter(analyzer);
    }

    private void analyzeParameter(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.fnParamValue_);
        this.fnParamValue_.analyze(analyzer);
        if (!this.fnParamValue_.isConstant()) {
            throw new AnalysisException("EXECUTE ROLLBACK(<expression>): <expression> must be a constant expression: EXECUTE " + this.toSql());
        }
        if (this.fnParamValue_ instanceof LiteralExpr && this.fnParamValue_.getType().isIntegerType()) {
            this.kind_ = TRollbackType.VERSION_ID;
            this.snapshotVersion_ = this.fnParamValue_.evalToInteger(analyzer, USAGE);
            if (this.snapshotVersion_ < 0L) {
                throw new AnalysisException("Invalid version number has been given to EXECUTE ROLLBACK(<expression>):: " + this.snapshotVersion_);
            }
            LOG.debug("EXECUTE ROLLBACK(<expression>): version: " + this.snapshotVersion_);
        } else {
            Expr timestampEpr = this.getParamConvertibleToTimestamp();
            if (timestampEpr != null) {
                this.kind_ = TRollbackType.TIME_ID;
                try {
                    this.olderThanMillis_ = ExprUtil.localTimestampToUnixTimeMicros(analyzer, timestampEpr) / 1000L;
                    LOG.debug("EXECUTE ROLLBACK(<expression>): millis: " + this.olderThanMillis_);
                }
                catch (InternalException ie) {
                    throw new AnalysisException("An invalid TIMESTAMP expression has been given to EXECUTE ROLLBACK(<expression>): the expression " + this.fnParamValue_.toSql() + " cannot be converted to a TIMESTAMP", ie);
                }
            } else {
                throw new AnalysisException("EXECUTE ROLLBACK(<expression>): <expression> must be an integer type or a timestamp, but is '" + this.fnParamValue_.getType() + "': EXECUTE " + this.toSql());
            }
        }
    }

    private Expr getParamConvertibleToTimestamp() {
        Expr timestampExpr = this.fnParamValue_;
        if (timestampExpr.getType().isStringType()) {
            timestampExpr = new CastExpr(Type.TIMESTAMP, this.fnParamValue_);
        }
        if (timestampExpr.getType().isTimestamp()) {
            return timestampExpr;
        }
        return null;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return this.fnCallExpr_.toSql();
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.EXECUTE);
        TAlterTableExecuteParams executeParams = new TAlterTableExecuteParams();
        TAlterTableExecuteRollbackParams executeRollbackParams = new TAlterTableExecuteRollbackParams();
        executeParams.setExecute_rollback_params(executeRollbackParams);
        executeRollbackParams.setKind(this.kind_);
        switch (this.kind_) {
            case TIME_ID: {
                executeRollbackParams.setTimestamp_millis(this.olderThanMillis_);
                break;
            }
            case VERSION_ID: {
                executeRollbackParams.setSnapshot_id(this.snapshotVersion_);
                break;
            }
            default: {
                throw new IllegalStateException("Bad kind of execute rollback " + (Object)((Object)this.kind_));
            }
        }
        params.setSet_execute_params(executeParams);
        return params;
    }
}

