/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableDropColParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;

public class AlterTableDropColStmt
extends AlterTableStmt {
    private final String colName_;

    public AlterTableDropColStmt(TableName tableName, String colName) {
        super(tableName);
        Preconditions.checkState((colName != null && !colName.isEmpty() ? 1 : 0) != 0);
        this.colName_ = colName;
    }

    public String getColName() {
        return this.colName_;
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.DROP_COLUMN);
        TAlterTableDropColParams dropColParams = new TAlterTableDropColParams(this.colName_);
        params.setDrop_col_params(dropColParams);
        return params;
    }

    @Override
    public String getOperation() {
        return "DROP COLUMN";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable t = this.getTargetTable();
        if (t instanceof FeHBaseTable) {
            throw new AnalysisException("ALTER TABLE DROP COLUMN not currently supported on HBase tables.");
        }
        String tableName = this.getDb() + "." + this.getTbl();
        for (FieldSchema fs : t.getMetaStoreTable().getPartitionKeys()) {
            if (!fs.getName().toLowerCase().equals(this.colName_.toLowerCase())) continue;
            throw new AnalysisException("Cannot drop partition column: " + fs.getName());
        }
        if (t.getColumns().size() - t.getMetaStoreTable().getPartitionKeysSize() <= 1) {
            throw new AnalysisException(String.format("Cannot drop column '%s' from %s. Tables must contain at least 1 column.", this.colName_, tableName));
        }
        if (t.getColumn(this.colName_) == null) {
            throw new AnalysisException(String.format("Column '%s' does not exist in table: %s", this.colName_, tableName));
        }
    }
}

