/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableAlterColParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;

public class AlterTableAlterColStmt
extends AlterTableStmt {
    private final String colName_;
    private final ColumnDef newColDef_;
    private final boolean isDropDefault_;

    public static AlterTableAlterColStmt createChangeColStmt(TableName tableName, String colName, ColumnDef newColDef) {
        return new AlterTableAlterColStmt(tableName, colName, newColDef);
    }

    public static AlterTableAlterColStmt createDropDefaultStmt(TableName tableName, String colName) {
        HashMap<ColumnDef.Option, Object> option = new HashMap<ColumnDef.Option, Object>();
        option.put(ColumnDef.Option.DEFAULT, new NullLiteral());
        return new AlterTableAlterColStmt(tableName, colName, new ColumnDef(colName, null, option), true);
    }

    public AlterTableAlterColStmt(TableName tableName, String colName, ColumnDef newColDef) {
        this(tableName, colName, newColDef, false);
    }

    public AlterTableAlterColStmt(TableName tableName, String colName, ColumnDef newColDef, boolean isDropDefault) {
        super(tableName);
        Preconditions.checkNotNull((Object)newColDef);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)colName) ? 1 : 0) != 0);
        this.colName_ = colName;
        this.newColDef_ = newColDef;
        this.isDropDefault_ = isDropDefault;
    }

    public String getColName() {
        return this.colName_;
    }

    public ColumnDef getNewColDef() {
        return this.newColDef_;
    }

    @Override
    public String getOperation() {
        return "CHANGE COLUMN";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.ALTER_COLUMN);
        TAlterTableAlterColParams colParams = new TAlterTableAlterColParams();
        colParams.setCol_name(this.colName_);
        colParams.setNew_col_def(this.newColDef_.toThrift());
        params.setAlter_col_params(colParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable t = this.getTargetTable();
        if (t instanceof FeHBaseTable) {
            throw new AnalysisException("ALTER TABLE CHANGE/ALTER COLUMN not currently supported on HBase tables.");
        }
        String tableName = this.getDb() + "." + this.getTbl();
        Column column = t.getColumn(this.colName_);
        if (column == null) {
            throw new AnalysisException(String.format("Column '%s' does not exist in table: %s", this.colName_, tableName));
        }
        if (t.isClusteringColumn(column)) {
            throw new AnalysisException("Cannot modify partition column: " + this.colName_);
        }
        boolean alterColumnSetStmt = false;
        if (this.newColDef_.getTypeDef() == null) {
            this.newColDef_.setType(column.getType());
            alterColumnSetStmt = true;
        }
        this.newColDef_.analyze(analyzer);
        if (!this.colName_.toLowerCase().equals(this.newColDef_.getColName().toLowerCase()) && t.getColumn(this.newColDef_.getColName()) != null) {
            throw new AnalysisException("Column already exists: " + this.newColDef_.getColName());
        }
        if (this.newColDef_.hasKuduOptions()) {
            if (!(t instanceof FeKuduTable)) {
                if (this.isDropDefault_) {
                    throw new AnalysisException(String.format("Unsupported column option for non-Kudu table: DROP DEFAULT", new Object[0]));
                }
                throw new AnalysisException(String.format("Unsupported column options for non-Kudu table: '%s'", this.newColDef_.toString()));
            }
            if (!alterColumnSetStmt) {
                throw new AnalysisException(String.format("Unsupported column options in ALTER TABLE CHANGE COLUMN statement: '%s'. Use ALTER TABLE ALTER COLUMN instead.", this.newColDef_.toString()));
            }
        }
        if (t instanceof FeKuduTable) {
            KuduColumn col = (KuduColumn)t.getColumn(this.colName_);
            boolean isSystemGeneratedColumn = col.isAutoIncrementing();
            if (!col.getType().equals(this.newColDef_.getType())) {
                throw new AnalysisException(String.format("Cannot change the type of a Kudu column using an ALTER TABLE CHANGE COLUMN statement: (%s vs %s)", col.getType().toSql(), this.newColDef_.getType().toSql()));
            }
            if (col.isKey() && this.newColDef_.hasDefaultValue()) {
                throw new AnalysisException(String.format("Cannot %s default value for %sprimary key column '%s'", this.isDropDefault_ ? "drop" : "set", isSystemGeneratedColumn ? "system generated " : "", this.colName_));
            }
            if (this.newColDef_.isPrimaryKey()) {
                throw new AnalysisException("Altering a column to be a primary key is not supported.");
            }
            if (this.newColDef_.isNullabilitySet()) {
                throw new AnalysisException("Altering the nullability of a column is not supported.");
            }
        }
        if (t instanceof FeIcebergTable && (t.getColumn(this.colName_).getType().isComplexType() || this.newColDef_.getType().isComplexType())) {
            throw new AnalysisException(String.format("ALTER TABLE CHANGE COLUMN is not supported for complex types in Iceberg tables.", new Object[0]));
        }
        if (t instanceof FeDataSourceTable && !DataSourceTable.isSupportedColumnType(this.newColDef_.getType())) {
            throw new AnalysisException("Tables stored by JDBC do not support the column type: " + this.newColDef_.getType());
        }
    }
}

