/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.PartitionDef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableAddPartitionParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetFileFormatParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.THdfsFileFormat;

public class AlterTableAddPartitionStmt
extends AlterTableStmt {
    private final boolean ifNotExists_;
    private final List<PartitionDef> partitions_;
    private THdfsFileFormat fileFormat;

    public AlterTableAddPartitionStmt(TableName tableName, boolean ifNotExists, List<PartitionDef> partitions) {
        super(tableName);
        Preconditions.checkNotNull(partitions);
        Preconditions.checkState((!partitions.isEmpty() ? 1 : 0) != 0);
        this.partitions_ = partitions;
        this.ifNotExists_ = ifNotExists;
        for (PartitionDef p : this.partitions_) {
            p.setTableName(tableName);
            if (this.ifNotExists_) continue;
            p.setPartitionShouldNotExist();
        }
    }

    public AlterTableAddPartitionStmt(TableName tableName, boolean ifNotExists, List<PartitionDef> partitions, THdfsFileFormat fileFormat) {
        this(tableName, ifNotExists, partitions);
        this.fileFormat = fileFormat;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists_;
    }

    @Override
    public String getOperation() {
        StringBuilder sb = new StringBuilder("ADD ");
        if (this.ifNotExists_) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append("PARTITION");
        return sb.toString();
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ");
        if (this.getDb() != null) {
            sb.append(this.getDb() + ".");
        }
        sb.append(this.getTbl()).append(" ADD");
        if (this.ifNotExists_) {
            sb.append(" IF NOT EXISTS");
        }
        for (PartitionDef p : this.partitions_) {
            sb.append(" " + p.toSql(options));
        }
        if (this.fileFormat != null) {
            sb.append(" SET FILEFORMAT ");
            sb.append((Object)this.fileFormat);
        }
        return sb.toString();
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableAddPartitionParams addPartParams = new TAlterTableAddPartitionParams();
        addPartParams.setIf_not_exists(this.ifNotExists_);
        for (PartitionDef p : this.partitions_) {
            addPartParams.addToPartitions(p.toThrift());
        }
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.ADD_PARTITION);
        params.setAdd_partition_params(addPartParams);
        if (this.fileFormat != null) {
            TAlterTableSetFileFormatParams fileFormatParams = new TAlterTableSetFileFormatParams();
            fileFormatParams.setFile_format(this.fileFormat);
            params.setSet_file_format_params(fileFormatParams);
        }
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable table = this.getTargetTable();
        if (table instanceof FeKuduTable) {
            throw new AnalysisException("ALTER TABLE ADD PARTITION is not supported for Kudu tables: " + table.getTableName());
        }
        if (table instanceof FeIcebergTable) {
            throw new AnalysisException("ALTER TABLE ADD PARTITION is not supported for Iceberg tables: " + table.getTableName());
        }
        HashSet<String> partitionSpecs = new HashSet<String>();
        for (PartitionDef p : this.partitions_) {
            p.analyze(analyzer);
            if (partitionSpecs.add(p.getPartitionSpec().toCanonicalString())) continue;
            throw new AnalysisException(String.format("Duplicate partition spec: (%s)", Joiner.on((String)", ").join(p.getPartitionSpec().getPartitionSpecKeyValues())));
        }
    }

    @Override
    protected void checkTransactionalTable() throws AnalysisException {
    }
}

