/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.RangePartition;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableAddDropRangePartitionParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TRangePartitionOperationType;

public class AlterTableAddDropRangePartitionStmt
extends AlterTableStmt {
    private final boolean ignoreErrors_;
    private final RangePartition rangePartitionSpec_;
    private final Operation operation_;

    public AlterTableAddDropRangePartitionStmt(TableName tableName, RangePartition rangePartitionSpec, boolean ignoreErrors, Operation op) {
        super(tableName);
        Preconditions.checkNotNull((Object)rangePartitionSpec);
        this.rangePartitionSpec_ = rangePartitionSpec;
        this.ignoreErrors_ = ignoreErrors;
        this.operation_ = op;
    }

    @Override
    public String getOperation() {
        return this.operation_.name().toUpperCase();
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("ALTER TABLE " + this.getTbl());
        sb.append(" " + this.operation_.name());
        if (this.ignoreErrors_) {
            sb.append(" " + this.operation_.option());
        }
        sb.append(" " + this.rangePartitionSpec_.toSql(options));
        return sb.toString();
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.ADD_DROP_RANGE_PARTITION);
        TAlterTableAddDropRangePartitionParams partParams = new TAlterTableAddDropRangePartitionParams();
        partParams.setRange_partition_spec(this.rangePartitionSpec_.toThrift());
        partParams.setIgnore_errors(this.ignoreErrors_);
        partParams.setType(this.operation_.type());
        params.setAdd_drop_range_partition_params(partParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable table = this.getTargetTable();
        if (!(table instanceof FeKuduTable)) {
            throw new AnalysisException(String.format("Table %s does not support range partitions: RANGE %s", table.getFullName(), this.rangePartitionSpec_.toSql()));
        }
        FeKuduTable kuduTable = (FeKuduTable)table;
        List<String> colNames = FeKuduTable.Utils.getRangePartitioningColNames(kuduTable);
        if (colNames.isEmpty()) {
            throw new AnalysisException(String.format("Cannot add/drop partition %s: Kudu table %s doesn't have a range-based partitioning.", this.rangePartitionSpec_.toSql(), kuduTable.getName()));
        }
        ArrayList rangeColDefs = Lists.newArrayListWithCapacity((int)colNames.size());
        for (String colName : colNames) {
            Column col = kuduTable.getColumn(colName);
            ColumnDef colDef = new ColumnDef(col.getName(), new TypeDef(col.getType()));
            colDef.analyze(analyzer);
            rangeColDefs.add(colDef);
        }
        ArrayList<ColumnDef> pkColumnDefs = new ArrayList<ColumnDef>();
        for (String colName : kuduTable.getPrimaryKeyColumnNames()) {
            Column col = kuduTable.getColumn(colName);
            ColumnDef colDef = new ColumnDef(col.getName(), new TypeDef(col.getType()));
            colDef.analyze(analyzer);
            pkColumnDefs.add(colDef);
        }
        this.rangePartitionSpec_.setPkColumnDefMap(ColumnDef.mapByColumnNames(pkColumnDefs));
        this.rangePartitionSpec_.analyze(analyzer, rangeColDefs);
    }

    public static enum Operation {
        ADD("IF NOT EXISTS", TRangePartitionOperationType.ADD),
        DROP("IF EXISTS", TRangePartitionOperationType.DROP);

        private final String option_;
        private final TRangePartitionOperationType type_;

        private Operation(String option, TRangePartitionOperationType type) {
            this.option_ = option;
            this.type_ = type;
        }

        String option() {
            return this.option_;
        }

        TRangePartitionOperationType type() {
            return this.type_;
        }
    }
}

