/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableAddColsParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.util.KuduUtil;

public class AlterTableAddColsStmt
extends AlterTableStmt {
    private final boolean ifNotExists_;
    private final List<ColumnDef> columnDefs_;

    public AlterTableAddColsStmt(TableName tableName, boolean ifNotExists, List<ColumnDef> columnDefs) {
        super(tableName);
        this.ifNotExists_ = ifNotExists;
        Preconditions.checkState((columnDefs != null && columnDefs.size() > 0 ? 1 : 0) != 0);
        this.columnDefs_ = Lists.newArrayList(columnDefs);
    }

    @Override
    public String getOperation() {
        return "ADD COLUMNS";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable t = this.getTargetTable();
        if (t instanceof FeHBaseTable) {
            throw new AnalysisException("ALTER TABLE ADD COLUMNS not currently supported on HBase tables.");
        }
        HashSet<String> existingPartitionKeys = new HashSet<String>();
        for (FieldSchema fs : t.getMetaStoreTable().getPartitionKeys()) {
            existingPartitionKeys.add(fs.getName().toLowerCase());
        }
        HashSet<String> colNames = new HashSet<String>();
        Iterator<ColumnDef> iterator = this.columnDefs_.iterator();
        while (iterator.hasNext()) {
            ColumnDef c = iterator.next();
            c.analyze(analyzer);
            String colName = c.getColName().toLowerCase();
            if (existingPartitionKeys.contains(colName)) {
                throw new AnalysisException("Column name conflicts with existing partition column: " + colName);
            }
            Column col = t.getColumn(colName);
            if (col != null) {
                if (!this.ifNotExists_) {
                    throw new AnalysisException("Column already exists: " + colName);
                }
                iterator.remove();
                continue;
            }
            if (!colNames.add(colName)) {
                throw new AnalysisException("Duplicate column name: " + colName);
            }
            if (t instanceof FeKuduTable) {
                if (c.getType().isComplexType()) {
                    throw new AnalysisException("Kudu tables do not support complex types: " + c.toString());
                }
                if (c.isPrimaryKey()) {
                    throw new AnalysisException("Cannot add a " + KuduUtil.getPrimaryKeyString(c.isPrimaryKeyUnique()) + " using an ALTER TABLE ADD COLUMNS statement: " + c.toString());
                }
                if (!c.isExplicitNotNullable() || c.hasDefaultValue()) continue;
                throw new AnalysisException("A new non-null column must have a default value: " + c.toString());
            }
            if (c.hasKuduOptions()) {
                throw new AnalysisException("The specified column options are only supported in Kudu tables: " + c.toString());
            }
            if (!(t instanceof FeDataSourceTable) || DataSourceTable.isSupportedColumnType(c.getType())) continue;
            throw new AnalysisException("Tables stored by JDBC do not support the column type: " + c.getType());
        }
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.ADD_COLUMNS);
        TAlterTableAddColsParams colParams = new TAlterTableAddColsParams();
        for (ColumnDef col : this.columnDefs_) {
            colParams.addToColumns(col.toThrift());
        }
        colParams.setIf_not_exists(this.ifNotExists_);
        params.setAdd_cols_params(colParams);
        return params;
    }
}

