/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.AlterDbStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Owner;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterDbParams;
import org.apache.impala.thrift.TAlterDbSetOwnerParams;
import org.apache.impala.thrift.TAlterDbType;
import org.apache.impala.thrift.TOwnerType;

public class AlterDbSetOwnerStmt
extends AlterDbStmt {
    private final Owner owner_;
    private String serverName_;

    public AlterDbSetOwnerStmt(String dbName, Owner owner) {
        super(dbName);
        Preconditions.checkNotNull((Object)owner);
        this.owner_ = owner;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        AuthorizationFactory authzFactory;
        AuthorizationChecker authzChecker;
        analyzer.getDb(this.dbName_, Privilege.ALL, true, true);
        String ownerName = this.owner_.getOwnerName();
        if (ownerName.length() > 128) {
            throw new AnalysisException(String.format("Owner name exceeds maximum length of %d characters. The given owner name has %d characters.", 128, ownerName.length()));
        }
        if (analyzer.isAuthzEnabled() && this.owner_.getOwnerType() == TOwnerType.ROLE && !(authzChecker = (authzFactory = analyzer.getAuthzFactory()).newAuthorizationChecker()).roleExists(ownerName)) {
            throw new AnalysisException(String.format("Role '%s' does not exist.", ownerName));
        }
        this.serverName_ = analyzer.getServerName();
    }

    @Override
    public TAlterDbParams toThrift() {
        TAlterDbParams params = super.toThrift();
        params.setAlter_type(TAlterDbType.SET_OWNER);
        TAlterDbSetOwnerParams setOwnerParams = new TAlterDbSetOwnerParams();
        setOwnerParams.setOwner_type(this.owner_.getOwnerType());
        setOwnerParams.setOwner_name(this.owner_.getOwnerName());
        setOwnerParams.setServer_name(this.serverName_);
        params.setSet_owner_params(setOwnerParams);
        return params;
    }
}

