/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.AnalyticInfo;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregateInfoBase {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateInfoBase.class);
    protected List<Expr> groupingExprs_;
    protected List<FunctionCallExpr> aggregateExprs_;
    protected TupleDescriptor intermediateTupleDesc_;
    protected TupleDescriptor outputTupleDesc_;
    protected List<Integer> materializedSlots_ = new ArrayList<Integer>();

    protected AggregateInfoBase(List<Expr> groupingExprs, List<FunctionCallExpr> aggExprs) {
        Preconditions.checkState((groupingExprs != null || aggExprs != null ? 1 : 0) != 0);
        this.groupingExprs_ = groupingExprs != null ? Expr.cloneList(groupingExprs) : new ArrayList<Expr>();
        Preconditions.checkState((aggExprs != null || !(this instanceof AnalyticInfo) ? 1 : 0) != 0);
        this.aggregateExprs_ = aggExprs != null ? Expr.cloneList(aggExprs) : new ArrayList<FunctionCallExpr>();
    }

    protected AggregateInfoBase(AggregateInfoBase other) {
        this.groupingExprs_ = other.groupingExprs_ != null ? Expr.cloneList(other.groupingExprs_) : null;
        this.aggregateExprs_ = other.aggregateExprs_ != null ? Expr.cloneList(other.aggregateExprs_) : null;
        this.intermediateTupleDesc_ = other.intermediateTupleDesc_;
        this.outputTupleDesc_ = other.outputTupleDesc_;
        this.materializedSlots_ = Lists.newArrayList(other.materializedSlots_);
    }

    protected void createTupleDescs(Analyzer analyzer) {
        this.intermediateTupleDesc_ = this.createTupleDesc(analyzer, false);
        this.outputTupleDesc_ = AggregateInfoBase.requiresIntermediateTuple(this.aggregateExprs_) ? this.createTupleDesc(analyzer, true) : this.intermediateTupleDesc_;
    }

    private TupleDescriptor createTupleDesc(Analyzer analyzer, boolean isOutputTuple) {
        TupleDescriptor result = analyzer.getDescTbl().createTupleDescriptor(this.tupleDebugName() + (isOutputTuple ? "-out" : "-intermed"));
        ArrayList exprs = Lists.newArrayListWithCapacity((int)(this.groupingExprs_.size() + this.aggregateExprs_.size()));
        exprs.addAll(this.groupingExprs_);
        exprs.addAll(this.aggregateExprs_);
        int aggregateExprStartIndex = this.groupingExprs_.size();
        for (int i = 0; i < exprs.size(); ++i) {
            Type intermediateType;
            Expr expr = (Expr)exprs.get(i);
            SlotDescriptor slotDesc = analyzer.addSlotDescriptor(result);
            slotDesc.initFromExpr(expr);
            if (i < aggregateExprStartIndex) {
                if (expr.isConstant()) continue;
                analyzer.createAuxEqPredicate(new SlotRef(slotDesc), expr.clone());
                continue;
            }
            Preconditions.checkArgument((boolean)(expr instanceof FunctionCallExpr));
            FunctionCallExpr aggExpr = (FunctionCallExpr)expr;
            if (aggExpr.isMergeAggFn()) {
                slotDesc.setLabel(((Expr)aggExpr.getChild(0)).toSql());
                slotDesc.setSourceExpr((Expr)aggExpr.getChild(0));
            } else {
                slotDesc.setLabel(aggExpr.toSql());
                slotDesc.setSourceExpr(aggExpr);
            }
            if (aggExpr.getFnName().getFunction().equals("count") || aggExpr.getFnName().getFunction().equals("ndv") || aggExpr.getFnName().getFunction().equals("ndv_no_finalize")) {
                slotDesc.setIsNullable(false);
            }
            if (isOutputTuple || (intermediateType = ((AggregateFunction)aggExpr.fn_).getIntermediateType()) == null) continue;
            if (!intermediateType.isWildcardDecimal()) {
                slotDesc.setType(intermediateType);
                continue;
            }
            Preconditions.checkState((boolean)expr.getType().isDecimal());
        }
        if (LOG.isTraceEnabled()) {
            String prefix = isOutputTuple ? "result " : "intermediate ";
            LOG.trace(prefix + " tuple=" + result.debugString());
        }
        return result;
    }

    public abstract void materializeRequiredSlots(Analyzer var1, ExprSubstitutionMap var2);

    public List<Expr> getGroupingExprs() {
        return this.groupingExprs_;
    }

    public List<FunctionCallExpr> getAggregateExprs() {
        return this.aggregateExprs_;
    }

    public TupleDescriptor getOutputTupleDesc() {
        return this.outputTupleDesc_;
    }

    public TupleDescriptor getIntermediateTupleDesc() {
        return this.intermediateTupleDesc_;
    }

    public TupleId getIntermediateTupleId() {
        return this.intermediateTupleDesc_.getId();
    }

    public TupleId getOutputTupleId() {
        return this.outputTupleDesc_.getId();
    }

    public boolean requiresIntermediateTuple() {
        Preconditions.checkNotNull((Object)this.intermediateTupleDesc_);
        Preconditions.checkNotNull((Object)this.outputTupleDesc_);
        return this.intermediateTupleDesc_ != this.outputTupleDesc_;
    }

    public List<Integer> getMaterializedSlots() {
        return this.materializedSlots_;
    }

    public static <T extends Expr> boolean requiresIntermediateTuple(List<T> aggExprs) {
        for (Expr aggExpr : aggExprs) {
            Type intermediateType = ((AggregateFunction)aggExpr.fn_).getIntermediateType();
            if (intermediateType == null) continue;
            return true;
        }
        return false;
    }

    public String debugString() {
        StringBuilder out = new StringBuilder();
        out.append(MoreObjects.toStringHelper((Object)this).add("grouping_exprs", (Object)Expr.debugString(this.groupingExprs_)).add("aggregate_exprs", (Object)Expr.debugString(this.aggregateExprs_)).add("intermediate_tuple", (Object)(this.intermediateTupleDesc_ == null ? "null" : this.intermediateTupleDesc_.debugString())).add("output_tuple", (Object)(this.outputTupleDesc_ == null ? "null" : this.outputTupleDesc_.debugString())).toString());
        return out.toString();
    }

    protected abstract String tupleDebugName();
}

