/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.util.ThreadNameAnnotator;
import org.junit.Assert;
import org.junit.Test;

public class ThreadNameAnnotatorTest {
    @Test
    public void testAnnotator() throws InterruptedException {
        Stepper stepper = new Stepper();
        AnnotatedThread thread = new AnnotatedThread("orig", stepper);
        Assert.assertEquals((Object)"orig", (Object)thread.getName());
        thread.start();
        stepper.waitForState("before");
        Assert.assertEquals((Object)"orig", (Object)thread.getName());
        stepper.advance("annotate", "annotated");
        Assert.assertEquals((Object)"orig [annotated]", (Object)thread.getName());
        stepper.advance("continue", "after");
        Assert.assertEquals((Object)"orig", (Object)thread.getName());
        stepper.setState("done");
        thread.join();
        Assert.assertEquals((Object)"orig", (Object)thread.getName());
    }

    @Test
    public void testExternalRename() throws InterruptedException {
        Stepper stepper = new Stepper();
        AnnotatedThread thread = new AnnotatedThread("orig", stepper);
        Assert.assertEquals((Object)"orig", (Object)thread.getName());
        thread.start();
        stepper.waitForState("before");
        Assert.assertEquals((Object)"orig", (Object)thread.getName());
        stepper.advance("annotate", "annotated");
        Assert.assertEquals((Object)"orig [annotated]", (Object)thread.getName());
        thread.setName("gotcha");
        stepper.advance("continue", "after");
        Assert.assertEquals((Object)"gotcha", (Object)thread.getName());
        stepper.setState("done");
        thread.join();
        Assert.assertEquals((Object)"gotcha", (Object)thread.getName());
    }

    @Test
    public void testDefaultName() throws InterruptedException {
        Stepper stepper = new Stepper();
        AnnotatedThread thread = new AnnotatedThread(stepper);
        String orig = thread.getName();
        thread.start();
        stepper.waitForState("before");
        Assert.assertEquals((Object)orig, (Object)thread.getName());
        stepper.advance("annotate", "annotated");
        Assert.assertEquals((Object)(orig + " [annotated]"), (Object)thread.getName());
        stepper.advance("continue", "after");
        Assert.assertEquals((Object)orig, (Object)thread.getName());
        stepper.setState("done");
        thread.join();
        Assert.assertEquals((Object)orig, (Object)thread.getName());
    }

    public static class AnnotatedThread
    extends Thread {
        private final Stepper stepper_;

        public AnnotatedThread(Stepper stepper) {
            this.stepper_ = stepper;
        }

        public AnnotatedThread(String name, Stepper stepper) {
            super(name);
            this.stepper_ = stepper;
        }

        @Override
        public void run() {
            try {
                this.stepper_.advance("before", "annotate");
                try (ThreadNameAnnotator tna = new ThreadNameAnnotator("annotated");){
                    this.stepper_.advance("annotated", "continue");
                }
                this.stepper_.advance("after", "done");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class Stepper {
        private String state_ = "<start>";

        private Stepper() {
        }

        public synchronized void setState(String state) {
            this.state_ = state;
            this.notifyAll();
        }

        public synchronized void waitForState(String state) {
            while (!this.state_.equals(state)) {
                try {
                    this.wait(15000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Test timed out, likely test flow error");
                    continue;
                }
                break;
            }
            return;
        }

        public void advance(String newState, String waitFor) throws InterruptedException {
            this.setState(newState);
            this.waitForState(waitFor);
        }
    }
}

