/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Function;
import java.util.List;
import org.apache.impala.util.TopNCache;
import org.junit.Assert;
import org.junit.Test;

public class TestTopNCache {
    private static TopNCache<Long, Long> createAndPopulate(int capacity, long numEntries, boolean policy) {
        TopNCache cache = new TopNCache((Function)new Function<Long, Long>(){

            public Long apply(Long element) {
                return element;
            }
        }, capacity, policy);
        for (long i = 0L; i < numEntries; ++i) {
            cache.putOrUpdate((Object)i);
        }
        return cache;
    }

    @Test
    public void testCreateAndPopulateCache() throws Exception {
        int[] capacities = new int[]{1, 10, 1000};
        boolean[] evictionPolicies = new boolean[]{true, false};
        for (int capacity : capacities) {
            for (boolean policy : evictionPolicies) {
                TopNCache<Long, Long> cache = TestTopNCache.createAndPopulate(capacity, 2 * capacity, policy);
                Assert.assertEquals((long)cache.listEntries().size(), (long)capacity);
                for (long i = 0L; i < (long)(capacity * 2); ++i) {
                    cache.remove((Object)i);
                }
                Assert.assertEquals((long)cache.listEntries().size(), (long)0L);
            }
        }
    }

    @Test
    public void testUpdateExistingElements() throws Exception {
        int capacity = 10;
        TopNCache<Long, Long> cache = TestTopNCache.createAndPopulate(10, 5L, true);
        Assert.assertEquals((long)cache.listEntries().size(), (long)5L);
        for (long i = 0L; i < 5L; ++i) {
            cache.putOrUpdate((Object)i);
        }
        Assert.assertEquals((long)cache.listEntries().size(), (long)5L);
    }

    @Test
    public void testAlwaysEvictPolicy() throws Exception {
        int capacity = 10;
        TopNCache<Long, Long> cache = TestTopNCache.createAndPopulate(10, 10L, true);
        Assert.assertEquals((long)cache.listEntries().size(), (long)10L);
        cache.putOrUpdate((Object)10L);
        Assert.assertEquals((long)cache.listEntries().size(), (long)10L);
        Assert.assertTrue((!cache.listEntries().contains(0L) ? 1 : 0) != 0);
        cache.putOrUpdate((Object)11L);
        Assert.assertTrue((!cache.listEntries().contains(1L) ? 1 : 0) != 0);
        List cacheElements = cache.listEntries();
        for (long i = 2L; i < 12L; ++i) {
            Assert.assertTrue((boolean)cacheElements.contains(i));
        }
    }

    @Test
    public void testRankBasedEvictionPolicy() throws Exception {
        int capacity = 10;
        TopNCache cache = new TopNCache((Function)new Function<Long, Long>(){

            public Long apply(Long element) {
                return element;
            }
        }, 10, false);
        for (long i = 1L; i < 11L; ++i) {
            cache.putOrUpdate((Object)i);
        }
        Assert.assertEquals((long)cache.listEntries().size(), (long)10L);
        cache.putOrUpdate((Object)0L);
        Assert.assertTrue((!cache.listEntries().contains(0L) ? 1 : 0) != 0);
        cache.putOrUpdate((Object)11L);
        Assert.assertEquals((long)cache.listEntries().size(), (long)10L);
        Assert.assertTrue((boolean)cache.listEntries().contains(11L));
    }

    @Test
    public void testRankBasedEvictionPolicyWithRandomInput() throws Exception {
        int capacity = 5;
        long[] values = new long[]{10L, 8L, 1L, 2L, 5L, 4L, 3L, 6L, 9L, 7L};
        TopNCache cache = new TopNCache((Function)new Function<Long, Long>(){

            public Long apply(Long element) {
                return element;
            }
        }, 5, false);
        long[] lArray = values;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long entry = lArray[i];
            cache.putOrUpdate((Object)entry);
        }
        List entries = cache.listEntries();
        Assert.assertEquals((long)entries.size(), (long)5L);
        for (long i = 1L; i <= 5L; ++i) {
            Assert.assertTrue((!entries.contains(i) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)entries.contains(i + 5L));
        }
    }
}

